/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json.serial;

import alexiil.mc.mod.load.json.JsonVariable;
import alexiil.mc.mod.load.json.serial.IThrowingDeserialiser;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

public enum VariableArrayDeserialiser implements IThrowingDeserialiser<JsonVariable[]>
{
    CONSTANTS(true),
    VARIABLES(false);

    final boolean constant;

    private VariableArrayDeserialiser(boolean constant) {
        this.constant = constant;
    }

    @Override
    public JsonVariable[] deserialize0(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws InvalidExpressionException {
        JsonObject obj = json.getAsJsonObject();
        Set entrySet = obj.entrySet();
        JsonVariable[] vars = new JsonVariable[entrySet.size()];
        int i = 0;
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            JsonElement jvalue = (JsonElement)entry.getValue();
            String value = jvalue.getAsString();
            JsonVariable var = new JsonVariable(this.constant, name, value);
            var.setSource(jvalue);
            vars[i++] = var;
        }
        return vars;
    }
}

