/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.data.vector;

import com.builtbroken.jlib.data.vector.IPos2D;
import com.builtbroken.jlib.data.vector.Pos2DBean;

public abstract class Pos2D<R extends Pos2D>
extends Pos2DBean {
    public Pos2D(double x, double y) {
        super(x, y);
    }

    public Pos2D() {
        this(0.0, 0.0);
    }

    public R add(double x, double y) {
        return this.newPos(x + this.x(), y + this.y());
    }

    public R add(IPos2D other) {
        return this.add(other.x(), other.y());
    }

    public R add(double a) {
        return this.add(a, a);
    }

    public R sub(double x, double y) {
        return this.add(-x, -y);
    }

    public R sub(IPos2D other) {
        return this.sub(other.x(), other.y());
    }

    public R sub(double a) {
        return this.sub(a, a);
    }

    public R multiply(IPos2D pos) {
        return this.newPos(pos.x() * this.x(), pos.y() * this.y());
    }

    public R multiply(double x, double y) {
        return this.newPos(x * this.x(), y * this.y());
    }

    public R multiply(double a) {
        return this.multiply(a, a);
    }

    public R divide(IPos2D pos) {
        return this.newPos(this.x() / pos.x(), this.y() / pos.y());
    }

    public R divide(double x, double y) {
        return this.newPos(this.x() / x, this.y() / y);
    }

    public R divide(double a) {
        return this.divide(a, a);
    }

    public R rotate(double angle) {
        return this.newPos(this.x() * Math.cos(angle) - this.y() * Math.sin(angle), this.x() * Math.sin(angle) + this.y() * Math.cos(angle));
    }

    public double dotProduct(IPos2D other) {
        return this.x() * other.x() + this.y() * other.y();
    }

    public double magnitudeSquared() {
        return this.x() * this.x() + this.y() * this.y();
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public R normalize() {
        if (this.x() == 0.0 && this.y() == 0.0) {
            return this.newPos(0.0, 0.0);
        }
        return this.divide(this.magnitude());
    }

    public double distance(IPos2D other) {
        return ((Pos2D)this.sub(other)).magnitude();
    }

    public R midpoint(IPos2D other) {
        return ((Pos2D)this.add(other)).divide(2.0);
    }

    public boolean isZero() {
        return this.x() == 0.0 && this.y() == 0.0;
    }

    public double slope(IPos2D other) {
        return (this.y() - other.y()) / (this.x() - other.x());
    }

    public R round() {
        return this.newPos(Math.round(this.x()), Math.round(this.y()));
    }

    public R ceil() {
        return this.newPos(Math.ceil(this.x()), Math.ceil(this.y()));
    }

    public R floor() {
        return this.newPos(Math.floor(this.x()), Math.floor(this.y()));
    }

    public R max(IPos2D other) {
        return this.newPos(Math.max(this.x(), other.x()), Math.max(this.y(), other.y()));
    }

    public R min(IPos2D other) {
        return this.newPos(Math.min(this.x(), other.x()), Math.min(this.y(), other.y()));
    }

    public R reciprocal() {
        return this.newPos(1.0 / this.x(), 1.0 / this.y());
    }

    public R clone() {
        return this.newPos(this.x(), this.y());
    }

    public abstract R newPos(double var1, double var3);
}

