/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.CommonProxy;
import icbm.classic.api.missiles.parts.IMissileFlightLogic;
import icbm.classic.client.fx.ParticleAirICBM;
import icbm.classic.client.fx.ParticleLauncherSmoke;
import icbm.classic.client.fx.ParticleSmokeICBM;
import icbm.classic.client.render.entity.layer.LayerChickenHelmet;
import icbm.classic.config.ConfigClient;
import icbm.classic.content.missile.logic.flight.BallisticFlightLogic;
import icbm.classic.lib.transform.vector.Pos;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderChicken;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void init() {
        super.init();
        Render render = Minecraft.func_71410_x().func_175598_ae().func_78715_a(EntityChicken.class);
        if (render instanceof RenderChicken) {
            ((RenderChicken)render).func_177094_a((LayerRenderer)new LayerChickenHelmet((RenderChicken)render));
        }
    }

    @Override
    public void spawnSmoke(World world, Pos position, double v, double v1, double v2, float red, float green, float blue, float scale, int ticksToLive) {
        if (world != null) {
            ParticleSmokeICBM particleSmokeICBM = new ParticleSmokeICBM(world, position, v, v1, v2, scale);
            particleSmokeICBM.setColor(red, green, blue, true);
            particleSmokeICBM.setAge(ticksToLive);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleSmokeICBM);
        }
    }

    @Override
    public void spawnAirParticle(World world, double x, double y, double z, double v, double v1, double v2, float red, float green, float blue, float scale, int ticksToLive) {
        if (world != null) {
            ParticleAirICBM particleAirParticleICBM = new ParticleAirICBM(world, x, y, z, v, v1, v2, scale);
            particleAirParticleICBM.setColor(red, green, blue, true);
            particleAirParticleICBM.setAge(ticksToLive);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleAirParticleICBM);
        }
    }

    @Override
    public void spawnExplosionParticles(World world, double sourceX, double sourceY, double sourceZ, double blastScale, BlockPos blockPos) {
        double particleX = (float)blockPos.func_177958_n() + world.field_73012_v.nextFloat();
        double particleY = (float)blockPos.func_177956_o() + world.field_73012_v.nextFloat();
        double particleZ = (float)blockPos.func_177952_p() + world.field_73012_v.nextFloat();
        double particleMX = particleX - sourceX;
        double particleMY = particleY - sourceY;
        double particleMZ = particleZ - sourceZ;
        double speed = MathHelper.func_76133_a((double)(particleMX * particleMX + particleMY * particleMY + particleMZ * particleMZ));
        particleMX /= speed;
        particleMY /= speed;
        particleMZ /= speed;
        double multiplier = 0.5 / (speed / blastScale + 0.1);
        world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (particleX + sourceX) / 2.0, (particleY + sourceY) / 2.0, (particleZ + sourceZ) / 2.0, particleMX *= (multiplier *= (double)(world.field_73012_v.nextFloat() * world.field_73012_v.nextFloat() + 0.3f)), particleMY *= multiplier, particleMZ *= multiplier, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, particleX, particleY, particleZ, particleMX, particleMY, particleMZ, new int[0]);
    }

    @Override
    public void spawnMissileSmoke(Entity entity, IMissileFlightLogic flightLogic, int ticksInAir) {
        block3: {
            block4: {
                if (!entity.field_70170_p.field_72995_K || !ConfigClient.MISSILE_ENGINE_SMOKE) break block3;
                if (!(flightLogic instanceof BallisticFlightLogic)) break block4;
                if (!(entity.field_70181_x > -1.0)) break block3;
                Pos position = new Pos((IPos3D)entity);
                double distance = -1.2f;
                double y = Math.sin(Math.toRadians(entity.field_70125_A)) * distance;
                double dH = Math.cos(Math.toRadians(entity.field_70125_A)) * distance;
                double x = Math.sin(Math.toRadians(entity.field_70177_z)) * dH;
                double z = Math.cos(Math.toRadians(entity.field_70177_z)) * dH;
                position = (Pos)position.add(x, y, z);
                ((BallisticFlightLogic)flightLogic).getLastSmokePos().add(position);
                Pos lastPos = null;
                if (((BallisticFlightLogic)flightLogic).getLastSmokePos().size() > 5) {
                    lastPos = ((BallisticFlightLogic)flightLogic).getLastSmokePos().get(0);
                    ((BallisticFlightLogic)flightLogic).getLastSmokePos().remove(0);
                }
                this.spawnAirParticle(entity.field_70170_p, position.x(), position.y(), position.z(), -entity.field_70159_w * 0.75, -entity.field_70181_x * 0.75, -entity.field_70179_y * 0.75, 1.0f, 0.75f, 0.0f, 5.0f, 10);
                if (ticksInAir <= 5 || lastPos == null) break block3;
                for (int i = 0; i < 10; ++i) {
                    this.spawnAirParticle(entity.field_70170_p, lastPos.x(), lastPos.y(), lastPos.z(), -entity.field_70159_w * 0.5, -entity.field_70181_x * 0.5, -entity.field_70179_y * 0.5, 1.0f, 1.0f, 1.0f, (int)Math.max(1.0, 6.0 * (1.0 / (1.0 + entity.field_70163_u / 100.0))), 100);
                    position.multiply(1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random());
                }
                break block3;
            }
            Pos position = new Pos((IPos3D)entity);
            double distance = -1.2f;
            double y = Math.sin(Math.toRadians(entity.field_70125_A)) * distance;
            double dH = Math.cos(Math.toRadians(entity.field_70125_A)) * distance;
            double x = Math.sin(Math.toRadians(entity.field_70177_z)) * dH;
            double z = Math.cos(Math.toRadians(entity.field_70177_z)) * dH;
            position = (Pos)position.add(x, y, z);
            for (int i = 0; i < 10; ++i) {
                this.spawnAirParticle(entity.field_70170_p, position.x(), position.y(), position.z(), -entity.field_70159_w * 0.5, -entity.field_70181_x * 0.5, -entity.field_70179_y * 0.5, flightLogic.engineSmokeRed(entity), flightLogic.engineSmokeGreen(entity), flightLogic.engineSmokeBlue(entity), (int)Math.max(1.0, 6.0 * (1.0 / (1.0 + entity.field_70163_u / 100.0))), 100);
                position.multiply(1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random());
            }
        }
    }

    @Override
    public void spawnPadSmoke(Entity entity, IMissileFlightLogic flightLogic, int ticksInAir) {
        if (ConfigClient.MISSILE_LAUNCH_SMOKE) {
            World world = entity.field_70170_p;
            Random random = world.field_73012_v;
            double posX = entity.field_70165_t;
            double posY = entity.field_70163_u - 1.2;
            double posZ = entity.field_70161_v;
            for (int smokeCount = 0; smokeCount < 10; ++smokeCount) {
                double velX = (double)(random.nextFloat() - random.nextFloat()) * 0.3;
                double velY = 1.0 - (double)random.nextFloat() * 0.5;
                double velZ = (double)(random.nextFloat() - random.nextFloat()) * 0.3;
                ParticleLauncherSmoke particleAirParticleICBM = new ParticleLauncherSmoke(world, posX, posY, posZ, velX, -velY, velZ, 1.0f + 2.0f * random.nextFloat());
                particleAirParticleICBM.setColor(1.0f, 1.0f, 1.0f, true);
                particleAirParticleICBM.setAge(180);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleAirParticleICBM);
            }
        }
    }
}

