/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.gas;

import icbm.classic.ICBMClassic;
import icbm.classic.content.blast.BlastMutation;
import icbm.classic.content.blast.gas.BlastGasBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3i;

public class BlastContagious
extends BlastGasBase {
    public static final DamageSource CONTAGIOUS_DAMAGE = new DamageSource("icbm.contagious");
    public static final int DURATION = 600;
    public static final float red = 0.3f;
    public static final float green = 0.8f;
    public static final float blue = 0.0f;

    public BlastContagious() {
        super(600, false);
    }

    @Override
    protected boolean canEffectEntities() {
        return true;
    }

    @Override
    protected boolean canGasEffect(EntityLivingBase entity) {
        return super.canGasEffect(entity) && !entity.func_180431_b(CONTAGIOUS_DAMAGE);
    }

    @Override
    protected void applyEffect(EntityLivingBase entity, int hitCount) {
        ICBMClassic.contagios_potion.poisonEntity(this.location.toPos(), entity, 3);
        if (!BlastMutation.applyMutationEffect(entity) && hitCount > 10) {
            entity.func_70097_a(CONTAGIOUS_DAMAGE, ((float)hitCount - 10.0f) / 5.0f);
        }
    }

    @Override
    protected float getParticleColorRed(Vec3i pos) {
        return 0.3f;
    }

    @Override
    protected float getParticleColorGreen(Vec3i pos) {
        return 0.8f;
    }

    @Override
    protected float getParticleColorBlue(Vec3i pos) {
        return 0.0f;
    }
}

