/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.gas;

import icbm.classic.ICBMClassic;
import icbm.classic.api.explosion.IBlastTickable;
import icbm.classic.client.ICBMSounds;
import icbm.classic.content.blast.Blast;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public abstract class BlastGasBase
extends Blast
implements IBlastTickable {
    private static final int TICKS_BETWEEN_RUNS = 5;
    private static final BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
    protected int duration;
    private boolean playShortSoundFX;
    private int lastRadius = 0;
    private final HashSet<BlockPos> affectedBlocks = new HashSet();
    private final Queue<BlockPos> edgeBlocks = new LinkedList<BlockPos>();
    private final HashMap<EntityLivingBase, Integer> impactedEntityMap = new HashMap();

    public BlastGasBase(int duration, boolean playShortSoundFX) {
        this.duration = duration;
        this.playShortSoundFX = playShortSoundFX;
    }

    private double sizePercentageOverTime(int timePassed) {
        return Math.min(1.0f, 2.0f * (float)timePassed / (float)this.duration + 0.1f);
    }

    @Override
    public boolean doExplode(int callCount) {
        if (callCount == 0 && !this.playShortSoundFX) {
            ICBMSounds.DEBILITATION.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        }
        if (callCount % 5 == 0) {
            this.setEffectBoundsAndSpawnParticles(this.callCount);
            this.generateAudioEffect();
            if (this.canEffectEntities()) {
                double radius = this.getBlastRadius();
                AxisAlignedBB bounds = new AxisAlignedBB(this.location.x() - radius, this.location.y() - radius, this.location.z() - radius, this.location.x() + radius, this.location.y() + radius, this.location.z() + radius);
                List entityList = this.world().func_175647_a(EntityLivingBase.class, bounds, this::canGasEffect);
                for (EntityLivingBase entity : entityList) {
                    if (!this.impactedEntityMap.containsKey(entity)) {
                        this.impactedEntityMap.put(entity, 1);
                    } else {
                        this.impactedEntityMap.replace(entity, this.impactedEntityMap.get(entity) + 1);
                    }
                    int hitCount = this.impactedEntityMap.get(entity);
                    this.applyEffect(entity, hitCount);
                }
            }
            return this.callCount > this.duration;
        }
        return false;
    }

    protected abstract boolean canEffectEntities();

    protected void applyEffect(EntityLivingBase entity, int hitCount) {
    }

    protected boolean canGasEffect(EntityLivingBase entity) {
        if (entity.func_70089_S()) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                return false;
            }
            return this.affectedBlocks.contains(checkPos.func_189532_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
        }
        return false;
    }

    private void generateAudioEffect() {
        if (this.playShortSoundFX) {
            ICBMSounds.GAS_LEAK.play(this.field_77287_j, this.location.x() + 0.5, this.location.y() + 0.5, this.location.z() + 0.5, 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 1.0f, true);
        }
    }

    private void setEffectBoundsAndSpawnParticles(int timePassed) {
        int maxSize = (int)Math.ceil(this.getBlastRadius());
        int radius = (int)Math.floor((double)maxSize * this.sizePercentageOverTime(timePassed));
        if (this.lastRadius == radius) {
            return;
        }
        this.lastRadius = radius;
        int currentDistanceSQ = radius * radius;
        if (this.affectedBlocks.isEmpty()) {
            this.affectedBlocks.add(this.getPos());
            this.edgeBlocks.add(this.getPos());
        }
        if (this.edgeBlocks.isEmpty()) {
            this.affectedBlocks.stream().filter(pos -> Math.random() > 0.5).forEach(pos -> this.edgeBlocks.add((BlockPos)pos));
        }
        HashSet<BlockPos> hasPathed = new HashSet<BlockPos>();
        LinkedList<BlockPos> nextSet = new LinkedList<BlockPos>();
        while (this.edgeBlocks.peek() != null) {
            BlockPos edge = this.edgeBlocks.poll();
            for (EnumFacing facing : EnumFacing.values()) {
                checkPos.func_189533_g((Vec3i)edge);
                checkPos.func_189536_c(facing);
                if (hasPathed.contains(checkPos) || this.affectedBlocks.contains(checkPos) || !this.isInRange((Vec3i)checkPos, currentDistanceSQ)) continue;
                if (this.isValidPath((BlockPos)checkPos, facing)) {
                    BlockPos pos2 = checkPos.func_185334_h();
                    this.affectedBlocks.add(pos2);
                    nextSet.add(pos2);
                    this.spawnGasParticles((Vec3i)pos2);
                    continue;
                }
                hasPathed.add(checkPos.func_185334_h());
            }
        }
        this.edgeBlocks.addAll(nextSet);
    }

    private boolean isValidPath(BlockPos pos, EnumFacing direction) {
        IBlockState blockState = this.field_77287_j.func_180495_p(pos);
        AxisAlignedBB aabb = blockState.func_185890_d((IBlockAccess)this.field_77287_j, pos);
        if (aabb == null) {
            return true;
        }
        boolean xFull = aabb.field_72340_a == 0.0 && aabb.field_72336_d == 1.0;
        boolean yFull = aabb.field_72338_b == 0.0 && aabb.field_72337_e == 1.0;
        boolean zFull = aabb.field_72339_c == 0.0 && aabb.field_72334_f == 1.0;
        boolean isImpassable = false;
        if (direction == EnumFacing.UP || direction == EnumFacing.DOWN) {
            isImpassable = xFull && zFull;
        } else if (direction == EnumFacing.NORTH || direction == EnumFacing.SOUTH) {
            isImpassable = xFull && yFull;
        } else if (direction == EnumFacing.WEST || direction == EnumFacing.EAST) {
            isImpassable = zFull && yFull;
        }
        return !isImpassable;
    }

    private boolean isInRange(Vec3i pos, int radiusSq) {
        return (int)Math.floor(pos.func_177954_c((double)this.xi(), (double)this.yi(), (double)this.zi())) <= radiusSq;
    }

    protected void spawnGasParticles(Vec3i pos) {
        ICBMClassic.proxy.spawnAirParticle(this.field_77287_j, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (Math.random() - 0.5) / 2.0, (Math.random() - 0.5) / 2.0 - 0.1, (Math.random() - 0.5) / 2.0, this.getParticleColorRed(pos), this.getParticleColorGreen(pos), this.getParticleColorBlue(pos), 7.0f, this.duration);
    }

    protected float getParticleColorRed(Vec3i pos) {
        return (float)Math.random();
    }

    protected float getParticleColorGreen(Vec3i pos) {
        return (float)Math.random();
    }

    protected float getParticleColorBlue(Vec3i pos) {
        return (float)Math.random();
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.duration = nbt.func_74762_e("duration");
        this.playShortSoundFX = nbt.func_74767_n("playShortSoundFX");
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74757_a("playShortSoundFX", this.playShortSoundFX);
    }
}

