/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.redmatter.caps;

import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.explosion.redmatter.IBlastVelocity;
import icbm.classic.content.blast.redmatter.EntityRedmatter;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;

public class CapRedmatterPull
implements IBlastVelocity {
    private final EntityRedmatter redmatter;

    public CapRedmatterPull(EntityRedmatter redmatter) {
        this.redmatter = redmatter;
    }

    @Override
    public boolean onBlastApplyMotion(@Nullable Entity source, IBlast blast, double xDifference, double yDifference, double zDifference, double distance) {
        if (source instanceof EntityRedmatter) {
            this.handlePull((EntityRedmatter)source, xDifference, yDifference, zDifference, distance);
            return true;
        }
        return false;
    }

    private void handlePull(EntityRedmatter otherRedmatter, double xDifference, double yDifference, double zDifference, double distance) {
        double sizeScale = this.calculatePullPower(otherRedmatter);
        double vectorX = xDifference / distance;
        double vectorY = yDifference / distance;
        double vectorZ = zDifference / distance;
        double motionX = vectorX * sizeScale;
        double motionY = vectorY * sizeScale;
        double motionZ = vectorZ * sizeScale;
        this.redmatter.func_70024_g(motionX, motionY, motionZ);
    }

    private double calculatePullPower(EntityRedmatter otherRedmatter) {
        double otherSize = Math.max(1.0, Math.pow(otherRedmatter.getBlastSize(), 3.0));
        double thisSize = Math.max(1.0, Math.pow(this.redmatter.getBlastSize(), 3.0));
        double combinedSize = otherSize + thisSize;
        return thisSize / combinedSize;
    }
}

