/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.launcher.IMissileLauncher;
import icbm.classic.api.missiles.cause.IMissileCause;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.api.missiles.parts.IMissileTargetDelayed;
import icbm.classic.lib.saving.NbtSaveHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class FiringPackage
implements INBTSerializable<NBTTagCompound> {
    private IMissileTarget targetData;
    private IMissileCause cause;
    private int countDown = -1;
    private boolean hasFired = false;
    private static final NbtSaveHandler<FiringPackage> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("countdown", FiringPackage::getCountDown, FiringPackage::setCountDown).nodeBuildableObject("target", ICBMClassicAPI.MISSILE_TARGET_DATA_REGISTRY, FiringPackage::getTargetData, FiringPackage::setTargetData).nodeBuildableObject("cause", ICBMClassicAPI.MISSILE_CAUSE_REGISTRY, FiringPackage::getCause, FiringPackage::setCause).base();

    public FiringPackage(IMissileTarget targetData, IMissileCause cause, int countDown) {
        this.targetData = targetData;
        this.cause = cause;
        this.countDown = countDown;
    }

    public FiringPackage(IMissileTarget targetData, IMissileCause cause) {
        this.targetData = targetData;
        this.cause = cause;
    }

    public void launch(IMissileLauncher missileLauncher) {
        if (!this.hasFired) {
            this.hasFired = true;
            if (this.targetData instanceof IMissileTargetDelayed) {
                this.targetData = ((IMissileTargetDelayed)this.targetData).cloneWithoutDelay();
            }
            missileLauncher.launch(this.targetData, this.cause, false);
        }
    }

    public boolean isReady() {
        return !this.hasFired;
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    public IMissileTarget getTargetData() {
        return this.targetData;
    }

    public IMissileCause getCause() {
        return this.cause;
    }

    public int getCountDown() {
        return this.countDown;
    }

    public boolean isHasFired() {
        return this.hasFired;
    }

    public void setTargetData(IMissileTarget targetData) {
        this.targetData = targetData;
    }

    public void setCause(IMissileCause cause) {
        this.cause = cause;
    }

    public void setCountDown(int countDown) {
        this.countDown = countDown;
    }

    public void setHasFired(boolean hasFired) {
        this.hasFired = hasFired;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiringPackage)) {
            return false;
        }
        FiringPackage other = (FiringPackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCountDown() != other.getCountDown()) {
            return false;
        }
        if (this.isHasFired() != other.isHasFired()) {
            return false;
        }
        IMissileTarget this$targetData = this.getTargetData();
        IMissileTarget other$targetData = other.getTargetData();
        if (this$targetData == null ? other$targetData != null : !this$targetData.equals(other$targetData)) {
            return false;
        }
        IMissileCause this$cause = this.getCause();
        IMissileCause other$cause = other.getCause();
        return !(this$cause == null ? other$cause != null : !this$cause.equals(other$cause));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FiringPackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCountDown();
        result = result * 59 + (this.isHasFired() ? 79 : 97);
        IMissileTarget $targetData = this.getTargetData();
        result = result * 59 + ($targetData == null ? 43 : $targetData.hashCode());
        IMissileCause $cause = this.getCause();
        result = result * 59 + ($cause == null ? 43 : $cause.hashCode());
        return result;
    }

    public String toString() {
        return "FiringPackage(targetData=" + this.getTargetData() + ", cause=" + this.getCause() + ", countDown=" + this.getCountDown() + ", hasFired=" + this.isHasFired() + ")";
    }
}

