/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.base;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.caps.IMissileHolder;
import icbm.classic.api.launcher.IMissileLauncher;
import icbm.classic.config.ConfigMain;
import icbm.classic.config.machines.ConfigLauncher;
import icbm.classic.content.blocks.launcher.FiringPackage;
import icbm.classic.content.blocks.launcher.base.LauncherCapability;
import icbm.classic.content.blocks.launcher.base.gui.ContainerLaunchBase;
import icbm.classic.content.blocks.launcher.base.gui.GuiLauncherBase;
import icbm.classic.content.blocks.launcher.network.ILauncherComponent;
import icbm.classic.content.blocks.launcher.network.LauncherNode;
import icbm.classic.content.entity.EntityPlayerSeat;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.lib.capability.launcher.CapabilityMissileHolder;
import icbm.classic.lib.energy.storage.EnergyBuffer;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.packet.PacketTile;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.inventory.InventorySlot;
import icbm.classic.prefab.inventory.InventoryWithSlots;
import icbm.classic.prefab.tile.TileMachine;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileLauncherBase
extends TileMachine
implements ILauncherComponent {
    public static final int PACKET_LOCK_HEIGHT = 0;
    public static final int PACKET_GROUP_ID = 1;
    public static final int PACKET_GROUP_INDEX = 2;
    public static final int PACKET_GUI = 3;
    public static final int PACKET_FIRING_DELAY = 4;
    public EntityPlayerSeat seat;
    protected boolean checkMissileCollision = true;
    private boolean hasMissileCollision = false;
    public final EnergyBuffer energyStorage = new EnergyBuffer(() -> ConfigLauncher.POWER_CAPACITY).withOnChange((p, c, s) -> {
        this.updateClient = true;
        this.func_70296_d();
    });
    public final InventoryWithSlots inventory = new InventoryWithSlots(2).withChangeCallback((s, i) -> this.func_70296_d()).withSlot(new InventorySlot(0, ICBMClassicHelpers::isMissile).withInsertCheck(s -> !this.checkForMissileInBounds()).withChangeCallback(stack -> this.sendDescPacket())).withSlot(new InventorySlot(1, EnergySystem::isEnergyItem).withTick(this.energyStorage::dischargeItem));
    public ItemStack cachedMissileStack;
    public final IMissileHolder missileHolder = new CapabilityMissileHolder((IItemHandlerModifiable)this.inventory, 0);
    public final IMissileLauncher missileLauncher = new LauncherCapability(this);
    private final LauncherNode launcherNode = new LauncherNode(this, true);
    private int firingDelay = 0;
    private int lockHeight = 3;
    private int groupId = -1;
    private int groupIndex = -1;
    private FiringPackage firingPackage;
    private static final NbtSaveHandler<TileLauncherBase> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("lock_height", TileLauncherBase::getLockHeight, TileLauncherBase::setLockHeight).nodeInteger("group_id", TileLauncherBase::getGroupId, TileLauncherBase::setGroupId).nodeInteger("group_index", TileLauncherBase::getGroupIndex, TileLauncherBase::setGroupIndex).nodeInteger("firing_delay", TileLauncherBase::getFiringDelay, TileLauncherBase::setFiringDelay).nodeInteger("energy", tile -> tile.energyStorage.getEnergyStored(), (tile, i) -> tile.energyStorage.setEnergyStored((int)i)).nodeINBTSerializable("inventory", launcher -> launcher.inventory).nodeINBTSerializable("firing_package", launcher -> launcher.firingPackage).base();

    @Override
    public void provideInformation(BiConsumer<String, Object> consumer) {
        super.provideInformation(consumer);
        consumer.accept("NEEDS_POWER", ConfigMain.REQUIRES_POWER);
        consumer.accept("ENERGY_COST_ACTION", this.getFiringCost());
        consumer.accept("MAX_RANGE", ConfigLauncher.RANGE);
        consumer.accept("INACCURACY_BASE", ConfigLauncher.MIN_INACCURACY);
        consumer.accept("INACCURACY_RANGE", ConfigLauncher.SCALED_INACCURACY_DISTANCE);
        consumer.accept("INACCURACY_LAUNCHERS", ConfigLauncher.SCALED_INACCURACY_LAUNCHERS);
    }

    public int getFiringCost() {
        return ConfigLauncher.POWER_COST;
    }

    public void onLoad() {
        this.launcherNode.connectToTiles();
    }

    @Override
    public void func_145843_s() {
        this.getNetworkNode().onTileRemoved();
        super.func_145843_s();
    }

    @Override
    public LauncherNode getNetworkNode() {
        return this.launcherNode;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer()) {
            if (this.firingPackage != null) {
                this.firingPackage.setCountDown(this.firingPackage.getCountDown() - 1);
                if (this.firingPackage.getCountDown() <= 0) {
                    this.firingPackage.launch(this.missileLauncher);
                    this.firingPackage = null;
                }
            }
            if (this.ticks % 3 == 0) {
                this.checkMissileCollision = true;
                Optional.ofNullable(this.seat).ifPresent(seat -> seat.func_70107_b(this.x() + 0.5, this.y() + 0.5, this.z() + 0.5));
                if (!this.getMissileStack().func_190926_b() && this.seat == null) {
                    this.seat = new EntityPlayerSeat(this.field_145850_b);
                    this.seat.host = this;
                    this.seat.rideOffset = (Pos)new Pos(this.getRotation()).multiply(0.5, 1.0, 0.5);
                    this.seat.func_70107_b(this.x() + 0.5, this.y() + 0.5, this.z() + 0.5);
                    this.seat.func_70105_a(0.5f, 2.5f);
                    this.field_145850_b.func_72838_d((Entity)this.seat);
                } else if (this.getMissileStack().func_190926_b() && this.seat != null) {
                    Optional.ofNullable(this.seat.func_184187_bx()).ifPresent(Entity::func_184226_ay);
                    this.seat.func_70106_y();
                    this.seat = null;
                }
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == ICBMClassicAPI.MISSILE_HOLDER_CAPABILITY || capability == ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY || capability == CapabilityEnergy.ENERGY && ConfigMain.REQUIRES_POWER || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventory);
        }
        if (capability == ICBMClassicAPI.MISSILE_HOLDER_CAPABILITY) {
            return (T)this.missileHolder;
        }
        if (capability == ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY) {
            return (T)this.missileLauncher;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean checkForMissileInBounds() {
        if (this.checkMissileCollision) {
            this.checkMissileCollision = false;
            AxisAlignedBB collisionCheck = new AxisAlignedBB((double)this.xi(), (double)this.yi(), (double)this.zi(), (double)(this.xi() + 1), (double)(this.yi() + 5), (double)(this.zi() + 1));
            List entities = this.field_145850_b.func_72872_a(EntityMissile.class, collisionCheck);
            this.hasMissileCollision = entities.size() > 0;
        }
        return this.hasMissileCollision;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("gui.icbmclassic:launcherbase.name", new Object[0]);
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.getMissileStack());
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.cachedMissileStack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    @Override
    public boolean read(ByteBuf data, int id, EntityPlayer player, IPacket packet) {
        if (!super.read(data, id, player, packet)) {
            switch (id) {
                case 3: {
                    this.lockHeight = data.readInt();
                    this.groupIndex = data.readInt();
                    this.groupId = data.readInt();
                    this.firingDelay = data.readInt();
                    return true;
                }
                case 0: {
                    this.lockHeight = data.readInt();
                    return true;
                }
                case 2: {
                    this.groupIndex = data.readInt();
                    return true;
                }
                case 1: {
                    this.groupId = data.readInt();
                    return true;
                }
                case 4: {
                    this.firingDelay = data.readInt();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    protected PacketTile getGUIPacket() {
        PacketTile packetTile = new PacketTile("gui", 3, this);
        packetTile.addData(new Object[]{this.lockHeight});
        packetTile.addData(new Object[]{this.groupIndex});
        packetTile.addData(new Object[]{this.groupId});
        packetTile.addData(new Object[]{this.firingDelay});
        return packetTile;
    }

    public void sendLockHeightPacket(int lockHeight) {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("lockHeight_C>S", 0, this).addData(new Object[]{lockHeight}));
        }
    }

    public void sendGroupIdPacket(int groupId) {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("groupId_C>S", 1, this).addData(new Object[]{groupId}));
        }
    }

    public void sendGroupIndexPacket(int groupIndex) {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("groupIndex_C>S", 2, this).addData(new Object[]{groupIndex}));
        }
    }

    public void sendFiringDelayPacket(int firingDelay) {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("firingDelay_C>S", 4, this).addData(new Object[]{firingDelay}));
        }
    }

    public ItemStack getMissileStack() {
        if (this.isClient() && this.cachedMissileStack != null) {
            return this.cachedMissileStack;
        }
        return this.missileHolder.getMissileStack();
    }

    public boolean tryInsertMissile(EntityPlayer player, EnumHand hand, ItemStack heldItem) {
        if (this.getMissileStack().func_190926_b() && this.missileHolder.canSupportMissile(heldItem)) {
            if (this.isServer()) {
                ItemStack stackLeft = this.inventory.insertItem(0, heldItem, false);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, stackLeft);
                    player.field_71069_bz.func_75142_b();
                }
            }
            return true;
        }
        if (player.func_70093_af() && heldItem.func_190926_b() && !this.getMissileStack().func_190926_b()) {
            if (this.isServer()) {
                player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, this.getMissileStack());
                this.inventory.extractItem(0, 1, false);
                player.field_71069_bz.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerLaunchBase(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiLauncherBase(player, this);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        SAVE_LOGIC.save(this, nbt);
        return super.func_189515_b(nbt);
    }

    public int getFiringDelay() {
        return this.firingDelay;
    }

    public void setFiringDelay(int firingDelay) {
        this.firingDelay = firingDelay;
    }

    public int getLockHeight() {
        return this.lockHeight;
    }

    public void setLockHeight(int lockHeight) {
        this.lockHeight = lockHeight;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    public FiringPackage getFiringPackage() {
        return this.firingPackage;
    }

    public void setFiringPackage(FiringPackage firingPackage) {
        this.firingPackage = firingPackage;
    }
}

