/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.network;

import icbm.classic.content.blocks.launcher.network.ILauncherComponent;
import icbm.classic.content.blocks.launcher.network.LauncherEntry;
import icbm.classic.content.blocks.launcher.network.LauncherNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class LauncherNode {
    private LauncherNetwork network;
    private final TileEntity self;
    private final boolean acceptsItems;
    private boolean isInvalid = false;

    public LauncherNode(TileEntity self, boolean acceptsItems) {
        this.self = self;
        this.acceptsItems = acceptsItems;
    }

    public void onTileRemoved() {
        LauncherNetwork currentNetwork = this.network;
        if (currentNetwork != null) {
            this.network = null;
            this.isInvalid = true;
            currentNetwork.invalidate(this);
        }
    }

    public void onNetworkInvalidate() {
        this.network = null;
    }

    public void connectToTiles() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            LauncherNode node;
            TileEntity tile;
            BlockPos nextPos = this.self.func_174877_v().func_177972_a(side);
            if (!this.self.func_145831_w().func_175667_e(nextPos) || !((tile = this.self.func_145831_w().func_175625_s(nextPos)) instanceof ILauncherComponent) || !((ILauncherComponent)tile).isValid() || (node = ((ILauncherComponent)tile).getNetworkNode()).isInvalid()) continue;
            if (this.getNetwork() == null && node.getNetwork() != null) {
                node.getNetwork().addToNetwork(this);
                continue;
            }
            if (this.getNetwork() != null && node.getNetwork() == null) {
                this.getNetwork().addToNetwork(node);
                continue;
            }
            if (this.getNetwork() == null && node.getNetwork() == null) {
                LauncherNetwork newNetwork = new LauncherNetwork();
                newNetwork.addToNetwork(this);
                newNetwork.addToNetwork(node);
                continue;
            }
            if (this.getNetwork() == null || node.getNetwork() == this.getNetwork()) continue;
            this.getNetwork().mergeNetwork(node.getNetwork());
        }
    }

    public List<LauncherEntry> getLaunchers() {
        return Optional.ofNullable(this.getNetwork()).map(LauncherNetwork::getLaunchers).orElseGet(ArrayList::new);
    }

    public int hashCode() {
        return this.self.func_174877_v().hashCode();
    }

    public LauncherNetwork getNetwork() {
        return this.network;
    }

    public TileEntity getSelf() {
        return this.self;
    }

    public boolean isAcceptsItems() {
        return this.acceptsItems;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public void setNetwork(LauncherNetwork network) {
        this.network = network;
    }

    public void setInvalid(boolean isInvalid) {
        this.isInvalid = isInvalid;
    }

    public String toString() {
        return "LauncherNode(network=" + this.getNetwork() + ", self=" + this.getSelf() + ", acceptsItems=" + this.isAcceptsItems() + ", isInvalid=" + this.isInvalid() + ")";
    }
}

