/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.screen;

import icbm.classic.content.missile.logic.source.cause.BlockCause;
import icbm.classic.lib.saving.NbtSaveHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockScreenCause
extends BlockCause {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "block.screen");
    private int launcherCount;
    private static final NbtSaveHandler<BlockScreenCause> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("launcher_count", BlockScreenCause::getLauncherCount, BlockScreenCause::setLauncherCount).base();

    public BlockScreenCause(World world, BlockPos pos, IBlockState state, int launcherCount) {
        super(world, pos, state);
        this.launcherCount = launcherCount;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return REG_NAME;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, super.serializeNBT());
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    public int getLauncherCount() {
        return this.launcherCount;
    }

    public void setLauncherCount(int launcherCount) {
        this.launcherCount = launcherCount;
    }

    @Override
    public String toString() {
        return "BlockScreenCause(launcherCount=" + this.getLauncherCount() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockScreenCause)) {
            return false;
        }
        BlockScreenCause other = (BlockScreenCause)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getLauncherCount() == other.getLauncherCount();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BlockScreenCause;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getLauncherCount();
        return result;
    }

    public BlockScreenCause() {
    }
}

