/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.radarstation;

import icbm.classic.ICBMClassic;
import icbm.classic.content.blocks.radarstation.PropertyRadarState;
import icbm.classic.content.blocks.radarstation.TileRadarStation;
import icbm.classic.prefab.tile.BlockICBM;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRadarStation
extends BlockICBM {
    public static final PropertyBool REDSTONE_PROPERTY = PropertyBool.func_177716_a((String)"redstone");
    public static final PropertyRadarState RADAR_STATE = new PropertyRadarState();

    public BlockRadarStation() {
        super("radarStation");
        this.dropInventory = true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileRadarStation) {
            return state.func_177226_a((IProperty)RADAR_STATE, (Comparable)((Object)((TileRadarStation)tile).getRadarState()));
        }
        return state;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION_PROP, REDSTONE_PROPERTY, RADAR_STATE});
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileRadarStation) {
            return ((TileRadarStation)tileEntity).isOutputRedstone();
        }
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)REDSTONE_PROPERTY);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_176211_b(blockState, blockAccess, pos, side);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile instanceof TileRadarStation) {
            return ((TileRadarStation)tile).getStrongRedstonePower(side);
        }
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.func_184586_b(hand).func_77973_b() == Items.field_151137_ax) {
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileRadarStation) {
                    ((TileRadarStation)tile).setOutputRedstone(!((TileRadarStation)tile).isOutputRedstone());
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(((TileRadarStation)tile).isOutputRedstone() ? "message.radar.redstone.on" : "message.radar.redstone.off", new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cUnexpected error: Couldn't access radar station tile"));
                }
            } else {
                player.openGui((Object)ICBMClassic.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileRadarStation();
    }
}

