/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.reg;

import icbm.classic.api.EnumTier;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.explosion.IBlastFactory;
import icbm.classic.api.items.IWorldPosItem;
import icbm.classic.api.refs.ICBMExplosives;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.config.blast.ConfigBlast;
import icbm.classic.content.blast.BlastAntiGravitational;
import icbm.classic.content.blast.BlastBreach;
import icbm.classic.content.blast.BlastEMP;
import icbm.classic.content.blast.BlastEnderman;
import icbm.classic.content.blast.BlastEndothermic;
import icbm.classic.content.blast.BlastExothermic;
import icbm.classic.content.blast.BlastFire;
import icbm.classic.content.blast.BlastMutation;
import icbm.classic.content.blast.BlastRot;
import icbm.classic.content.blast.BlastShrapnel;
import icbm.classic.content.blast.BlastSmoke;
import icbm.classic.content.blast.BlastSonic;
import icbm.classic.content.blast.BlastTNT;
import icbm.classic.content.blast.gas.BlastChemical;
import icbm.classic.content.blast.gas.BlastColor;
import icbm.classic.content.blast.gas.BlastConfusion;
import icbm.classic.content.blast.gas.BlastContagious;
import icbm.classic.content.blast.redmatter.BlastRedmatterSpawner;
import icbm.classic.content.blast.threaded.BlastAntimatter;
import icbm.classic.content.blast.threaded.BlastNuclear;
import icbm.classic.lib.explosive.reg.ExplosiveRegistry;
import icbm.classic.lib.transform.vector.Location;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ExplosiveInit {
    public static void init() {
        ICBMExplosives.CONDENSED = ExplosiveInit.newEx(0, "condensed", EnumTier.ONE, () -> new BlastTNT().setBlastSize(ConfigBlast.condensed.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.CONDENSED.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.CONDENSED);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ICBMExplosives.CONDENSED.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.CONVENTIONAL);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.CONDENSED.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.CONDENSED);
        ICBMExplosives.SHRAPNEL = ExplosiveInit.newEx(1, "shrapnel", EnumTier.ONE, () -> new BlastShrapnel().setFlaming().setBlastSize(ConfigBlast.shrapnel.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.SHRAPNEL.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.SHRAPNEL);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ICBMExplosives.SHRAPNEL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.SHRAPNEL);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.SHRAPNEL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.SHRAPNEL);
        ICBMExplosives.INCENDIARY = ExplosiveInit.newEx(2, "incendiary", EnumTier.ONE, () -> new BlastFire().setBlastSize(ConfigBlast.incendiary.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseTickListener(ICBMExplosives.INCENDIARY.getRegistryName(), (world, x, y, z, tick) -> world.func_175688_a(EnumParticleTypes.LAVA, x, y + 0.5, z, 0.0, 0.0, 0.0, new int[0]));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.INCENDIARY.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.INCENDIARY);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ICBMExplosives.INCENDIARY.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.INCENDIARY);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.INCENDIARY.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.INCENDIARY);
        ICBMExplosives.DEBILITATION = ExplosiveInit.newEx(3, "debilitation", EnumTier.ONE, () -> new BlastConfusion().setBlastSize(ConfigBlast.debilitation.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.DEBILITATION.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.DEBILITATION);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ICBMExplosives.DEBILITATION.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.DEBILITATION);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.DEBILITATION.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.DEBILITATION);
        ICBMExplosives.CHEMICAL = ExplosiveInit.newEx(4, "chemical", EnumTier.ONE, () -> new BlastChemical().setBlastSize(ConfigBlast.chemical.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.CHEMICAL.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.CHEMICAL);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ICBMExplosives.CHEMICAL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.CHEMICAL);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.CHEMICAL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.CHEMICAL);
        ICBMExplosives.ANVIL = ExplosiveInit.newEx(5, "anvil", EnumTier.ONE, () -> new BlastShrapnel().setAnvil().setBlastSize(ConfigBlast.anvil.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.ANVIL.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ANVIL);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ICBMExplosives.ANVIL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.ANVIL);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.ANVIL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ANVIL);
        ICBMExplosives.REPULSIVE = ExplosiveInit.newEx(6, "repulsive", EnumTier.ONE, () -> new BlastTNT().setDestroyItems().setPushType(BlastTNT.PushType.REPEL).setBlastSize(ConfigBlast.repulsive.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.REPULSIVE.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.REPULSIVE);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ICBMExplosives.REPULSIVE.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.REPULSIVE);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.REPULSIVE.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.REPULSIVE);
        ICBMExplosives.ATTRACTIVE = ExplosiveInit.newEx(7, "attractive", EnumTier.ONE, () -> new BlastTNT().setDestroyItems().setPushType(BlastTNT.PushType.ATTRACT).setBlastSize(ConfigBlast.attractive.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.ATTRACTIVE.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ATTRACTIVE);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ICBMExplosives.ATTRACTIVE.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.ATTRACTIVE);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.ATTRACTIVE.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ATTRACTIVE);
        ICBMExplosives.FRAGMENTATION = ExplosiveInit.newEx(8, "fragmentation", EnumTier.TWO, () -> new BlastShrapnel().setExplosive().setBlastSize(ConfigBlast.fragmentation.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.FRAGMENTATION.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.FRAGMENTATION);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.FRAGMENTATION.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.FRAGMENTATION);
        ICBMExplosives.CONTAGIOUS = ExplosiveInit.newEx(9, "contagious", EnumTier.TWO, () -> new BlastContagious().setBlastSize(ConfigBlast.contagious.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.CONTAGIOUS.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.CONTAGIOUS);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.CONTAGIOUS.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.CONTAGIOUS);
        ICBMExplosives.SONIC = ExplosiveInit.newEx(10, "sonic", EnumTier.TWO, () -> new BlastSonic().setBlastSize(ConfigBlast.sonic.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.SONIC.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.SONIC);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.SONIC.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.SONIC);
        ICBMExplosives.BREACHING = ExplosiveInit.newEx(11, "breaching", EnumTier.TWO, () -> new BlastBreach(7).setBlastSize(ConfigBlast.breaching.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.BREACHING.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.BREACHING);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.BREACHING.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.BREACHING);
        ICBMExplosives.THERMOBARIC = ExplosiveInit.newEx(13, "thermobaric", EnumTier.TWO, () -> new BlastNuclear().setEnergy(45.0).setBlastSize(ConfigBlast.thermobaric.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.THERMOBARIC.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.THERMOBARIC);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.THERMOBARIC.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.THERMOBARIC);
        ICBMExplosives.NUCLEAR = ExplosiveInit.newEx(15, "nuclear", EnumTier.THREE, () -> new BlastNuclear().setEnergy(ConfigBlast.nuclear.energy).setBlastSize(ConfigBlast.nuclear.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.NUCLEAR.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.NUCLEAR);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.NUCLEAR.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.NUCLEAR);
        ICBMExplosives.EMP = ExplosiveInit.newEx(16, "emp", EnumTier.THREE, () -> new BlastEMP().setEffectBlocks().setEffectEntities().setBlastSize(ConfigBlast.emp.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.EMP.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.EMP);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.EMP.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.EMP);
        ICBMExplosives.EXOTHERMIC = ExplosiveInit.newEx(17, "exothermic", EnumTier.THREE, () -> new BlastExothermic().setBlastSize(ConfigBlast.exothermic.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseTickListener(ICBMExplosives.EXOTHERMIC.getRegistryName(), (world, x, y, z, tick) -> world.func_175688_a(EnumParticleTypes.LAVA, x, y + 0.5, z, 0.0, 0.0, 0.0, new int[0]));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.EXOTHERMIC.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.EXOTHERMIC);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.EXOTHERMIC.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.EXOTHERMIC);
        ICBMExplosives.ENDOTHERMIC = ExplosiveInit.newEx(18, "endothermic", EnumTier.THREE, () -> new BlastEndothermic().setBlastSize(ConfigBlast.endothermic.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.ENDOTHERMIC.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ENDOTHERMIC);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.ENDOTHERMIC.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ENDOTHERMIC);
        ICBMExplosives.ANTI_GRAVITATIONAL = ExplosiveInit.newEx(19, "antigravitational", EnumTier.THREE, () -> new BlastAntiGravitational().setBlastSize(ConfigBlast.antigravitational.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.ANTI_GRAVITATIONAL.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ANTI_GRAVITATIONAL);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.ANTI_GRAVITATIONAL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ANTI_GRAVITATIONAL);
        ICBMExplosives.ENDER = ExplosiveInit.newEx(20, "ender", EnumTier.THREE, () -> new BlastEnderman().setBlastSize(ConfigBlast.ender.scale));
        ICBMClassicAPI.EX_MISSILE_REGISTRY.setInteractionListener(ICBMExplosives.ENDER.getRegistryName(), ExplosiveInit::enderMissileCoordSet);
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setActivationListener(ICBMExplosives.ENDER.getRegistryName(), ExplosiveInit::enderBlockCoordSet);
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.ENDER.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ENDER);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.ENDER.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ENDER);
        ICBMExplosives.HYPERSONIC = ExplosiveInit.newEx(21, "hypersonic", EnumTier.NONE, null);
        ICBMExplosives.ANTIMATTER = ExplosiveInit.newEx(22, "antimatter", EnumTier.FOUR, () -> new BlastAntimatter().setBlastSize(ConfigBlast.antimatter.scale));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.ANTIMATTER.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ANTIMATTER);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.ANTIMATTER.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ANTIMATTER);
        ICBMExplosives.REDMATTER = ExplosiveInit.newEx(23, "redMatter", EnumTier.FOUR, () -> new BlastRedmatterSpawner().setBlastSize(ConfigBlast.redmatter.DEFAULT_SIZE));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ICBMExplosives.REDMATTER.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.REDMATTER);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ICBMExplosives.REDMATTER.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.REDMATTER);
        ICBMExplosives.MISSILEMODULE = ExplosiveInit.newEx(24, "missile", EnumTier.NONE, null);
        ICBMExplosives.ROT = ExplosiveInit.newEx(25, "rot", EnumTier.NONE, BlastRot::new);
        ICBMExplosives.MUTATION = ExplosiveInit.newEx(26, "mutation", EnumTier.NONE, BlastMutation::new);
        ICBMExplosives.COLOR = ExplosiveInit.newEx(-1, "colors", EnumTier.ONE, () -> new BlastColor().setBlastSize(ConfigBlast.colorful.scale));
        ICBMExplosives.SMOKE = ExplosiveInit.newEx(-1, "smoke", EnumTier.ONE, BlastSmoke::new);
        ((ExplosiveRegistry)ICBMClassicAPI.EXPLOSIVE_REGISTRY).lockForce();
    }

    private static IExplosiveData newEx(int id, String name, EnumTier tier, IBlastFactory factory) {
        ResourceLocation regName = new ResourceLocation("icbmclassic", name);
        if (id != -1) {
            ((ExplosiveRegistry)ICBMClassicAPI.EXPLOSIVE_REGISTRY).forceID(regName, id);
        }
        IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.register(regName, tier, factory);
        if (tier != EnumTier.NONE) {
            ICBMClassicAPI.EX_BLOCK_REGISTRY.enableContent(regName);
            ICBMClassicAPI.EX_MISSILE_REGISTRY.enableContent(regName);
            ICBMClassicAPI.EX_MINECART_REGISTRY.enableContent(regName);
        }
        if (tier == EnumTier.ONE) {
            ICBMClassicAPI.EX_GRENADE_REGISTRY.enableContent(regName);
        }
        return data;
    }

    private static boolean enderMissileCoordSet(Entity entity, EntityPlayer player, EnumHand hand) {
        IWorldPosItem posItem;
        Location link;
        ItemStack heldItem;
        IExplosive provider;
        NBTTagCompound tag;
        if (entity.hasCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null) && (tag = (provider = (IExplosive)entity.getCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null)).getCustomBlastData()) != null && (heldItem = player.func_184586_b(hand)).func_77973_b() instanceof IWorldPosItem && (link = (posItem = (IWorldPosItem)heldItem.func_77973_b()).getLocation(heldItem)) instanceof Location) {
            link.writeIntNBT(tag);
            if (!entity.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Coordinates encoded into entity"));
            }
            return true;
        }
        return false;
    }

    private static boolean enderBlockCoordSet(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IExplosive explosive;
        TileEntity tileEntity;
        IWorldPosItem posItem;
        Location link;
        ItemStack heldItem = entityPlayer.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof IWorldPosItem && (link = (posItem = (IWorldPosItem)heldItem.func_77973_b()).getLocation(heldItem)) instanceof Location && (tileEntity = world.func_175625_s(pos)).hasCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, facing) && (explosive = (IExplosive)tileEntity.getCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, facing)) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            link.writeIntNBT(tag);
            explosive.getCustomBlastData().func_74782_a("", (NBTBase)tag);
            if (!world.field_72995_K) {
                // empty if block
            }
            return true;
        }
        return false;
    }
}

