/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.capability.chicken;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="icbmclassic")
public class CapSpaceChicken
implements ICapabilityProvider,
INBTSerializable<NBTTagByte> {
    @CapabilityInject(value=CapSpaceChicken.class)
    public static Capability<CapSpaceChicken> INSTANCE;
    public static final ResourceLocation CHICKEN_CAP;
    private static final DataParameter<Boolean> SPACE;
    private final EntityChicken chicken;

    public CapSpaceChicken(EntityChicken chicken) {
        this.chicken = chicken;
    }

    public static boolean isSpace(EntityChicken chicken) {
        CapSpaceChicken cap;
        if (chicken.hasCapability(INSTANCE, null) && (cap = (CapSpaceChicken)chicken.getCapability(INSTANCE, null)) != null) {
            return cap.isSpace();
        }
        return false;
    }

    @SubscribeEvent
    public static void attachCap(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityChicken) {
            event.addCapability(CHICKEN_CAP, (ICapabilityProvider)new CapSpaceChicken((EntityChicken)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void createEntityEvent(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityChicken) {
            event.getEntity().func_184212_Q().func_187214_a(SPACE, (Object)false);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == INSTANCE;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == INSTANCE) {
            return (T)this;
        }
        return null;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(CapSpaceChicken.class, (Capability.IStorage)new Capability.IStorage<CapSpaceChicken>(){

            @Nullable
            public NBTBase writeNBT(Capability<CapSpaceChicken> capability, CapSpaceChicken instance, EnumFacing side) {
                return new NBTTagByte(instance.isSpace() ? (byte)1 : 0);
            }

            public void readNBT(Capability<CapSpaceChicken> capability, CapSpaceChicken instance, EnumFacing side, NBTBase nbt) {
                if (nbt instanceof NBTTagByte) {
                    instance.setSpace(((NBTTagByte)nbt).func_150290_f() == 1);
                }
            }
        }, () -> new CapSpaceChicken(null));
    }

    public NBTTagByte serializeNBT() {
        return new NBTTagByte(this.isSpace() ? (byte)1 : 0);
    }

    public void deserializeNBT(NBTTagByte nbt) {
        this.setSpace(nbt.func_150290_f() == 1);
    }

    public boolean isSpace() {
        return Optional.ofNullable(this.chicken).map(c -> (Boolean)c.func_184212_Q().func_187225_a(SPACE)).orElse(false);
    }

    public void setSpace(boolean space) {
        Optional.ofNullable(this.chicken).ifPresent(c -> c.func_184212_Q().func_187227_b(SPACE, (Object)space));
    }

    static {
        CHICKEN_CAP = new ResourceLocation("icbmclassic", "space_chicken");
        SPACE = EntityDataManager.func_187226_a(EntityAgeable.class, (DataSerializer)DataSerializers.field_187198_h);
    }
}

