/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.capability.launcher.data;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.launcher.IActionStatus;
import icbm.classic.lib.capability.launcher.data.FiringWithDelay;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class LauncherStatus
implements IActionStatus {
    public static final LauncherStatus ERROR_GENERIC = new LauncherStatus().withRegName("error.generic").asError().withTranslation("info.icbmclassic:launcher.error");
    public static final LauncherStatus ERROR_SPAWN = new LauncherStatus().withRegName("error.spawning").asError().withTranslation("info.icbmclassic:launcher.error.missile.spawn");
    public static final LauncherStatus ERROR_MIN_RANGE = new LauncherStatus().withRegName("error.range.min").asError().withTranslation("info.icbmclassic:launcher.error.target.min");
    public static final LauncherStatus ERROR_MAX_RANGE = new LauncherStatus().withRegName("error.range.max").asError().withTranslation("info.icbmclassic:launcher.error.target.max");
    public static final LauncherStatus ERROR_TARGET_NULL = new LauncherStatus().withRegName("error.target.null").asError().withTranslation("info.icbmclassic:launcher.error.target.none");
    public static final LauncherStatus ERROR_POWER = new LauncherStatus().withRegName("error.power").asError().withTranslation("info.icbmclassic:launcher.error.power");
    public static final LauncherStatus ERROR_INVALID_STACK = new LauncherStatus().withRegName("error.missile.invalid").asError().withTranslation("info.icbmclassic:launcher.error.missile.invalid");
    public static final LauncherStatus ERROR_EMPTY_STACK = new LauncherStatus().withRegName("error.missile.empty").asError().withTranslation("info.icbmclassic:launcher.error.missile.none");
    public static final LauncherStatus ERROR_QUEUED = new LauncherStatus().withRegName("error.missile.queued").asError().withTranslation("info.icbmclassic:launcher.error.missile.queued");
    public static final LauncherStatus READY = new LauncherStatus().withRegName("ready").withTranslation("info.icbmclassic:launcher.status.ready");
    public static final LauncherStatus LAUNCHED = new LauncherStatus().withRegName("launched").withTranslation("info.icbmclassic:launcher.status.launched");
    public static final LauncherStatus CANCELED = new LauncherStatus().withRegName("canceled").withTranslation("info.icbmclassic:launcher.status.canceled");
    public static final LauncherStatus FIRING_AIMING = new LauncherStatus().withRegName("firing.aiming").asBlocking().withTranslation("info.icbmclassic:launcher.status.firing.aiming");
    private boolean error = false;
    private boolean block = false;
    private String message;
    private ITextComponent textComponent;
    private ResourceLocation regName;

    public LauncherStatus asError() {
        this.error = true;
        return this;
    }

    public LauncherStatus asBlocking() {
        this.block = true;
        return this;
    }

    public LauncherStatus withTranslation(String key) {
        this.message = key;
        return this;
    }

    public LauncherStatus withRegName(String key) {
        return this.withRegName("icbmclassic", key);
    }

    public LauncherStatus withRegName(String domain, String key) {
        this.regName = new ResourceLocation(domain, key);
        return this;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public boolean shouldBlockInteraction() {
        return this.isError() || this.block;
    }

    @Override
    public ITextComponent message() {
        if (this.textComponent == null) {
            this.textComponent = new TextComponentTranslation(this.message, new Object[0]);
        }
        return this.textComponent;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.regName;
    }

    public NBTTagCompound serializeNBT() {
        return null;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public String toString() {
        return "LauncherStatus[ '" + this.getRegistryName() + "' , '" + this.message + "' ]@" + this.hashCode();
    }

    public static void registerTypes() {
        LauncherStatus.register(ERROR_GENERIC);
        LauncherStatus.register(ERROR_SPAWN);
        LauncherStatus.register(ERROR_MIN_RANGE);
        LauncherStatus.register(ERROR_MAX_RANGE);
        LauncherStatus.register(ERROR_TARGET_NULL);
        LauncherStatus.register(ERROR_POWER);
        LauncherStatus.register(ERROR_INVALID_STACK);
        LauncherStatus.register(ERROR_EMPTY_STACK);
        LauncherStatus.register(ERROR_QUEUED);
        LauncherStatus.register(LAUNCHED);
        LauncherStatus.register(READY);
        LauncherStatus.register(CANCELED);
        LauncherStatus.register(FIRING_AIMING);
        ICBMClassicAPI.ACTION_STATUS_REGISTRY.register(FiringWithDelay.regName, FiringWithDelay::new);
    }

    private static void register(LauncherStatus constantStatus) {
        ICBMClassicAPI.ACTION_STATUS_REGISTRY.register(constantStatus.getRegistryName(), () -> constantStatus);
    }
}

