/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.explosive;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.explosion.IBlastInit;
import icbm.classic.api.explosion.responses.BlastErrorResponses;
import icbm.classic.api.explosion.responses.BlastNullResponses;
import icbm.classic.api.explosion.responses.BlastResponse;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.content.blast.Blast;
import icbm.classic.lib.transform.vector.Pos;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="icbmclassic")
public class ExplosiveHandler {
    public static final ArrayList<IBlast> activeBlasts = new ArrayList();

    public static void add(Blast blast) {
        activeBlasts.add(blast);
    }

    public static void remove(Blast blast) {
        activeBlasts.remove(blast);
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            int dim = event.getWorld().field_73011_w.getDimension();
            activeBlasts.stream().filter(blast -> !blast.hasWorld() || blast.world().field_73011_w.getDimension() == dim).forEach(IBlast::clearBlast);
        }
    }

    public static int removeNear(World world, double x, double y, double z, double range) {
        Pos pos = new Pos(x, y, z);
        List<IBlast> toRemove = activeBlasts.stream().filter(blast -> blast.world() == world).filter(blast -> range < 0.0 || range > 0.0 && range > pos.distance((IPos3D)blast)).collect(Collectors.toList());
        activeBlasts.removeAll(toRemove);
        toRemove.forEach(IBlast::clearBlast);
        return toRemove.size();
    }

    public static BlastResponse createExplosion(Entity cause, World world, double x, double y, double z, IExplosive capabilityExplosive) {
        if (capabilityExplosive == null) {
            return ExplosiveHandler.logEventThenRespond(cause, world, x, y, z, null, 1.0f, BlastNullResponses.EXPLOSIVE_CAPABILITY.get());
        }
        return ExplosiveHandler.createExplosion(cause, world, x, y, z, capabilityExplosive.getExplosiveData(), 1.0f, capabilityExplosive.getCustomBlastData());
    }

    public static BlastResponse createExplosion(Entity cause, World world, double x, double y, double z, int blastID, float scale, NBTTagCompound customData) {
        IExplosiveData explosiveData = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(blastID);
        if (explosiveData == null) {
            ICBMClassic.logger().error("Missing explosive data in registry for blastID({})", (Object)blastID);
            return ExplosiveHandler.logEventThenRespond(cause, world, x, y, z, null, 1.0f, BlastErrorResponses.MISSING_BLAST_REGISTRY.get());
        }
        return ExplosiveHandler.createExplosion(cause, world, x, y, z, explosiveData, scale, customData);
    }

    public static BlastResponse createExplosion(Entity cause, World world, double x, double y, double z, IExplosiveData explosiveData, float scale, NBTTagCompound customData) {
        BlastResponse response = BlastNullResponses.BLAST_CREATION.get();
        if (explosiveData == null) {
            response = BlastNullResponses.EXPLOSIVE_DATA.get();
        } else if (explosiveData.getBlastFactory() != null) {
            IBlastInit factoryBlast = explosiveData.getBlastFactory().create();
            if (factoryBlast != null) {
                factoryBlast.setBlastWorld(world);
                factoryBlast.setBlastPosition(x, y, z);
                factoryBlast.scaleBlast(scale);
                factoryBlast.setBlastSource(cause);
                factoryBlast.setExplosiveData(explosiveData);
                factoryBlast.setCustomData(customData);
                factoryBlast.buildBlast();
                response = factoryBlast.runBlast();
            }
        } else {
            response = BlastNullResponses.BLAST_FACTORY.get();
        }
        return ExplosiveHandler.logEventThenRespond(cause, world, x, y, z, explosiveData, scale, response);
    }

    private static BlastResponse logEventThenRespond(Entity cause, World world, double x, double y, double z, IExplosiveData explosiveData, float scale, BlastResponse blastResponse) {
        String entitySource;
        String explosiveName = explosiveData == null ? "null" : explosiveData.getRegistryName().toString();
        String string = entitySource = cause != null ? Integer.toString(cause.func_145782_y()) : "null";
        if (blastResponse.errorMessage != null) {
            String formatString = "Explosion[%s] | Scale(x%,.1f) | BlastState(%s) | EntitySource(%s) | Impacted (%,.1fx %,.1fy %,.1fz %sd) | ErrorMessage: %s";
            String formattedMessage = String.format("Explosion[%s] | Scale(x%,.1f) | BlastState(%s) | EntitySource(%s) | Impacted (%,.1fx %,.1fy %,.1fz %sd) | ErrorMessage: %s", new Object[]{explosiveName, Float.valueOf(scale), blastResponse.state, entitySource, x, y, z, world.field_73011_w.getDimension(), blastResponse.errorMessage});
            ICBMClassic.logger().error(formattedMessage, blastResponse.error);
        } else {
            String formatString = "Explosion[%s] | Scale(x%,.1f) | BlastState(%s) | EntitySource(%s) | Impacted (%,.1fx %,.1fy %,.1fz %sd)";
            String formattedMessage = String.format("Explosion[%s] | Scale(x%,.1f) | BlastState(%s) | EntitySource(%s) | Impacted (%,.1fx %,.1fy %,.1fz %sd)", new Object[]{explosiveName, Float.valueOf(scale), blastResponse.state, entitySource, x, y, z, world.field_73011_w.getDimension()});
            ICBMClassic.logger().info(formattedMessage);
        }
        return blastResponse;
    }
}

