/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.explosive.reg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import icbm.classic.ICBMClassic;
import icbm.classic.api.EnumTier;
import icbm.classic.api.explosion.IBlastFactory;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.api.reg.IExplosiveRegistry;
import icbm.classic.api.reg.content.IExplosiveContentRegistry;
import icbm.classic.lib.explosive.reg.ExplosiveData;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class ExplosiveRegistry
implements IExplosiveRegistry {
    public final HashMap<ResourceLocation, IExplosiveData> explosiveData = new HashMap();
    public final Map<Integer, ResourceLocation> id_to_name = new HashMap<Integer, ResourceLocation>();
    public final Map<ResourceLocation, Integer> name_to_id = new HashMap<ResourceLocation, Integer>();
    public final Map<ResourceLocation, IExplosiveContentRegistry> contentRegistry = new HashMap<ResourceLocation, IExplosiveContentRegistry>();
    private int nextID = 0;
    private File saveFile;
    private boolean locked = false;
    private boolean lockForce = false;
    private boolean allExplosivesLocked = false;
    private boolean lockNewContentTypes = false;
    private ImmutableSet<IExplosiveData> allExplosives;

    @Override
    public IExplosiveData register(ResourceLocation name, EnumTier tier, IBlastFactory blastFactory) {
        int assignedID;
        if (this.locked) {
            throw new RuntimeException("ExplosiveRegistry: new explosives can not be registered after registry phase");
        }
        if (name.toString().contains("_")) {
            throw new IllegalArgumentException("ExplosiveRegistry: '" + name + "' can not contain underscores");
        }
        if (this.name_to_id.containsKey(name)) {
            assignedID = this.name_to_id.get(name);
        } else {
            while (this.id_to_name.containsKey(this.nextID)) {
                ++this.nextID;
            }
            assignedID = this.nextID;
        }
        this.setReg(name, assignedID);
        this.explosiveData.put(name, new ExplosiveData(name, assignedID, tier).blastFactory(blastFactory));
        return this.explosiveData.get(name);
    }

    public void lockNewExplosives() {
        if (this.allExplosivesLocked) {
            throw new RuntimeException(this + ": New explosives were locked twice!");
        }
        this.allExplosivesLocked = true;
        this.allExplosives = (ImmutableSet)this.explosiveData.values().stream().filter(e -> e != null).collect(ImmutableSet.toImmutableSet());
    }

    public void completeLock() {
        if (this.locked) {
            throw new RuntimeException(this + ": Registries were locked twice!");
        }
        this.locked = true;
        this.getContentRegistries().forEach(reg -> reg.lockRegistry());
    }

    public void lockNewContentTypes() {
        if (this.lockNewContentTypes) {
            throw new RuntimeException(this + ": New content types were locked twice!");
        }
        this.lockNewContentTypes = true;
    }

    @Override
    public IExplosiveData getExplosiveData(ResourceLocation name) {
        return this.explosiveData.get(name);
    }

    @Override
    public IExplosiveData getExplosiveData(int id) {
        ResourceLocation name = this.id_to_name.get(id);
        if (name != null) {
            return this.explosiveData.get(name);
        }
        return null;
    }

    @Override
    public Collection<IExplosiveContentRegistry> getContentRegistries() {
        return ImmutableList.copyOf(this.contentRegistry.values());
    }

    @Override
    public IExplosiveContentRegistry getContentRegistry(ResourceLocation contentID) {
        return this.contentRegistry.get(contentID);
    }

    @Override
    public void registerContentRegistry(ResourceLocation name, IExplosiveContentRegistry registry) {
        if (this.locked || this.lockNewContentTypes) {
            throw new RuntimeException("ExplosiveRegistry: new explosive content types can not be registered after init phase");
        }
        if (registry == null) {
            throw new IllegalArgumentException("ExplosiveRegistry: content type should not be null, Name: " + name);
        }
        if (name == null) {
            throw new IllegalArgumentException("ExplosiveRegistry: name is required for content registry type, " + registry);
        }
        if (this.contentRegistry.containsKey(name) && this.contentRegistry.get(name) != null) {
            throw new RuntimeException("ExplosiveRegistry: duplicate content type detected for '" + name + "' Prev: " + this.contentRegistry.get(name) + "  New: " + registry);
        }
        this.contentRegistry.put(name, registry);
    }

    @Override
    public Set<IExplosiveData> getExplosives() {
        return this.allExplosives;
    }

    protected void setReg(ResourceLocation name, int id) {
        this.id_to_name.put(id, name);
        this.name_to_id.put(name, id);
    }

    public void forceID(ResourceLocation name, int id) {
        if (!this.lockForce) {
            this.setReg(name, id);
        }
    }

    public void lockForce() {
        this.lockForce = true;
    }

    public void loadReg(File file) {
        block16: {
            this.saveFile = file;
            ICBMClassic.logger().info("ExplosiveRegistry: loading registry save, File: " + file);
            if (file.exists()) {
                try (FileReader reader = new FileReader(file);){
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    JsonElement element = Streams.parse((JsonReader)jsonReader);
                    if (element.isJsonObject()) {
                        this.loadReg(element.getAsJsonObject());
                        break block16;
                    }
                    throw new RuntimeException("ExplosiveRegistry: Failed to load registry save file as JSON object, File: " + file);
                }
                catch (Exception e) {
                    throw new RuntimeException("ExplosiveRegistry: Unexpected error reading explosive registry save, File: " + file, e);
                }
            }
            ICBMClassic.logger().warn("ExplosiveRegistry: No save found for registry. This can be ignored if first run with the mod. File: " + file);
        }
    }

    protected void loadReg(JsonObject saveData) {
        for (Map.Entry entry : saveData.entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
            String key = ((String)entry.getKey()).trim().toLowerCase();
            int id = ((JsonElement)entry.getValue()).getAsInt();
            this.checkDuplicate(id, key);
            this.setReg(new ResourceLocation(key), id);
        }
    }

    protected void checkDuplicate(int id, String key) {
        if (this.id_to_name.containsKey(id) && this.id_to_name.get(id) != null && !key.equals(this.id_to_name.get(id).toString())) {
            throw new RuntimeException("ExplosiveRegistry: Duplicate registry detected with mismatching registry names for ID[" + id + "].   Current: " + this.id_to_name.get(id) + "  New: " + key);
        }
    }

    public void saveReg() {
        JsonObject saveData = new JsonObject();
        this.saveReg(saveData);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)saveData);
        if (!this.saveFile.getParentFile().exists()) {
            this.saveFile.getParentFile().mkdirs();
        }
        try (FileWriter fileWriter = new FileWriter(this.saveFile);){
            fileWriter.write(json);
        }
        catch (Exception e) {
            ICBMClassic.logger().error("ExplosiveRegistry: Failed to save registry to file, File: " + this.saveFile);
            e.printStackTrace();
        }
    }

    protected void saveReg(JsonObject saveData) {
        for (Map.Entry<ResourceLocation, Integer> entry : this.name_to_id.entrySet()) {
            saveData.addProperty(entry.getKey().toString(), (Number)entry.getValue());
        }
    }
}

