/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.packet;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketEntity
extends PacketBase<PacketEntity> {
    public int entityId;
    public int id;
    public String name;

    public PacketEntity() {
    }

    public PacketEntity(String name, int entityId, int id) {
        this.name = name;
        this.entityId = entityId;
        this.id = id;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeBoolean(ICBMClassic.runningAsDev);
        if (ICBMClassic.runningAsDev) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        }
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.id);
        super.encodeInto(ctx, buffer);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
        this.entityId = buffer.readInt();
        this.id = buffer.readInt();
        super.decodeInto(ctx, buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        if (player != null) {
            this.handle(player);
        } else if (ICBMClassic.runningAsDev) {
            ICBMClassic.logger().error("PacketTile#handleClientSide(null) - player was null for packet", (Throwable)new RuntimeException());
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (player != null) {
            this.handle(player);
        } else if (ICBMClassic.runningAsDev) {
            ICBMClassic.logger().error("PacketTile#handleServerSide(null) - player was null for packet", (Throwable)new RuntimeException());
        }
    }

    public void handle(EntityPlayer player) {
        if (player.func_130014_f_() == null) {
            if (ICBMClassic.runningAsDev) {
                ICBMClassic.logger().error("PacketTile#handle(" + player + ") - world is null for player while handling packet. ", (Throwable)new RuntimeException());
            }
            return;
        }
        this.handle(player, player.func_130014_f_().func_73045_a(this.entityId));
    }

    public void handle(EntityPlayer player, Entity entity) {
        if (entity == null) {
            ICBMClassic.logger().error("Couldn't match entity for entityId= " + this.entityId + " ID=" + this.id + " name=" + this.name);
        } else if (entity instanceof IPacketIDReceiver) {
            IPacketIDReceiver receiver = (IPacketIDReceiver)entity;
            if (receiver.shouldReadPacket(player, null, this)) {
                try {
                    receiver.read(this.dataToRead, this.id, player, this);
                }
                catch (IndexOutOfBoundsException e) {
                    ICBMClassic.logger().error(entity + ": Packet was read past its size. ID=" + this.id + " name=" + this.name);
                    ICBMClassic.logger().error("Error: ", (Throwable)e);
                }
                catch (NullPointerException e) {
                    ICBMClassic.logger().error(entity + ": Null pointer while reading data. ID=" + this.id + " name=" + this.name);
                    ICBMClassic.logger().error("Error: ", (Throwable)e);
                }
                catch (Exception e) {
                    ICBMClassic.logger().error(entity + ": Failed to read packet. ID=" + this.id + " name=" + this.name);
                    ICBMClassic.logger().error("Error: ", (Throwable)e);
                }
            } else {
                ICBMClassic.logger().error("Error: " + entity + " rejected packet " + this + " due to invalid conditions.");
            }
        } else {
            ICBMClassic.logger().error("Error: " + entity + " doesn't implement IPacketIDReceiver");
        }
    }
}

