/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.packet;

import icbm.classic.lib.network.packet.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketEntityPos
extends PacketBase<PacketEntityPos> {
    public int entityId;
    public int world;
    public double x;
    public double y;
    public double z;
    public double mx;
    public double my;
    public double mz;
    public float yaw;
    public float pitch;

    public PacketEntityPos() {
    }

    public PacketEntityPos(Entity entity) {
        this.entityId = entity.func_145782_y();
        this.world = entity.field_70170_p.field_73011_w.getDimension();
        this.x = entity.field_70165_t;
        this.y = entity.field_70163_u;
        this.z = entity.field_70161_v;
        this.mx = entity.field_70159_w;
        this.my = entity.field_70181_x;
        this.mz = entity.field_70179_y;
        this.yaw = entity.field_70177_z;
        this.pitch = entity.field_70125_A;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.world);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeDouble(this.mx);
        buffer.writeDouble(this.my);
        buffer.writeDouble(this.mz);
        buffer.writeFloat(this.yaw);
        buffer.writeFloat(this.pitch);
        super.encodeInto(ctx, buffer);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.world = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.mx = buffer.readDouble();
        this.my = buffer.readDouble();
        this.mz = buffer.readDouble();
        this.yaw = buffer.readFloat();
        this.pitch = buffer.readFloat();
        super.decodeInto(ctx, buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        Entity entity;
        if (player != null && player.field_70170_p.field_73011_w.getDimension() == this.world && (entity = player.field_70170_p.func_73045_a(this.entityId)) != null) {
            entity.func_70107_b(this.x, this.y, this.z);
            entity.field_70159_w = this.mx;
            entity.field_70181_x = this.my;
            entity.field_70179_y = this.mz;
            entity.field_70177_z = this.yaw;
            entity.field_70125_A = this.pitch;
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

