/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.radio.imp;

import icbm.classic.api.data.IBoundBox;
import icbm.classic.api.radio.IRadioMessage;
import icbm.classic.api.radio.IRadioSender;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.radio.imp.Radio;
import java.util.Objects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class RadioTile<T extends TileEntity>
extends Radio {
    protected final T host;

    public RadioTile(T host) {
        this.host = host;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.host.func_174877_v();
    }

    @Override
    public World getWorld() {
        return this.host.func_145831_w();
    }

    @Override
    public IBoundBox<BlockPos> getRange() {
        return RadioRegistry.INFINITE;
    }

    public boolean canReceive(IRadioSender sender, IRadioMessage packet) {
        return !this.isDisabled() && sender != this && this.host.func_145830_o() && !this.host.func_145831_w().field_72995_K && Objects.equals(this.getChannel(), packet.getChannel());
    }

    public T getHost() {
        return this.host;
    }

    public String toString() {
        return "RadioTile(host=" + this.getHost() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RadioTile)) {
            return false;
        }
        RadioTile other = (RadioTile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        T this$host = this.getHost();
        T other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RadioTile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        T $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }
}

