/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.world;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.world.IProjectileBlockInteraction;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class ProjectileBlockInteraction {
    private static final HashMap<IBlockState, IProjectileBlockInteraction> stateToInteraction = new HashMap();
    private static final HashMap<Block, IProjectileBlockInteraction> blockToInteraction = new HashMap();
    private static final HashMap<Material, IProjectileBlockInteraction> materialToInteraction = new HashMap();

    public static void addBlockStateInteraction(IBlockState state, IProjectileBlockInteraction function) {
        if (stateToInteraction.containsKey(state)) {
            ICBMClassic.logger().warn("interaction already exists for " + state + " replacing", (Throwable)new RuntimeException());
        }
        stateToInteraction.put(state, function);
    }

    public static void addBlockInteraction(Block block, IProjectileBlockInteraction function) {
        if (blockToInteraction.containsKey(block)) {
            ICBMClassic.logger().warn("interaction already exists for " + block + " replacing", (Throwable)new RuntimeException());
        }
        blockToInteraction.put(block, function);
    }

    public static void addMaterialInteraction(Material material, IProjectileBlockInteraction function) {
        if (materialToInteraction.containsKey(material)) {
            ICBMClassic.logger().warn("interaction already exists for " + material + " replacing", (Throwable)new RuntimeException());
        }
        materialToInteraction.put(material, function);
    }

    public static void addCollisionInteraction(Block block) {
        ProjectileBlockInteraction.addBlockInteraction(block, (world, pos, hit, side, state, entity) -> IProjectileBlockInteraction.EnumHitReactions.CONTINUE_NO_IMPACT);
    }

    public static void breakBlockInteraction(Block block) {
        ProjectileBlockInteraction.addBlockInteraction(block, (world, pos, hit, side, state, entity) -> {
            if (ProjectileBlockInteraction.breakBlock(world, pos, state, entity)) {
                return IProjectileBlockInteraction.EnumHitReactions.CONTINUE_NO_IMPACT;
            }
            return IProjectileBlockInteraction.EnumHitReactions.CONTINUE;
        });
    }

    public static void breakMaterialInteraction(Material material) {
        ProjectileBlockInteraction.addMaterialInteraction(material, (world, pos, hit, side, state, entity) -> {
            if (ProjectileBlockInteraction.breakBlock(world, pos, state, entity)) {
                return IProjectileBlockInteraction.EnumHitReactions.CONTINUE_NO_IMPACT;
            }
            return IProjectileBlockInteraction.EnumHitReactions.CONTINUE;
        });
    }

    private static boolean breakBlock(World world, BlockPos pos, IBlockState state, Entity entity) {
        Block block = state.func_177230_c();
        if (block.canEntityDestroy(state, (IBlockAccess)world, pos, entity)) {
            block.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public static IProjectileBlockInteraction.EnumHitReactions handleSpecialInteraction(World world, BlockPos pos, Vec3d hit, EnumFacing side, IBlockState state, Entity entity) {
        IProjectileBlockInteraction.EnumHitReactions result;
        IProjectileBlockInteraction func = stateToInteraction.get(state);
        if (func != null && (result = func.apply(world, pos, hit, side, state, entity)) != null && result != IProjectileBlockInteraction.EnumHitReactions.PASS) {
            return result;
        }
        func = blockToInteraction.get(state.func_177230_c());
        if (func != null && (result = func.apply(world, pos, hit, side, state, entity)) != null && result != IProjectileBlockInteraction.EnumHitReactions.PASS) {
            return result;
        }
        func = materialToInteraction.get(state.func_185904_a());
        if (func != null && (result = func.apply(world, pos, hit, side, state, entity)) != null && result != IProjectileBlockInteraction.EnumHitReactions.PASS) {
            return result;
        }
        return IProjectileBlockInteraction.EnumHitReactions.CONTINUE;
    }

    public static void register() {
        ProjectileBlockInteraction.addCollisionInteraction((Block)Blocks.field_150427_aO);
        ProjectileBlockInteraction.addCollisionInteraction(Blocks.field_150384_bq);
        ProjectileBlockInteraction.addBlockInteraction(Blocks.field_185775_db, (world, pos, hit, side, state, entity) -> {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityEndGateway) {
                ((TileEntityEndGateway)tile).func_184306_a(entity);
                return IProjectileBlockInteraction.EnumHitReactions.TELEPORTED;
            }
            return IProjectileBlockInteraction.EnumHitReactions.CONTINUE_NO_IMPACT;
        });
        ProjectileBlockInteraction.breakMaterialInteraction(Material.field_151584_j);
        ProjectileBlockInteraction.breakMaterialInteraction(Material.field_151597_y);
        ProjectileBlockInteraction.breakMaterialInteraction(Material.field_151592_s);
    }
}

