/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab;

import icbm.classic.api.data.IBoundBox;
import icbm.classic.api.radio.IRadioMessage;
import icbm.classic.api.radio.IRadioReceiver;
import icbm.classic.api.radio.IRadioSender;
import icbm.classic.api.radio.messages.ITextMessage;
import icbm.classic.lib.data.BoundBlockPos;
import icbm.classic.lib.radio.RadioRegistry;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class FakeRadioSender
implements IRadioSender {
    private static final Object[] empty = new Object[0];
    public final EntityPlayer player;
    public final ItemStack item;
    IBoundBox<BlockPos> bounds;

    public FakeRadioSender(EntityPlayer player, ItemStack item, Integer range) {
        this.player = player;
        this.item = item;
        this.bounds = range != null ? new BoundBlockPos(player.func_180425_c(), (int)range) : RadioRegistry.INFINITE;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.player.func_180425_c();
    }

    @Override
    public World getWorld() {
        return this.player.func_130014_f_();
    }

    @Override
    public IBoundBox<BlockPos> getRange() {
        return this.bounds;
    }

    @Override
    public void onMessageCallback(IRadioReceiver receiver, IRadioMessage response) {
        if (response instanceof ITextMessage) {
            ITextMessage textMessage = (ITextMessage)response;
            if (textMessage.shouldTranslate()) {
                Object[] data = Optional.ofNullable(textMessage.getTranslationInputs()).orElse(empty);
                this.player.func_146105_b((ITextComponent)new TextComponentTranslation(textMessage.getMessage(), data), true);
            } else {
                this.player.func_146105_b((ITextComponent)new TextComponentString(((ITextMessage)response).getMessage()), true);
            }
        }
    }
}

