/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.gui;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.prefab.gui.IGuiComponent;
import icbm.classic.prefab.gui.button.GuiButtonBase;
import icbm.classic.prefab.gui.tooltip.IToolTip;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

public abstract class GuiContainerBase
extends GuiContainer {
    public static final ResourceLocation COMPONENTS_TEXTURE = new ResourceLocation("icbmclassic", "textures/gui/gui_components.png");
    public String currentTooltipText = "";
    protected ArrayList<IGuiComponent> components = new ArrayList();
    public boolean renderSlotDebugIDs = false;

    public GuiContainerBase(Container container) {
        super(container);
    }

    public abstract ResourceLocation getBackground();

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.components.clear();
    }

    @Deprecated
    protected <E extends GuiButton> E func_189646_b(E button) {
        if (button instanceof IGuiComponent) {
            this.addComponent((IGuiComponent)button);
        } else {
            this.field_146292_n.add(button);
        }
        return button;
    }

    protected void drawString(String str, int x, int y, int color) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(str, x, y, color);
    }

    protected void drawStringCentered(String str, int x, int y, int color) {
        this.drawString(str, x - Minecraft.func_71410_x().field_71466_p.func_78256_a(str) / 2, y, color);
    }

    protected <T extends IGuiComponent> T addComponent(T field) {
        if (field instanceof GuiButton) {
            this.field_146292_n.add((GuiButton)field);
        }
        this.components.add(field);
        field.onAddedToHost(this);
        return field;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.components.forEach(IGuiComponent::onUpdate);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.components.forEach(field -> {
            block3: {
                ITextComponent tooltip;
                field.drawForegroundLayer(mouseX, mouseY);
                if (field instanceof IToolTip && ((IToolTip)((Object)field)).isWithin(mouseX, mouseY) && (tooltip = ((IToolTip)((Object)field)).getTooltip()) != null) {
                    try {
                        this.currentTooltipText = this.buildToolTipString(tooltip);
                    }
                    catch (Exception e) {
                        if (!ICBMClassic.runningAsDev) break block3;
                        ICBMClassic.logger().error("Failed to format text for display", (Throwable)e);
                    }
                }
            }
        });
        if (!StringUtils.isEmpty((CharSequence)this.currentTooltipText)) {
            List<String> lines = LanguageUtility.splitByLine(this.currentTooltipText);
            this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r, lines);
        }
        this.currentTooltipText = "";
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.components.forEach(component -> component.draw(mouseX, mouseY, partialTicks));
    }

    protected void func_73869_a(char c, int id) throws IOException {
        if (id == 210) {
            this.renderSlotDebugIDs = !this.renderSlotDebugIDs;
        } else {
            boolean f = this.components.stream().anyMatch(component -> component.onKeyTyped(c, id));
            if (!f) {
                super.func_73869_a(c, id);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(this.getBackground());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.components.forEach(component -> component.drawBackgroundLayer(partialTicks, mouseX, mouseY));
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.components.forEach(component -> {
            if (!(component instanceof GuiButton)) {
                component.onMouseClick(mouseX, mouseY, mouseButton);
            }
        });
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiButtonBase) {
            ((GuiButtonBase)button).triggerAction();
        }
    }

    protected void drawRectWithScaledWidth(int x, int y, int u, int v, int width, int height, int newWidth) {
        if (width > 0) {
            if (newWidth <= 0 || width == newWidth) {
                this.func_73729_b(x, y, u, v, width, height);
            }
            int midWidth = width - 6;
            this.func_73729_b(x, y, u, v, 3, height);
            x += 3;
            if (newWidth > 6) {
                int loops;
                for (loops = newWidth / width; loops > 0; --loops) {
                    this.func_73729_b(x, y, u + 3, v, midWidth, height);
                    x += midWidth;
                }
                loops = newWidth % width;
                if (loops != 0) {
                    this.func_73729_b(x, y, u + 3, v, loops, height);
                    x += loops;
                }
            }
            if (width > 3) {
                this.func_73729_b(x, y, u + width - 3, v, 3, height);
            }
        }
    }

    public String buildToolTipString(ITextComponent textComponent) {
        StringBuilder stringbuilder = new StringBuilder();
        for (ITextComponent itextcomponent : textComponent) {
            String s = itextcomponent.func_150261_e();
            if (s.isEmpty()) continue;
            stringbuilder.append(itextcomponent.func_150256_b().func_150218_j());
            stringbuilder.append(s);
        }
        return stringbuilder.toString();
    }

    public void drawTooltip(int x, int y, Collection<String> toolTips) {
        if (toolTips != null) {
            GlStateManager.func_179101_C();
            GlStateManager.func_179097_i();
            int textMaxWidth = 0;
            for (String line : toolTips) {
                int lineWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(line);
                if (lineWidth <= textMaxWidth) continue;
                textMaxWidth = lineWidth;
            }
            int backgroundX = x + 12;
            int backgroundY = y - 12;
            int var9 = 8;
            if (toolTips.size() > 1) {
                var9 += 2 + (toolTips.size() - 1) * 10;
            }
            if (this.field_147009_r + backgroundY + var9 + 6 > this.field_146295_m) {
                backgroundY = this.field_146295_m - var9 - this.field_147009_r - 6;
            }
            this.field_73735_i = 300.0f;
            int var10 = -267386864;
            this.func_73733_a(backgroundX - 3, backgroundY - 4, backgroundX + textMaxWidth + 3, backgroundY - 3, var10, var10);
            this.func_73733_a(backgroundX - 3, backgroundY + var9 + 3, backgroundX + textMaxWidth + 3, backgroundY + var9 + 4, var10, var10);
            this.func_73733_a(backgroundX - 3, backgroundY - 3, backgroundX + textMaxWidth + 3, backgroundY + var9 + 3, var10, var10);
            this.func_73733_a(backgroundX - 4, backgroundY - 3, backgroundX - 3, backgroundY + var9 + 3, var10, var10);
            this.func_73733_a(backgroundX + textMaxWidth + 3, backgroundY - 3, backgroundX + textMaxWidth + 4, backgroundY + var9 + 3, var10, var10);
            int var11 = 0x505000FF;
            int var12 = (var11 & 0xFEFEFE) >> 1 | var11 & 0xFF000000;
            this.func_73733_a(backgroundX - 3, backgroundY - 3 + 1, backgroundX - 3 + 1, backgroundY + var9 + 3 - 1, var11, var12);
            this.func_73733_a(backgroundX + textMaxWidth + 2, backgroundY - 3 + 1, backgroundX + textMaxWidth + 3, backgroundY + var9 + 3 - 1, var11, var12);
            this.func_73733_a(backgroundX - 3, backgroundY - 3, backgroundX + textMaxWidth + 3, backgroundY - 3 + 1, var11, var11);
            this.func_73733_a(backgroundX - 3, backgroundY + var9 + 2, backgroundX + textMaxWidth + 3, backgroundY + var9 + 3, var12, var12);
            for (String line : toolTips) {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(line, (float)backgroundX, (float)backgroundY, -1);
                backgroundY += 10;
            }
            this.field_73735_i = 0.0f;
            GlStateManager.func_179126_j();
            GlStateManager.func_179091_B();
        }
    }
}

