/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.gui.components;

import icbm.classic.prefab.gui.GuiContainerBase;
import icbm.classic.prefab.gui.IGuiComponent;
import icbm.classic.prefab.gui.tooltip.IToolTip;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class SlotEnergyBar
implements IGuiComponent,
IToolTip {
    private static final int ENERGY_BAR_WIDTH = 16;
    private static final int ENERGY_BAR_HEIGHT = 2;
    private static final String TOOLTIP_FORMAT = "gui.icbmclassic:energy";
    private static final String TOOLTIP_FORMAT_COST = "gui.icbmclassic:energy.withCost";
    private static final String TOOLTIP_FORMAT_ACTION = "gui.icbmclassic:energy.withAction";
    private static final String TOOLTIP_FORMAT_COST_ACTION = "gui.icbmclassic:energy.withCostAndAction";
    private final int x;
    private final int y;
    private final Supplier<Integer> energyGetter;
    private final Supplier<Integer> energyMaxGetter;
    private Supplier<Integer> tickingCostGetter;
    private Supplier<Integer> actionCostGetter;
    private GuiContainerBase container;
    private float energyPercent = 0.0f;
    private int prevEnergy = 0;
    private int prevMaxEnergy = 0;
    private boolean prevShift = false;
    private ITextComponent tooltip;

    public SlotEnergyBar(int x, int y, Supplier<Integer> energyGetter, Supplier<Integer> energyMaxGetter) {
        this.x = x;
        this.y = y;
        this.energyGetter = energyGetter;
        this.energyMaxGetter = energyMaxGetter;
    }

    public SlotEnergyBar withTickingCost(Supplier<Integer> getter) {
        this.tickingCostGetter = getter;
        return this;
    }

    public SlotEnergyBar withActionCost(Supplier<Integer> getter) {
        this.actionCostGetter = getter;
        return this;
    }

    @Override
    public void onUpdate() {
        int energy = this.energyGetter.get();
        int maxEnergy = this.energyMaxGetter.get();
        int tickingCost = Optional.ofNullable(this.tickingCostGetter).map(Supplier::get).orElse(0);
        int actionCost = Optional.ofNullable(this.actionCostGetter).map(Supplier::get).orElse(0);
        boolean shift = GuiScreen.func_146272_n();
        if (energy != this.prevEnergy || maxEnergy != this.prevMaxEnergy || shift != this.prevShift) {
            this.prevEnergy = energy;
            this.prevMaxEnergy = maxEnergy;
            this.prevShift = shift;
            this.energyPercent = (float)energy / (float)maxEnergy;
            String translationToUse = TOOLTIP_FORMAT;
            if (tickingCost > 0) {
                translationToUse = TOOLTIP_FORMAT_COST;
                if (actionCost > 0) {
                    translationToUse = TOOLTIP_FORMAT_COST_ACTION;
                }
            } else if (actionCost > 0) {
                translationToUse = TOOLTIP_FORMAT_ACTION;
            }
            this.tooltip = shift ? new TextComponentTranslation(translationToUse, new Object[]{energy, maxEnergy, -tickingCost, -actionCost}) : new TextComponentTranslation(translationToUse, new Object[]{SlotEnergyBar.formatEnergy(energy), SlotEnergyBar.formatEnergy(maxEnergy), SlotEnergyBar.formatEnergy(-tickingCost), SlotEnergyBar.formatEnergy(-actionCost)});
        }
    }

    private static String formatEnergy(int energy) {
        boolean neg = energy < 0;
        int number = Math.abs(energy);
        String type = "";
        if (number >= 1000000000) {
            number /= 1000000000;
            type = "G";
        } else if (number >= 1000000) {
            number /= 1000000;
            type = "M";
        } else if (number >= 1000) {
            number /= 1000;
            type = "k";
        }
        return String.format("%s%d%s", neg ? "-" : "", number, type);
    }

    @Override
    public void onAddedToHost(GuiContainerBase container) {
        this.container = container;
    }

    @Override
    public void drawBackgroundLayer(float f, int mouseX, int mouseY) {
        this.container.field_146297_k.field_71446_o.func_110577_a(this.container.getBackground());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float barRatio = (float)Math.floor(16.0f * this.energyPercent);
        boolean minBar = this.energyPercent > 0.0f;
        int renderWidth = (int)Math.min(Math.max((float)minBar, barRatio), 16.0f);
        this.container.func_73729_b(this.container.getGuiLeft() + this.x, this.container.getGuiTop() + this.y, 240, 0, renderWidth, 2);
    }

    @Override
    public boolean isWithin(int mouseX, int mouseY) {
        int cursorX = mouseX - this.container.getGuiLeft();
        int cursorY = mouseY - this.container.getGuiTop();
        return cursorX >= this.x && cursorY >= this.y && cursorX < this.x + 16 && cursorY < this.y + 2;
    }

    @Override
    public ITextComponent getTooltip() {
        return this.tooltip;
    }
}

