/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.client.gui;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.wirelessredstone.client.gui.GuiWirelessSniffer;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.network.WRClientPH;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;

public class GuiPrivateSniffer
extends GuiWirelessSniffer {
    public GuiPrivateSniffer() {
        this.title = "Private Sniffer";
    }

    protected void func_73864_a(int mousex, int mousey, int button) throws IOException {
        int freq = this.getFreqMouseOver(mousex, mousey);
        if (freq == 0) {
            super.func_73864_a(mousex, mousey, button);
            return;
        }
        if (RedstoneEther.get(true).canBroadcastOnFrequency((EntityPlayer)this.field_146297_k.field_71439_g, freq) && freq > RedstoneEther.get(true).getLastPublicFrequency() && freq <= RedstoneEther.get(true).getLastSharedFrequency()) {
            String name = RedstoneEther.get(true).isFreqPrivate(freq) ? "" : this.field_146297_k.field_71439_g.func_70005_c_();
            WRClientPH.sendSetFreqOwner(freq, name);
        }
    }

    @Override
    public String getFreqTip(int freq) {
        if (RedstoneEther.get(true).isPlayerJammed((EntityPlayer)this.field_146297_k.field_71439_g)) {
            return "Jammed " + freq;
        }
        if (RedstoneEther.get(true).isFreqPrivate(freq)) {
            return (RedstoneEther.get(true).getFreqOwner(freq).equalsIgnoreCase(this.field_146297_k.field_71439_g.func_70005_c_()) ? "Owned " : "Private ") + freq;
        }
        if (!RedstoneEther.get(true).canBroadcastOnFrequency((EntityPlayer)this.field_146297_k.field_71439_g, freq)) {
            return "Jammed " + freq;
        }
        if (freq <= RedstoneEther.get(true).getLastPublicFrequency()) {
            return "Public " + freq;
        }
        if (freq <= RedstoneEther.get(true).getLastSharedFrequency()) {
            return "Shared " + freq;
        }
        return "" + freq;
    }

    @Override
    public Colour getColour(int freq) {
        if (RedstoneEther.get(true).isPlayerJammed((EntityPlayer)this.field_146297_k.field_71439_g) || !RedstoneEther.get(true).canBroadcastOnFrequency((EntityPlayer)this.field_146297_k.field_71439_g, freq)) {
            return colourJammed;
        }
        if (RedstoneEther.get(true).isFreqPrivate(freq) && RedstoneEther.get(true).getFreqOwner(freq).equalsIgnoreCase(this.field_146297_k.field_71439_g.func_70005_c_())) {
            return colourPOff.copy().interpolate((Colour)colourPOn, (double)((float)this.brightness[freq - 1] / 64.0f));
        }
        Colour colour = colourOff.copy().interpolate((Colour)colourOn, (double)((float)this.brightness[freq - 1] / 64.0f));
        if (freq <= RedstoneEther.get(true).getLastPublicFrequency()) {
            colour.interpolate((Colour)colourJammed, 0.5);
        }
        return colour;
    }

    @Override
    public Colour getBorder(int freq) {
        if (RedstoneEther.get(true).isPlayerJammed((EntityPlayer)this.field_146297_k.field_71439_g) || !RedstoneEther.get(true).canBroadcastOnFrequency((EntityPlayer)this.field_146297_k.field_71439_g, freq)) {
            return borderJammed;
        }
        if (RedstoneEther.get(true).isFreqPrivate(freq) && RedstoneEther.get(true).getFreqOwner(freq).equalsIgnoreCase(this.field_146297_k.field_71439_g.func_70005_c_())) {
            return borderPOff.copy().interpolate((Colour)borderPOn, (double)((float)this.brightness[freq - 1] / 64.0f));
        }
        Object border = RedstoneEther.get(true).getFreqColourId(freq) != -1 ? new ColourARGB(RedstoneEther.get(true).getFreqColour(freq)) : borderOff.copy().interpolate((Colour)borderOn, (double)((float)this.brightness[freq - 1] / 64.0f));
        if (freq <= RedstoneEther.get(true).getLastPublicFrequency()) {
            border.interpolate((Colour)borderJammed, 0.7);
        }
        return border;
    }
}

