/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.client.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.item.map.IMapRenderer;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.wirelessredstone.api.ClientMapInfo;
import codechicken.wirelessredstone.api.FreqCoord;
import codechicken.wirelessredstone.init.ModItems;
import codechicken.wirelessredstone.item.ItemWirelessMap;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.manager.RedstoneEtherAddons;
import codechicken.wirelessredstone.util.WirelessMapNodeStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;

public class WirelessMapRenderer
implements IMapRenderer {
    private void renderPass(CCRenderState ccrs, int xCenter, int zCenter, int scale, WirelessMapNodeStorage mapstorage, float size, float alpha, float light) {
        float zrot;
        float xrot;
        float rot;
        float b;
        float g;
        float r;
        int colour;
        float relz;
        float relx;
        BufferBuilder buffer = ccrs.getBuffer();
        float blockscale = 1 << scale;
        for (FreqCoord node : mapstorage.nodes) {
            relx = (float)node.x / blockscale + 64.0f;
            relz = (float)node.z / blockscale + 64.0f;
            colour = RedstoneEther.client().getFreqColour(node.freq);
            if (colour == -1) {
                colour = -65536;
            }
            r = (float)(colour >> 16 & 0xFF) / 255.0f * light;
            g = (float)(colour >> 8 & 0xFF) / 255.0f * light;
            b = (float)(colour & 0xFF) / 255.0f * light;
            rot = RedstoneEther.getRotation(ClientUtils.getRenderTime(), node.freq);
            xrot = (float)(Math.sin(rot) * (double)size);
            zrot = (float)(Math.cos(rot) * (double)size);
            buffer.func_181662_b((double)(relx - zrot), (double)(relz + xrot), -0.01).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b((double)(relx + xrot), (double)(relz + zrot), -0.01).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b((double)(relx + zrot), (double)(relz - xrot), -0.01).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b((double)(relx - xrot), (double)(relz - zrot), -0.01).func_181666_a(r, g, b, alpha).func_181675_d();
        }
        for (FreqCoord node : mapstorage.devices) {
            relx = (float)(node.x - xCenter) / blockscale + 64.0f;
            relz = (float)(node.z - zCenter) / blockscale + 64.0f;
            colour = RedstoneEther.client().getFreqColour(node.freq);
            if (colour == -1) {
                colour = -65536;
            }
            r = (float)(colour >> 16 & 0xFF) / 255.0f * light;
            g = (float)(colour >> 8 & 0xFF) / 255.0f * light;
            b = (float)(colour & 0xFF) / 255.0f * light;
            rot = RedstoneEther.getRotation(ClientUtils.getRenderTime(), node.freq);
            xrot = (float)(Math.sin(rot) * (double)size);
            zrot = (float)(Math.cos(rot) * (double)size);
            buffer.func_181662_b((double)(relx - zrot), (double)(relz + xrot), -0.01).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b((double)(relx + xrot), (double)(relz + zrot), -0.01).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b((double)(relx + zrot), (double)(relz - xrot), -0.01).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b((double)(relx - xrot), (double)(relz - zrot), -0.01).func_181666_a(r, g, b, alpha).func_181675_d();
        }
    }

    public void render(ItemStack stack, MapData data, boolean inFrame) {
        WirelessMapNodeStorage mapstorage = RedstoneEtherAddons.client().getMapNodes();
        if (stack == null || stack.func_77973_b() != ModItems.itemWirelessMap) {
            return;
        }
        ClientMapInfo mapinfo = RedstoneEtherAddons.client().getMPMapInfo((short)stack.func_77952_i());
        if (mapinfo == null) {
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float light = 1.0f;
        int xCenter = mapinfo.xCenter;
        int zCenter = mapinfo.zCenter;
        byte scale = mapinfo.scale;
        ccrs.startDrawing(7, DefaultVertexFormats.field_181706_f);
        this.renderPass(ccrs, xCenter, zCenter, scale, mapstorage, 0.75f, 1.0f, light * 0.5f);
        this.renderPass(ccrs, xCenter, zCenter, scale, mapstorage, 0.6f, 1.0f, light);
        ccrs.draw();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
    }

    public boolean shouldHandle(ItemStack stack, boolean inFrame) {
        return stack.func_77973_b() instanceof ItemWirelessMap;
    }

    public void renderMap(ItemStack stack, boolean inFrame) {
        MapData data = ((ItemWirelessMap)stack.func_77973_b()).func_77873_a(stack, (World)Minecraft.func_71410_x().field_71441_e);
        if (inFrame) {
            TextureUtils.changeTexture((String)"textures/map/map_background.png");
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
            GlStateManager.func_179109_b((float)-64.0f, (float)-64.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            if (data != null) {
                Minecraft.func_71410_x().field_71460_t.func_147701_i().func_148250_a(data, inFrame);
            }
        } else {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)0.38f, (float)0.38f, (float)0.38f);
            GlStateManager.func_179140_f();
            TextureUtils.changeTexture((String)"textures/map/map_background.png");
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(-7.0, 135.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b(135.0, 135.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b(135.0, -7.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            vertexbuffer.func_181662_b(-7.0, -7.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            if (data != null) {
                Minecraft.func_71410_x().field_71460_t.func_147701_i().func_148250_a(data, inFrame);
            }
        }
        this.render(stack, data, inFrame);
    }
}

