/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.recipe;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicEvent;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SchematicRegistry {
    public static ArrayList<ISchematicPage> schematicRecipes = new ArrayList();
    public static ArrayList<ItemStack> schematicItems = new ArrayList();
    public static ArrayList<ResourceLocation> textures = new ArrayList();

    public static void registerSchematicRecipe(ISchematicPage page) {
        if (!schematicRecipes.contains(page)) {
            schematicRecipes.add(page);
        }
    }

    public static ISchematicPage getMatchingRecipeForItemStack(ItemStack stack) {
        for (ISchematicPage schematic : schematicRecipes) {
            ItemStack requiredItem = schematic.getRequiredItem();
            if (requiredItem == null || stack == null || !requiredItem.func_77969_a(stack)) continue;
            return schematic;
        }
        return null;
    }

    public static ISchematicPage getMatchingRecipeForID(int id) {
        for (ISchematicPage schematic : schematicRecipes) {
            if (schematic.getPageID() != id) continue;
            return schematic;
        }
        return null;
    }

    public static void addUnlockedPage(EntityPlayerMP player, ISchematicPage page) {
        if (page != null) {
            MinecraftForge.EVENT_BUS.post((Event)new SchematicEvent.Unlock(player, page));
        }
    }

    public static ISchematicPage unlockNewPage(EntityPlayerMP player, ItemStack stack) {
        ISchematicPage schematic;
        if (stack != null && (schematic = SchematicRegistry.getMatchingRecipeForItemStack(stack)) != null) {
            SchematicRegistry.addUnlockedPage(player, schematic);
            return schematic;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void flipToNextPage(GuiScreen cs, int currentIndex) {
        FMLClientHandler.instance().getClient().field_71462_r = null;
        MinecraftForge.EVENT_BUS.post((Event)new SchematicEvent.FlipPage(cs, null, currentIndex, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public static void flipToLastPage(GuiScreen cs, int currentIndex) {
        FMLClientHandler.instance().getClient().field_71462_r = null;
        MinecraftForge.EVENT_BUS.post((Event)new SchematicEvent.FlipPage(cs, null, currentIndex, -1));
    }

    public static void registerTexture(ResourceLocation loc) {
        textures.add(loc);
    }

    public static ResourceLocation getSchematicTexture(int index) {
        if (index < textures.size()) {
            return textures.get(index);
        }
        GalacticraftCore.logger.debug("couldn't find render texture for " + index, new Object[0]);
        return textures.get(0);
    }

    public static int registerSchematicItem(ItemStack item) {
        int index = schematicItems.size();
        schematicItems.add(item);
        return index;
    }

    public static ItemStack getSchematicItem(int index) {
        if (index < schematicItems.size()) {
            return schematicItems.get(index).func_77946_l();
        }
        GalacticraftCore.logger.debug("couldn't find schematic item for " + index, new Object[0]);
        return schematicItems.get(0).func_77946_l();
    }
}

