/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.util.ItemUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityCoalGenerator
extends TileBaseUniversalElectricalSource
implements IInventoryDefaults,
ISidedInventory,
IConnector {
    private final int dustCoalCookTime = 220;
    private final int itemCoalCookTime = 320;
    private final int blockCoalCookTime = 3200;
    private final int dustCharcoalCookTime = 120;
    private final int itemCharcoalCookTime = 160;
    private final int blockCharcoalCookTime = 1600;
    public static final int MAX_GENERATE_GJ_PER_TICK = 150;
    public static final int MIN_GENERATE_GJ_PER_TICK = 30;
    private static final float BASE_ACCELERATION = 0.3f;
    public float prevGenerateWatts = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float heatGJperTick = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int itemCookTime = 0;

    public TileEntityCoalGenerator() {
        super("tile.machine.0.name");
        this.storage.setMaxExtract(120.0f);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.heatGJperTick - 30.0f > 0.0f) {
            this.receiveEnergyGC(null, this.heatGJperTick - 30.0f, false);
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            if (this.itemCookTime > 0) {
                --this.itemCookTime;
                this.heatGJperTick = Math.min(this.heatGJperTick + Math.max(this.heatGJperTick * 0.005f, 0.3f), 150.0f);
            }
            if (this.itemCookTime <= 0 && !((ItemStack)this.getInventory().get(0)).func_190926_b() && (stack = (ItemStack)this.getInventory().get(0)).func_190916_E() > 0) {
                if (ItemUtil.hasOreDictSuffix(stack, "charcoal")) {
                    if (ItemUtil.isBlock(stack)) {
                        this.handleFuel(1600);
                    } else if (ItemUtil.isDust(stack)) {
                        this.handleFuel(120);
                    } else {
                        this.handleFuel(160);
                    }
                } else if (ItemUtil.hasOreDictSuffix(stack, "coal")) {
                    if (ItemUtil.isBlock(stack)) {
                        this.handleFuel(3200);
                    } else if (ItemUtil.isDust(stack)) {
                        this.handleFuel(220);
                    } else {
                        this.handleFuel(320);
                    }
                } else if (stack.func_77973_b() == Items.field_151044_h) {
                    this.itemCookTime = 320;
                    this.func_70298_a(0, 1);
                } else if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci) && stack.func_190916_E() > 0) {
                    this.itemCookTime = 3200;
                    this.func_70298_a(0, 1);
                }
            }
            this.produce();
            if (this.itemCookTime <= 0) {
                this.heatGJperTick = Math.max(this.heatGJperTick - 0.3f, 0.0f);
            }
            this.heatGJperTick = Math.min(Math.max(this.heatGJperTick, 0.0f), this.getMaxEnergyStoredGC());
        }
    }

    private void handleFuel(int cookTime) {
        this.itemCookTime = cookTime;
        this.func_70298_a(0, 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.itemCookTime = nbt.func_74762_e("itemCookTime");
        this.heatGJperTick = nbt.func_74762_e("generateRateInt");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("itemCookTime", this.itemCookTime);
        nbt.func_74776_a("generateRate", this.heatGJperTick);
        return nbt;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing direction) {
        return slotID == 0;
    }

    @Override
    public float receiveElectricity(EnumFacing from, float energy, int tier, boolean doReceive) {
        return 0.0f;
    }

    @Override
    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(this.getElectricOutputDirection());
    }

    public EnumFacing byIndex() {
        return BlockMachineBase.byIndex(this.field_145850_b.func_180495_p(this.func_174877_v()));
    }

    @Override
    public EnumFacing getElectricOutputDirection() {
        return this.byIndex().func_176746_e();
    }

    @Override
    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type != NetworkType.POWER) {
            return false;
        }
        return direction == this.getElectricOutputDirection();
    }
}

