/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.vector.BlockTuple;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class BlockUtil {
    public static final String FULL_ID_MATCHER = "^(?<resloc>(?<namespace>[a-z\\d\\._-]+):(?<path>[a-z\\d\\._-]+))(?::(?<meta>[0-9\\*]{1,}))?$";
    public static final String SHORTHAND_MATCHER = "^(?<resloc>[a-z\\d\\._-]+)(?::(?<meta>[0-9\\*]{1,}))?$";
    public static final Pattern FULL_ID_REGEX = Pattern.compile("^(?<resloc>(?<namespace>[a-z\\d\\._-]+):(?<path>[a-z\\d\\._-]+))(?::(?<meta>[0-9\\*]{1,}))?$");
    public static final Pattern SHORTHAND_REGEX = Pattern.compile("^(?<resloc>[a-z\\d\\._-]+)(?::(?<meta>[0-9\\*]{1,}))?$");

    public static NonNullList<ItemStack> getListFromStringArray(String[] strArr) {
        NonNullList nnl = NonNullList.func_191196_a();
        for (String str : strArr) {
            BlockUtil.addToBlockStackList(BlockUtil.getResloc(str), (NonNullList<ItemStack>)nnl);
        }
        return nnl;
    }

    public static NonNullList<MultiBlockStateHolder> getBlockStateHolderList(NonNullList<ItemStack> itemStacks) {
        HashMap stateList = new HashMap();
        for (ItemStack stack : itemStacks) {
            Block b = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            IBlockState state = b.func_176203_a(stack.func_77973_b().func_77647_b(stack.func_77960_j()));
            if (stateList.keySet().contains(b)) {
                if (((List)stateList.get(b)).contains(state)) continue;
                ((List)stateList.get(b)).add(state);
                continue;
            }
            ArrayList<IBlockState> list = new ArrayList<IBlockState>();
            list.add(state);
            stateList.put(b, list);
        }
        NonNullList mbsl = NonNullList.func_191196_a();
        for (Map.Entry e : stateList.entrySet()) {
            mbsl.add((Object)new MultiBlockStateHolder((Block)e.getKey(), (List)e.getValue()));
        }
        return mbsl;
    }

    public static BlockTuple getBlockTupleFromString(String string) {
        Block oldFormat = BlockUtil.parseBlockFromOldConfigFormat(string);
        if (oldFormat != null) {
            GalacticraftCore.logger.debug("oldFormat: " + string, new Object[0]);
            return new BlockTuple(oldFormat, BlockUtil.parseMetaFromOldConfigFormat(string));
        }
        ItemStack s = BlockUtil.getItemStackFromString(string);
        return new BlockTuple(((ItemBlock)s.func_77973_b()).func_179223_d(), s.func_77960_j());
    }

    @Nullable
    private static Block parseBlockFromOldConfigFormat(String string) {
        return Block.func_149684_b((String)string);
    }

    private static int parseMetaFromOldConfigFormat(String string) {
        int lastColon = string.lastIndexOf(58);
        int meta = -1;
        if (lastColon > 0) {
            try {
                meta = Integer.parseInt(string.substring(lastColon + 1, string.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return meta;
    }

    public static ItemStack getItemStackFromString(String string) {
        return BlockUtil.getItemStackFromResloc(BlockUtil.getResloc(string));
    }

    private static void addToBlockStackList(Resloc resloc, NonNullList<ItemStack> nnl) {
        GalacticraftCore.logger.debug("Attempting to locate Block with ResourceLocation: " + resloc.toString() + " | Input: " + resloc.rawInput, new Object[0]);
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)resloc);
        if (resloc.isBlock(block)) {
            ItemStack i = resloc.toItemStack(block);
            if (resloc.isWildcard() && i.func_77981_g()) {
                i.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, nnl);
            } else {
                nnl.add((Object)i);
            }
        } else {
            GalacticraftCore.logger.error("No block with ResourceLocation (" + resloc.rawInput + ") could be located. Skipping", new Object[0]);
        }
    }

    private static ItemStack getItemStackFromResloc(Resloc resloc) {
        NonNullList nnl = NonNullList.func_191196_a();
        BlockUtil.addToBlockStackList(resloc, (NonNullList<ItemStack>)nnl);
        return (ItemStack)nnl.get(0);
    }

    public static Resloc getResloc(String string) {
        boolean isShorthand = string.matches(SHORTHAND_MATCHER);
        Matcher m = isShorthand ? SHORTHAND_REGEX.matcher(string) : FULL_ID_REGEX.matcher(string);
        boolean found = m.find();
        if (found) {
            if (m.group("meta") != null) {
                return Resloc.of(m.group("resloc"), m.group("meta"));
            }
            return Resloc.of(m.group("resloc"));
        }
        return Resloc.of("null");
    }

    public static class MultiBlockStateHolder {
        private Block block;
        private List<IBlockState> blockstateList = new ArrayList<IBlockState>();

        private MultiBlockStateHolder() {
        }

        public MultiBlockStateHolder(Block block, List<IBlockState> blockstateList) {
            this.block = block;
            this.blockstateList = blockstateList;
        }

        public Block getBlock() {
            return this.block;
        }

        public List<IBlockState> getBlockstateList() {
            return this.blockstateList;
        }
    }

    public static class Resloc
    extends ResourceLocation {
        private String rawInput;
        private int meta;

        public static Resloc of(String resourceName, String meta) {
            return new Resloc(resourceName, meta);
        }

        public static Resloc of(String resourceName) {
            return new Resloc(resourceName);
        }

        public Resloc(String resourceName) {
            this(resourceName, "");
        }

        public Resloc(String resourceName, String meta) {
            super(resourceName);
            this.rawInput = resourceName;
            this.setMetaValue(meta);
        }

        private void setMetaValue(String meta) {
            this.rawInput = meta.isEmpty() ? this.rawInput : this.rawInput + ":" + meta;
            this.meta = meta.equals("*") ? Short.MAX_VALUE : this.safeParse(meta);
        }

        public boolean isBlock(Block block) {
            return block.getRegistryName().equals((Object)this);
        }

        private int safeParse(String str) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        public int getMeta() {
            return this.meta;
        }

        public boolean isWildcard() {
            return this.meta == Short.MAX_VALUE;
        }

        public ItemStack toItemStack(Block block) {
            return this.meta > 0 ? new ItemStack(block, 1, this.meta) : new ItemStack(block);
        }
    }
}

