/*
 * Decompiled with CFR 0.152.
 */
package extracells.item.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import extracells.api.IPortableStorageCell;
import extracells.item.storage.CellDefinition;
import extracells.item.storage.ItemStorageCell;
import extracells.models.ModelManager;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public abstract class ItemStorageCellPortable<T extends IAEStack<T>>
extends ItemStorageCell<T>
implements IPortableStorageCell,
IAEItemPowerStorage {
    public static final double MAX_POWER = 20000.0;

    public ItemStorageCellPortable(CellDefinition definition, IStorageChannel<T> channel) {
        super(definition, channel);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    @Override
    @Nonnull
    public abstract ActionResult<ItemStack> func_77659_a(World var1, EntityPlayer var2, @Nonnull EnumHand var3);

    @Override
    @Nonnull
    public abstract String func_77667_c(ItemStack var1);

    @Override
    public abstract void registerModel(Item var1, ModelManager var2);

    @Override
    public int getBytes(@Nonnull ItemStack cellItem) {
        return 512;
    }

    @Override
    public int getTotalTypes(@Nonnull ItemStack cellItem) {
        return 3;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag advanced) {
        super.func_77624_a(itemStack, world, list, advanced);
        double currentAEPower = this.getAECurrentPower(itemStack);
        double percent = Math.floor(currentAEPower / 20000.0 * 10000.0) / 100.0;
        list.add(I18n.func_135052_a((String)"gui.appliedenergistics2.StoredEnergy", (Object[])new Object[0]) + ": " + currentAEPower + " AE - " + percent + "%");
    }

    @Override
    public void func_150895_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        list.add((Object)new ItemStack((Item)this));
        ItemStack powered = new ItemStack((Item)this);
        this.injectAEPower(powered, this.getAEMaxPower(powered), Actionable.MODULATE);
        list.add((Object)powered);
    }

    @Override
    @Nonnull
    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.RARE;
    }

    public double injectAEPower(ItemStack stack, double amount, Actionable mode) {
        NBTTagCompound tag = this.getTag(stack);
        double current = this.getAECurrentPower(stack);
        double toAdd = Math.min(this.getAEMaxPower(stack) - current, amount);
        if (mode == Actionable.MODULATE) {
            tag.func_74780_a("power", current + toAdd);
        }
        return amount - toAdd;
    }

    public double extractAEPower(ItemStack stack, double amount, Actionable mode) {
        NBTTagCompound tag = this.getTag(stack);
        double current = this.getAECurrentPower(stack);
        double toRemove = Math.min(current, amount);
        if (mode == Actionable.MODULATE) {
            tag.func_74780_a("power", current - toRemove);
        }
        return toRemove;
    }

    @Override
    public boolean hasPower(EntityPlayer player, double amount, ItemStack is) {
        return this.getAECurrentPower(is) >= amount;
    }

    @Override
    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        this.extractAEPower(is, amount, Actionable.MODULATE);
        return true;
    }

    public double getAEMaxPower(ItemStack stack) {
        return 20000.0;
    }

    public double getAECurrentPower(ItemStack stack) {
        return this.getTag(stack).func_74769_h("power");
    }

    public AccessRestriction getPowerFlow(ItemStack stack) {
        return AccessRestriction.READ_WRITE;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getAECurrentPower(stack) / this.getAEMaxPower(stack);
    }

    @Nonnull
    protected NBTTagCompound getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return Objects.requireNonNull(stack.func_77978_p());
    }
}

