/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class TesseractReference {
    private final long index;
    private final int dimension;
    private final BlockPos pos;
    private final boolean isClientSide;
    private final EnumMap<EnumChannelType, Integer> channels = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canSend = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canReceive = new EnumMap(EnumChannelType.class);
    private WeakReference<TesseractBlockEntity> entity;

    public TesseractReference(long index, TesseractBlockEntity entity) {
        this.index = index;
        this.dimension = entity.func_145831_w().field_73011_w.getDimension();
        this.pos = entity.func_174877_v();
        this.isClientSide = entity.func_145831_w().field_72995_K;
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, -1);
            this.canSend.put(type, entity.canSend(type));
            this.canReceive.put(type, entity.canReceive(type));
        }
    }

    public TesseractReference(long index, NBTTagCompound tag, boolean isClientSide) {
        this.index = index;
        this.dimension = tag.func_74762_e("dim");
        this.pos = new BlockPos(tag.func_74762_e("posx"), tag.func_74762_e("posy"), tag.func_74762_e("posz"));
        this.isClientSide = isClientSide;
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, tag.func_74762_e((Object)((Object)type) + "_channel"));
            this.canSend.put(type, tag.func_74767_n((Object)((Object)type) + "_canSend"));
            this.canReceive.put(type, tag.func_74767_n((Object)((Object)type) + "_canReceive"));
        }
    }

    public long getSaveIndex() {
        return this.index;
    }

    public int getDimension() {
        return this.dimension;
    }

    public World getLevel() {
        if (this.isClientSide) {
            return ClientUtils.getWorld().field_73011_w.getDimension() == this.dimension ? ClientUtils.getWorld() : null;
        }
        return DimensionManager.getWorld((int)this.dimension);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isValid() {
        boolean isValid;
        World level = this.getLevel();
        boolean bl = isValid = level != null && level.func_180495_p(this.pos).func_177230_c() == Tesseract.tesseract && level.func_175625_s(this.pos) instanceof TesseractBlockEntity;
        if (!isValid && !this.isClientSide) {
            TesseractTracker.SERVER.remove(this.dimension, this.pos);
        }
        return isValid;
    }

    public boolean canBeAccessed() {
        World level = this.getLevel();
        return level != null && level.func_175667_e(this.pos) && this.isValid();
    }

    public TesseractBlockEntity getTesseract() {
        if (this.entity == null || this.entity.get() == null || ((TesseractBlockEntity)((Object)this.entity.get())).func_145837_r() || !((TesseractBlockEntity)((Object)this.entity.get())).func_174877_v().equals((Object)this.pos)) {
            this.entity = new WeakReference<TesseractBlockEntity>((TesseractBlockEntity)this.getLevel().func_175625_s(this.pos));
        }
        return this.entity == null ? null : (TesseractBlockEntity)((Object)this.entity.get());
    }

    public NBTTagCompound write() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("dim", this.dimension);
        compound.func_74768_a("posx", this.pos.func_177958_n());
        compound.func_74768_a("posy", this.pos.func_177956_o());
        compound.func_74768_a("posz", this.pos.func_177952_p());
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.func_74768_a((Object)((Object)type) + "_channel", this.channels.get((Object)type).intValue());
            compound.func_74757_a((Object)((Object)type) + "_canSend", this.canSend.get((Object)type).booleanValue());
            compound.func_74757_a((Object)((Object)type) + "_canReceive", this.canReceive(type));
        }
        return compound;
    }

    public boolean canSend(EnumChannelType type) {
        return this.canSend.get((Object)type);
    }

    public boolean canReceive(EnumChannelType type) {
        return this.canReceive.get((Object)type);
    }

    public int getChannelId(EnumChannelType type) {
        return this.channels.get((Object)type);
    }

    public Channel getChannel(EnumChannelType type) {
        if (this.channels.get((Object)type) < 0) {
            return null;
        }
        Channel channel = TesseractChannelManager.getInstance(this.isClientSide).getChannelById(type, this.channels.get((Object)type));
        if (channel == null && !this.isClientSide) {
            this.channels.put(type, -1);
            this.markDirty();
            if (this.canBeAccessed()) {
                this.getTesseract().channelChanged(type);
            }
        }
        return channel;
    }

    public void setChannel(EnumChannelType type, int channel) {
        Channel newChannel;
        if (channel == this.channels.get((Object)type)) {
            return;
        }
        Channel oldChannel = this.getChannel(type);
        this.channels.put(type, channel);
        if (oldChannel != null) {
            oldChannel.removeTesseract(this);
        }
        if ((newChannel = this.getChannel(type)) != null) {
            newChannel.addTesseract(this);
        }
        this.markDirty();
        if (this.canBeAccessed()) {
            this.getTesseract().channelChanged(type);
        }
    }

    public void update(TesseractBlockEntity entity) {
        for (EnumChannelType type : EnumChannelType.values()) {
            boolean canReceive;
            boolean changed = false;
            boolean canSend = entity.canSend(type);
            if (canSend != this.canSend.put(type, canSend)) {
                changed = true;
            }
            if ((canReceive = entity.canReceive(type)) != this.canReceive.put(type, canReceive)) {
                changed = true;
            }
            if (!changed) continue;
            Channel channel = this.getChannel(type);
            if (channel != null) {
                channel.updateTesseract(this);
            }
            this.markDirty();
        }
    }

    private void markDirty() {
        if (!this.isClientSide) {
            TesseractTracker.SERVER.markDirty(this);
        }
    }

    void delete() {
        for (EnumChannelType type : EnumChannelType.values()) {
            Channel channel = this.getChannel(type);
            if (channel == null) continue;
            channel.removeTesseract(this);
        }
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        int result = this.dimension;
        result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
        return result;
    }
}

