/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.tesseract.TesseractConfig;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.nio.file.Path;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TesseractSaveHandler {
    private static long lastSaveTime = 0L;

    public static void registerListeners() {
        MinecraftForge.EVENT_BUS.register(TesseractSaveHandler.class);
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player.func_130014_f_().field_72995_K) {
            return;
        }
        TesseractTracker.sendReferences(e.player);
        TesseractChannelManager.sendChannels(e.player);
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent e) {
        if (e.world.field_72995_K || e.phase != TickEvent.Phase.END || e.world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (System.currentTimeMillis() - lastSaveTime >= (long)(TesseractConfig.saveInterval.get() * 60000)) {
            Path saveDirectory = DimensionManager.getCurrentSaveRootDirectory().toPath();
            TesseractTracker.saveReferences(saveDirectory);
            TesseractChannelManager.saveChannels(saveDirectory);
            lastSaveTime = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public static void save(WorldEvent.Save e) {
        if (e.getWorld().field_72995_K || e.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        Path saveDirectory = DimensionManager.getCurrentSaveRootDirectory().toPath();
        TesseractTracker.saveReferences(saveDirectory);
        TesseractChannelManager.saveChannels(saveDirectory);
        lastSaveTime = System.currentTimeMillis();
    }

    @SubscribeEvent
    public static void load(WorldEvent.Load e) {
        if (e.getWorld().field_72995_K || e.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        Path saveDirectory = DimensionManager.getCurrentSaveRootDirectory().toPath();
        TesseractTracker.loadReferences(saveDirectory);
        TesseractChannelManager.loadChannels(saveDirectory);
        lastSaveTime = System.currentTimeMillis();
    }
}

