/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.premade.ButtonWidget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class TesseractButton
extends ButtonWidget {
    private static final ResourceLocation BUTTON_BACKGROUND = new ResourceLocation("tesseract", "textures/gui/default_buttons.png");
    private static final ResourceLocation RED_BUTTON_BACKGROUND = new ResourceLocation("tesseract", "textures/gui/red_buttons.png");
    private ITextComponent text;
    private ResourceLocation background = BUTTON_BACKGROUND;
    public boolean active = true;

    public TesseractButton(int x, int y, int width, int height, ITextComponent text, Runnable onPress) {
        super(x, y, width, height, text, onPress);
        this.text = text;
    }

    public void setRedBackground() {
        this.background = RED_BUTTON_BACKGROUND;
    }

    public void setText(ITextComponent text) {
        super.setText(text);
        this.text = text;
    }

    public void render(int mouseX, int mouseY) {
        this.drawButtonBackground(this.x, this.y, this.width, this.height, (float)(this.active ? (this.isFocused() ? 5 : 0) : 10) / 15.0f);
        float textX = (float)this.x + (float)this.width / 2.0f;
        float textY = (float)this.y + (float)this.height / 2.0f - 4.0f;
        ScreenUtils.drawCenteredStringWithShadow((ITextComponent)this.text, (float)textX, (float)textY, (int)(this.active ? -1 : Integer.MAX_VALUE));
    }

    private void drawButtonBackground(float x, float y, float width, float height, float yOffset) {
        ScreenUtils.bindTexture((ResourceLocation)this.background);
        ScreenUtils.drawTexture((float)x, (float)y, (float)2.0f, (float)2.0f, (float)0.0f, (float)yOffset, (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((float)(x + width - 2.0f), (float)y, (float)2.0f, (float)2.0f, (float)0.6f, (float)yOffset, (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((float)(x + width - 2.0f), (float)(y + height - 2.0f), (float)2.0f, (float)2.0f, (float)0.6f, (float)(yOffset + 0.2f), (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((float)x, (float)(y + height - 2.0f), (float)2.0f, (float)2.0f, (float)0.0f, (float)(yOffset + 0.2f), (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((float)(x + 2.0f), (float)y, (float)(width - 4.0f), (float)2.0f, (float)0.4f, (float)yOffset, (float)0.2f, (float)0.13333334f);
        ScreenUtils.drawTexture((float)(x + 2.0f), (float)(y + height - 2.0f), (float)(width - 4.0f), (float)2.0f, (float)0.4f, (float)(yOffset + 0.2f), (float)0.2f, (float)0.13333334f);
        ScreenUtils.drawTexture((float)x, (float)(y + 2.0f), (float)2.0f, (float)(height - 4.0f), (float)0.0f, (float)(yOffset + 0.13333334f), (float)0.4f, (float)0.06666667f);
        ScreenUtils.drawTexture((float)(x + width - 2.0f), (float)(y + 2.0f), (float)2.0f, (float)(height - 4.0f), (float)0.6f, (float)(yOffset + 0.13333334f), (float)0.4f, (float)0.06666667f);
        ScreenUtils.drawTexture((float)(x + 2.0f), (float)(y + 2.0f), (float)(width - 4.0f), (float)(height - 4.0f), (float)0.4f, (float)(yOffset + 0.13333334f), (float)0.2f, (float)0.06666667f);
    }
}

