/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BlockEntityBaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.TesseractClient;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.packets.PacketScreenRemoveChannel;
import com.supermartijn642.tesseract.screen.PlayerRenderer;
import com.supermartijn642.tesseract.screen.TesseractButton;
import com.supermartijn642.tesseract.screen.TesseractScreen;
import java.util.Locale;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TesseractRemoveChannelScreen
extends BlockEntityBaseWidget<TesseractBlockEntity> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tesseract", "textures/gui/add_screen_background.png");
    private final EnumChannelType type;
    private final int channelId;

    protected TesseractRemoveChannelScreen(World level, BlockPos pos, EnumChannelType type, int channelId) {
        super(0, 0, 144, 65, level, pos);
        this.type = type;
        this.channelId = channelId;
    }

    protected void addWidgets(TesseractBlockEntity entity) {
        TesseractButton removeButton = (TesseractButton)this.addWidget((Widget)new TesseractButton(8, 43, 61, 14, TextComponents.translation((String)"gui.tesseract.remove.remove").get(), () -> {
            Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenRemoveChannel(this.type, this.channelId));
            TesseractClient.openScreen(this.blockEntityPos);
        }));
        removeButton.setRedBackground();
        this.addWidget((Widget)new TesseractButton(75, 43, 61, 14, TextComponents.translation((String)"gui.tesseract.remove.cancel").get(), () -> TesseractClient.openScreen(this.blockEntityPos)));
        super.addWidgets((Object)entity);
    }

    protected void render(int mouseX, int mouseY, TesseractBlockEntity entity) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
        Channel channel = TesseractChannelManager.CLIENT.getChannelById(this.type, this.channelId);
        if (channel == null) {
            ClientUtils.closeScreen();
            return;
        }
        ScreenUtils.drawCenteredString((ITextComponent)TextComponents.translation((String)("gui.tesseract.remove.title." + this.type.name().toLowerCase(Locale.ROOT))).get(), (float)72.0f, (float)6.0f, (int)-1);
        int nameWidth = ClientUtils.getFontRenderer().func_78256_a(channel.name);
        int x = 72 - (12 + nameWidth + 3 + 9) / 2;
        PlayerRenderer.renderPlayerHead(channel.creator, x, 24, 9, 9);
        ScreenUtils.drawString((String)channel.name, (float)(x + 12), (float)25.0f, (int)-1);
        if (channel.creator.equals(ClientUtils.getPlayer().func_110124_au())) {
            GlStateManager.func_179141_d();
            ScreenUtils.bindTexture((ResourceLocation)(channel.isPrivate ? TesseractScreen.LOCK_ON : TesseractScreen.LOCK_OFF));
            ScreenUtils.drawTexture((float)(x + 12 + nameWidth + 3), (float)24.0f, (float)9.0f, (float)9.0f);
        }
        super.render(mouseX, mouseY, (Object)entity);
    }

    protected ITextComponent getNarrationMessage(TesseractBlockEntity object) {
        return TextComponents.translation((String)("gui.tesseract.remove.title." + this.type.name().toLowerCase(Locale.ROOT))).get();
    }
}

