/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.high;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IFuelMachine;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorFuelMachine;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.FuelMachineInfo;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.base.util.info.misc.IPumpTile;
import ic2.core.block.machine.high.container.ContainerPlasmafier;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileEntityPlasmafier
extends TileEntityElecMachine
implements ITickable,
IPumpTile,
IFuelMachine,
IProgressMachine,
IHasGui {
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit8)
    public int uuMatter = 0;
    @NetworkField(index=8, compression=NetworkField.BitLevel.Bit16)
    public int plasma;

    public TileEntityPlasmafier() {
        super(3, 2048);
        this.maxEnergy = 5120000;
        this.addGuiFields("uuMatter");
        this.addNetworkFields("plasma");
        this.addInfos(new FuelMachineInfo(this), new ProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, 0, 1);
        handler.registerDefaultSlotAccess(AccessRule.Export, 2);
        handler.registerDefaultSlotsForSide(RotationList.HORIZONTAL, 0);
        handler.registerDefaultSlotsForSide(RotationList.UP, 1);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 2);
        handler.registerInputFilter(CommonFilters.uuMatter, 0);
        handler.registerInputFilter(CommonFilters.EmptyCell, 1);
        handler.registerSlotType(SlotType.Fuel, 0);
        handler.registerSlotType(SlotType.Input, 1);
        handler.registerSlotType(SlotType.Output, 2);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorFuelMachine(this));
        manager.addComparatorMode(new ComparatorProgress(this));
    }

    @Override
    public float getFuel() {
        return this.uuMatter;
    }

    @Override
    public float getMaxFuel() {
        return 300.0f;
    }

    @Override
    public float getProgress() {
        return this.plasma;
    }

    @Override
    public float getMaxProgress() {
        return 10000.0f;
    }

    @Override
    public int getPumpCharge() {
        return this.plasma;
    }

    @Override
    public int getMaxPumpCharge() {
        return 10000;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.plasmafire;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerPlasmafier(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.uuMatter = nbt.func_74762_e("Matter");
        this.plasma = nbt.func_74762_e("Plasma");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Matter", this.uuMatter);
        nbt.func_74768_a("Plasma", this.plasma);
        return nbt;
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.refillMatter();
        }
        if (this.hasEnergy(10240) && this.uuMatter > 0 && this.plasma < 10000) {
            this.useEnergy(10240);
            ++this.plasma;
            --this.uuMatter;
            this.getNetwork().updateTileEntityField(this, "plasma");
            this.getNetwork().updateTileGuiField(this, "uuMatter");
        }
        if (this.plasma >= 1000 && this.field_145850_b.func_82737_E() % 50L == 0L) {
            this.fillCell();
        }
    }

    public void fillCell() {
        boolean empty = ((ItemStack)this.inventory.get(2)).func_190926_b();
        if (StackUtil.isStackEqual((ItemStack)this.inventory.get(1), Ic2Items.emptyCell) && (empty || StackUtil.isStackEqual((ItemStack)this.inventory.get(2), Ic2Items.plasmaCell) && ((ItemStack)this.inventory.get(2)).func_190916_E() < ((ItemStack)this.inventory.get(2)).func_77976_d())) {
            ((ItemStack)this.inventory.get(1)).func_190918_g(1);
            if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
                this.inventory.set(2, (Object)Ic2Items.plasmaCell.func_77946_l());
            } else {
                ((ItemStack)this.inventory.get(2)).func_190917_f(1);
            }
            this.plasma -= 1000;
            this.getNetwork().updateTileEntityField(this, "plasma");
        }
    }

    public void refillMatter() {
        if (this.uuMatter > 50 || ((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return;
        }
        if (StackUtil.isStackEqual((ItemStack)this.inventory.get(0), Ic2Items.uuMatter)) {
            this.uuMatter += 100;
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            this.getNetwork().updateTileGuiField(this, "uuMatter");
        }
    }
}

