/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.tile;

import ic2.api.classic.network.ICustomNetworkClientTileEventListener;
import ic2.api.classic.network.INetworkClientTileEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.trading.providers.IItemTradeProvider;
import ic2.api.classic.trading.trades.ISubTrade;
import ic2.api.classic.trading.trades.ITrade;
import ic2.api.classic.trading.trades.TradeType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.block.personal.base.TileEntityTradeOMatBase;
import ic2.core.block.personal.base.misc.IOwnerBlock;
import ic2.core.block.personal.base.misc.IPersonalBlock;
import ic2.core.block.personal.base.misc.IPersonalInventory;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.block.personal.base.trades.builder.ItemTradeFabricator;
import ic2.core.block.personal.base.trades.builder.TradeInventory;
import ic2.core.block.personal.container.ContainerTradeOMatClosed;
import ic2.core.block.personal.container.ContainerTradeOMatOpen;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.InputFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;

public class TileEntityTradeOMat
extends TileEntityTradeOMatBase
implements IOwnerBlock,
IItemTradeProvider,
IHasGui,
INetworkClientTileEventListener,
ICustomNetworkClientTileEventListener {
    @NetworkField(index=3)
    public UUID owner;
    @NetworkField(index=4)
    public int state = 0;
    @NetworkField(index=5, compression=NetworkField.BitLevel.Bit8)
    public int currentSubTrade = 0;
    public PersonalInventory display = new PersonalInventory(16);
    public ItemTradeFabricator fab = new ItemTradeFabricator();
    Map<UUID, IPersonalInventory> tradersMap = new HashMap<UUID, IPersonalInventory>();

    public TileEntityTradeOMat() {
        this.addNetworkFields("owner");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_186855_b("BlockOwner")) {
            this.owner = nbt.func_186857_a("BlockOwner");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.owner != null) {
            nbt.func_186854_a("BlockOwner", this.owner);
        }
        return nbt;
    }

    @Override
    public TradeType getType() {
        return TradeType.Item;
    }

    @Override
    public void setOwner(UUID user) {
        if (this.owner == null && user != null) {
            this.owner = user;
            this.getNetwork().updateTileEntityField(this, "owner");
        }
    }

    @Override
    public boolean canAccess(UUID user) {
        if (this.owner == null) {
            this.setOwner(user);
            return true;
        }
        return this.owner.equals(user);
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.tradeOMat;
    }

    @Override
    public List<ItemStack> getNearbyItemStack(IRecipeInput wanted, int amount, boolean simulate) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int used = 0;
        InputFilter filter = new InputFilter(wanted);
        for (Direction dir : Direction.directions) {
            IItemTransporter trans;
            Object obj;
            TileEntity other = dir.applyToTileEntity(this);
            if (other == null || (obj = this.getInventory(other)) == null || (trans = TransporterManager.manager.getTransporter(obj, true)) == null) continue;
            ItemStack got = trans.removeItem(filter, dir.getInverse().toFacing(), amount - used, !simulate);
            if (got.func_190926_b()) continue;
            this.combine(list, got);
            if ((used += got.func_190916_E()) >= amount) break;
        }
        return list;
    }

    public void combine(List<ItemStack> list, ItemStack toAdd) {
        for (int i = 0; i < list.size(); ++i) {
            int adding;
            ItemStack got = list.get(i);
            if (!StackUtil.isStackEqual(got, toAdd, false, false) || (adding = Math.min(got.func_77976_d() - got.func_190916_E(), toAdd.func_190916_E())) <= 0) continue;
            toAdd.func_190918_g(adding);
            got.func_190917_f(adding);
            if (toAdd.func_190926_b()) break;
        }
        if (toAdd.func_190916_E() > 0) {
            list.add(toAdd);
        }
    }

    public Object getInventory(TileEntity tile) {
        IPersonalBlock block;
        if (tile instanceof IPersonalBlock && (block = (IPersonalBlock)tile).canAccess(this.getOwner())) {
            return block.getInventory(this.getOwner());
        }
        return null;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        if (this.isSimulating()) {
            this.getSyncer().createDataForPlayer(player);
        }
        if (this.canAccess(player.func_110124_au()) && !IC2.keyboard.isSideinventoryKeyDown(player)) {
            return new ContainerTradeOMatOpen(player.field_71071_by, this);
        }
        return new ContainerTradeOMatClosed(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
        this.getSyncer().clearDataForPlayer(player);
        this.tradersMap.remove(player.func_110124_au());
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    public IPersonalInventory getInvForPlayer(EntityPlayer player) {
        return this.getInvForPlayer(player.func_110124_au());
    }

    public IPersonalInventory getInvForPlayer(UUID player) {
        if (this.owner.equals(player)) {
            return this.display;
        }
        IPersonalInventory inv = this.tradersMap.get(player);
        if (inv == null) {
            inv = new PersonalInventory(16);
            this.tradersMap.put(player, inv);
        }
        return inv;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event, int value) {
        if (event == 0) {
            this.state = value;
            this.getNetwork().updateTileGuiField(this, "state");
            if (player.field_71070_bA instanceof ContainerTradeOMatOpen) {
                ContainerTradeOMatOpen mat = (ContainerTradeOMatOpen)player.field_71070_bA;
                if (this.state == 0) {
                    mat.lock();
                    this.fab.clear();
                    this.currentSubTrade = 0;
                    this.getNetwork().updateTileGuiField(this, "currentSubTrade");
                    this.display.clear();
                    this.getSyncer().markDirty(player);
                } else if (this.state == 1) {
                    mat.unlockAndUpdate();
                } else if (this.state == 2) {
                    mat.lock();
                    this.display.clear();
                }
            }
        } else if (event == 2) {
            this.removeSubTrade(player, value);
        } else if (event == 4) {
            if (value > 0) {
                this.fab.setItems(this.display, this.currentSubTrade);
                if (this.currentSubTrade < 3) {
                    ++this.currentSubTrade;
                    this.getNetwork().updateTileGuiField(this, "currentSubTrade");
                }
                if (!this.fab.hasKey(this.currentSubTrade)) {
                    this.fab.setItems(this.currentSubTrade, this.display, value == 2 || value == 4, value == 3 || value == 4);
                }
                this.fab.pushToSlots(this.currentSubTrade, this.display);
            } else if (value < 0) {
                this.fab.setItems(this.display, this.currentSubTrade);
                if (this.currentSubTrade > 0) {
                    --this.currentSubTrade;
                    this.getNetwork().updateTileGuiField(this, "currentSubTrade");
                }
                this.fab.pushToSlots(this.currentSubTrade, this.display);
            }
        } else if (event == 5) {
            ItemTradeFabricator.ItemTradeRules rules = this.fab.getRules(this.currentSubTrade);
            if (value == 0) {
                rules.creative = !rules.creative;
            } else if (value == 1) {
                boolean bl = rules.money = !rules.money;
                if (player.field_71070_bA instanceof ContainerTradeOMatOpen) {
                    ContainerTradeOMatOpen mat = (ContainerTradeOMatOpen)player.field_71070_bA;
                    if (rules.money) {
                        mat.lockInput();
                        this.display.clear(0, 8);
                        this.fab.removeInput(this.currentSubTrade);
                        mat.func_75142_b();
                    } else {
                        mat.unlockInput();
                    }
                }
            } else if (value == 4) {
                rules.waitingAfterBuy = !rules.waitingAfterBuy;
            } else if (value == 5) {
                rules.tradeLimit = !rules.tradeLimit;
            } else if (value == 6) {
                rules.ignoreNBT = !rules.ignoreNBT;
            } else if (value == 7) {
                rules.useOreDictionary = !rules.useOreDictionary;
            }
        } else if (event == 6) {
            this.fab.getRules((int)this.currentSubTrade).moneyNeeded = value;
        } else if (event == 7) {
            this.fab.getRules((int)this.currentSubTrade).limitPerPlayer = value;
        } else if (event == 8) {
            this.fab.getRules((int)this.currentSubTrade).waitingTime = value;
        } else if (event == 10) {
            this.fab.setItems(this.display, this.currentSubTrade);
            this.addTrade(this.fab.createTrade(this.getOwner()));
            this.fab.clear();
            this.display.clear();
            this.state = 0;
            this.currentSubTrade = 0;
            this.getNetwork().updateTileGuiField(this, "currentSubTrade");
            this.getNetwork().updateTileGuiField(this, "state");
            if (player.field_71070_bA instanceof ContainerTradeOMatOpen) {
                ((ContainerTradeOMatOpen)player.field_71070_bA).lock();
            }
        }
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void onClientNetworkEvent(EntityPlayer player, INetworkFieldData data) {
        if (player == null) {
            return;
        }
        if (data instanceof PayloadFieldPacket) {
            PayloadFieldPacket payload = (PayloadFieldPacket)data;
            if (this.isOwner(player) && payload.getSize(0) == 1) {
                this.addTrade(IC2.manager.getCustomTrades(this.getType()).get(payload.getString(0)));
            }
            if (payload.getSize(1) == 1) {
                if (player.field_71070_bA instanceof ContainerTradeOMatClosed) {
                    ISubTrade sub;
                    ContainerTradeOMatClosed cont = (ContainerTradeOMatClosed)player.field_71070_bA;
                    UUID playerID = player.func_110124_au();
                    ITrade trade = this.getSyncer().getServerTrade(player);
                    cont.stockCount = trade != null && trade.canAccessTrade(playerID) ? ((sub = trade.getSubTradeFromSlot(payload.getNumber(0), playerID, true)) != null && sub.canPerformTrade(playerID) ? trade.getStockCount(sub, this, playerID) : 0) : 0;
                    cont.func_75142_b();
                }
            } else if (payload.getSize(1) == 2) {
                UUID playerID = player.func_110124_au();
                ITrade trade = this.getSyncer().getServerTrade(player);
                if (trade != null && trade.canAccessTrade(playerID)) {
                    ISubTrade sub = trade.getSubTradeFromSlot(payload.getNumber(0), playerID, true);
                    if (sub != null && sub.canPerformTrade(playerID)) {
                        IPersonalInventory inv = this.getInvForPlayer(playerID);
                        ActionResult result = trade.trade(playerID, this, sub, new TradeInventory(inv), payload.getNumber(1));
                        if (result == null || result.func_188397_a() == EnumActionResult.FAIL) {
                            IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                            return;
                        }
                        if (result.func_188397_a() == EnumActionResult.PASS) {
                            IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                            return;
                        }
                        List<ItemStack> list = this.unsplit((List)result.func_188398_b());
                        PersonalInventory fake = new PersonalInventory(8);
                        fake.copy(inv, 8, 16);
                        IItemTransporter trans = TransporterManager.manager.getTransporter(fake, true);
                        for (int i = 0; i < list.size(); ++i) {
                            ItemStack use = list.get(i).func_77946_l();
                            if (use.func_190926_b()) continue;
                            ItemStack added = trans.addItem(use, EnumFacing.DOWN, true);
                            if (!added.func_190926_b()) {
                                use.func_190918_g(added.func_190916_E());
                                if (use.func_190916_E() <= 0 || player.field_71071_by.func_70441_a(use)) continue;
                                player.func_71019_a(use, true);
                                continue;
                            }
                            if (player.field_71071_by.func_70441_a(use)) continue;
                            player.func_71019_a(use, true);
                        }
                        fake.inject(inv, 8, 16);
                    } else {
                        IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                    }
                } else {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                }
            }
        }
    }

    public List<ItemStack> unsplit(List<ItemStack> list) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : list) {
            int max = stack.func_77976_d();
            if (stack.func_190916_E() > max) {
                while (stack.func_190916_E() > max) {
                    result.add(stack.func_77979_a(max));
                }
                if (stack.func_190916_E() <= 0) continue;
                result.add(stack);
                continue;
            }
            result.add(stack);
        }
        return result;
    }

    public boolean isOwner(EntityPlayer player) {
        return this.owner.equals(player.func_110124_au());
    }
}

