/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IElectricTool;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.textures.obj.IAdvancedTexturedItem;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricToolMowing
extends ItemIC2
implements IDamagelessElectricItem,
IElectricTool,
IAdvancedTexturedItem,
ICustomItemCameraTransform {
    ModelResourceLocation[] textures = new ModelResourceLocation[2];

    public ItemElectricToolMowing() {
        this.func_77625_d(1);
        this.setTranslationKey(Ic2ItemLang.mowingTool);
        this.setNoRepair();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.platform.isSimulating()) {
            int meta = stack.func_77960_j();
            super.setDamage(stack, meta == 0 ? 1 : 0);
            IC2.platform.messagePlayer(playerIn, meta == 0 ? Ic2InfoLang.enabledMowing : Ic2InfoLang.disabledMowing);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation createResourceLocationForStack(ItemStack stack) {
        int meta = stack.func_77960_j();
        String name = stack.func_77977_a();
        ResourceLocation resource = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b());
        this.textures[meta] = new ModelResourceLocation(resource.func_110624_b() + name.substring(name.indexOf(".") + 1) + meta, "inventory");
        return this.textures[meta];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getResourceLocationForStack(ItemStack stack) {
        return this.textures[stack.func_77960_j()];
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 10000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 100.0;
    }

    @Override
    public int getTextureEntry(int meta) {
        return 46 + meta;
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.DIGGER;
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return false;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185296_A;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this, 1, 0);
        ItemStack full = new ItemStack((Item)this, 1, 0);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add((Object)empty);
        items.add((Object)full);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ItemStack type;
        if (stack.func_77960_j() == 0 || !(entityIn instanceof EntityPlayer) || worldIn.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityIn;
        if (!(isSelected || (type = player.func_184592_cb()) != null && type.func_77973_b() == this)) {
            return;
        }
        if (!ElectricItem.manager.use(stack, 1.0, (EntityLivingBase)player)) {
            super.setDamage(stack, 0);
            return;
        }
        if (worldIn.func_82737_E() % 5L == 0L) {
            RayTraceResult result = this.func_77621_a(worldIn, player, false);
            if (!(result != null && result.field_72313_a != RayTraceResult.Type.MISS || (result = ItemElectricToolMowing.rayTraceEntities(worldIn, (EntityLivingBase)player, false, 5.0)) != null && result.field_72313_a != RayTraceResult.Type.MISS)) {
                return;
            }
            if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                result.field_72308_g.func_70097_a(DamageSource.field_76377_j, 1.0f);
            } else if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos pos = result.func_178782_a();
                boolean silk = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
                int fortune = silk ? 0 : EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
                LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            BlockPos target = pos.func_177982_a(x, y, z);
                            IBlockState state = worldIn.func_180495_p(target);
                            list.addAll(this.getDrops(stack, state, worldIn, target.func_185334_h(), silk, fortune));
                        }
                    }
                }
                this.addItemsToPlayer(list, player.field_71071_by);
            }
        }
    }

    public List<ItemStack> getDrops(ItemStack stack, IBlockState state, World world, BlockPos pos, boolean silk, int fortune) {
        IShearable shear;
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        Block block = state.func_177230_c();
        if (block instanceof IShearable && (shear = (IShearable)block).isShearable(stack, (IBlockAccess)world, pos)) {
            if (silk) {
                List drops = shear.onSheared(stack, (IBlockAccess)world, pos, fortune);
                if (drops != null && drops.size() > 0) {
                    list.addAll(drops);
                }
            } else {
                List drops = block.getDrops((IBlockAccess)world, pos, state, fortune);
                if (drops != null && drops.size() > 0) {
                    list.addAll(drops);
                }
            }
            world.func_175698_g(pos);
            return list;
        }
        if (!(block instanceof BlockCrops)) {
            if (block instanceof BlockDoublePlant) {
                BlockDoublePlant.EnumBlockHalf half = (BlockDoublePlant.EnumBlockHalf)state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b);
                if (half == BlockDoublePlant.EnumBlockHalf.UPPER && !((block = (state = world.func_180495_p(pos = pos.func_177977_b())).func_177230_c()) instanceof BlockDoublePlant)) {
                    return list;
                }
                List drops = block.getDrops((IBlockAccess)world, pos, state, fortune);
                if (drops != null && drops.size() > 0) {
                    list.addAll(drops);
                }
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                world.func_175698_g(pos.func_177984_a());
            } else if (block instanceof BlockBush) {
                List drops = block.getDrops((IBlockAccess)world, pos, state, fortune);
                if (drops != null && drops.size() > 0) {
                    list.addAll(drops);
                }
                world.func_175698_g(pos);
            }
        }
        return list;
    }

    public void addItemsToPlayer(List<ItemStack> list, InventoryPlayer player) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ItemStack stack : list) {
            if (player.func_70441_a(stack)) continue;
            player.field_70458_d.func_71019_a(stack, true);
        }
    }
}

