/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IFluidScannerItem;
import ic2.api.classic.item.IScannerItem;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.item.base.ItemIC2;
import ic2.core.item.tool.electric.scanners.AdjustableValueDensityScanner;
import ic2.core.item.tool.electric.scanners.BaseScanner;
import ic2.core.item.tool.electric.scanners.FilteredFluidScanner;
import ic2.core.item.tool.electric.scanners.FilteredScanner;
import ic2.core.item.tool.electric.scanners.FluidScanner;
import ic2.core.item.tool.electric.scanners.IScanner;
import ic2.core.item.tool.electric.scanners.QuarryScanner;
import ic2.core.item.tool.electric.scanners.ValueDensityScanner;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.ToolTipType;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class ItemElectricToolScanner
extends ItemIC2
implements IScannerItem,
IDamagelessElectricItem,
IBootable,
IFluidScannerItem,
IHandHeldInventory,
ICustomItemCameraTransform {
    public static final DecimalFormat DECIMALFORMAT = new DecimalFormat("#.####");
    public static IScanner[] types = new IScanner[0];
    public static Map<Integer, List<IBlockState>> cache = new HashMap<Integer, List<IBlockState>>();

    public ItemElectricToolScanner() {
        this.func_77627_a(true);
        this.setTranslationKey(Ic2ItemLang.scannerBase);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Override
    public void onLoad() {
        types = new IScanner[14];
        ItemElectricToolScanner.types[0] = new BaseScanner(2, 50, false, 1, Ic2ItemLang.scannerOD);
        ItemElectricToolScanner.types[1] = new BaseScanner(4, 250, false, 2, Ic2ItemLang.scannerOV);
        ItemElectricToolScanner.types[2] = new BaseScanner(7, 150, false, 2, Ic2ItemLang.scannerBigOD);
        ItemElectricToolScanner.types[3] = new BaseScanner(8, 750, false, 2, Ic2ItemLang.scannerBigOV);
        ItemElectricToolScanner.types[4] = new BaseScanner(9, 300, false, 2, Ic2ItemLang.scannerLargeOD);
        ItemElectricToolScanner.types[5] = new BaseScanner(10, 1750, false, 2, Ic2ItemLang.scannerLargeOV);
        ItemElectricToolScanner.types[6] = new ValueDensityScanner(0, 600, Ic2ItemLang.scannerLow);
        ItemElectricToolScanner.types[7] = new ValueDensityScanner(1, 800, Ic2ItemLang.scannerMed);
        ItemElectricToolScanner.types[8] = new ValueDensityScanner(2, 1000, Ic2ItemLang.scannerHigh);
        ItemElectricToolScanner.types[9] = new AdjustableValueDensityScanner();
        ItemElectricToolScanner.types[10] = new QuarryScanner();
        ItemElectricToolScanner.types[11] = new FluidScanner();
        ItemElectricToolScanner.types[12] = new FilteredFluidScanner();
        ItemElectricToolScanner.types[13] = new FilteredScanner();
        Ic2Items.scanner = new ItemStack((Item)this, 1, 0);
        Ic2Items.advScanner = new ItemStack((Item)this, 1, 1);
        Ic2Items.rangedODScanner = new ItemStack((Item)this, 1, 2);
        Ic2Items.rangedOVScanner = new ItemStack((Item)this, 1, 3);
        Ic2Items.bigRangedODScanner = new ItemStack((Item)this, 1, 4);
        Ic2Items.bigRangedOVScanner = new ItemStack((Item)this, 1, 5);
        Ic2Items.lowOVDScanner = new ItemStack((Item)this, 1, 6);
        Ic2Items.medOVDScanner = new ItemStack((Item)this, 1, 7);
        Ic2Items.bigOVDScanner = new ItemStack((Item)this, 1, 8);
        Ic2Items.settedOVDScanner = new ItemStack((Item)this, 1, 9);
        Ic2Items.quarryScanner = new ItemStack((Item)this, 1, 10);
        Ic2Items.fluidScanner = new ItemStack((Item)this, 1, 11);
        Ic2Items.filteredFluidScanner = new ItemStack((Item)this, 1, 12);
        Ic2Items.filteredScanner = new ItemStack((Item)this, 1, 13);
    }

    public static IScanner getType(ItemStack stack) {
        return ItemElectricToolScanner.getType(stack.func_77960_j());
    }

    public static IScanner getType(int meta) {
        if (meta < 0 || meta > types.length) {
            return types[0];
        }
        return types[meta];
    }

    @Override
    public boolean isFluidScanner(ItemStack stack) {
        return ItemElectricToolScanner.getType(stack).isFluidScanner(stack);
    }

    @Override
    public int startScanningFluidLayer(ItemStack stack) {
        IScanner type = ItemElectricToolScanner.getType(stack);
        return ElectricItem.manager.use(stack, type.getCost(stack), null) ? type.getRadius(stack) : 0;
    }

    @Override
    public boolean isValidFluid(ItemStack stack, FluidStack fluid) {
        return ItemElectricToolScanner.getType(stack).isFluidValid(stack, fluid);
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        IScanner type = ItemElectricToolScanner.getType(stack);
        ArrayList<String> postList = new ArrayList<String>();
        List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
        LinkedList<String> toAdd = new LinkedList<String>();
        sortedTooltip.put(ToolTipType.Ctrl, toAdd);
        if (type.hasCustomInfo(stack) && type.addCustomInfo(stack, player, tooltip, postList, sortedTooltip)) {
            if (toAdd.size() > 0) {
                ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
                ctrlTip.addAll(toAdd);
            }
            sortedTooltip.put(ToolTipType.Ctrl, ctrlTip);
            return;
        }
        sortedTooltip.put(ToolTipType.Ctrl, ctrlTip);
        if (type.hasAOE(stack)) {
            toAdd.add(TextFormatting.UNDERLINE + Ic2InfoLang.ScannerAOE.getLocalized());
        }
        if (type instanceof IHandHeldInventory) {
            toAdd.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(3), Ic2Lang.openTheItemInventory));
        }
        if (toAdd.size() > 0) {
            ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
            ctrlTip.addAll(toAdd);
        }
        tooltip.add(Ic2InfoLang.scannerRange.getLocalizedFormatted(type.getRadius(stack)));
        tooltip.addAll(postList);
        if (type.showTargets(stack)) {
            List<String> altTip = sortedTooltip.get((Object)ToolTipType.Alt);
            LinkedHashSet<String> targets = new LinkedHashSet<String>();
            Set<IBlockState> states = type.getTargets(stack);
            for (IBlockState state : states) {
                Item item = Item.func_150898_a((Block)state.func_177230_c());
                if (item == Items.field_190931_a) continue;
                try {
                    targets.add(new ItemStack(item, 1, state.func_177230_c().func_176201_c(state)).func_82833_r());
                }
                catch (Exception exception) {}
            }
            Set<Fluid> fluids = type.getFluidTargets(stack);
            for (Fluid fluid : fluids) {
                targets.add(new FluidStack(fluid, 1000).getLocalizedName());
            }
            altTip.add(Ic2InfoLang.scannerTargets.getLocalized());
            if (targets.size() > 0) {
                altTip.addAll(targets);
            } else {
                altTip.add(Ic2InfoLang.scannerNoTargets.getLocalized());
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            ItemStack empty = new ItemStack((Item)this, 1, i);
            ItemStack full = new ItemStack((Item)this, 1, i);
            ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
            ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
            items.add((Object)empty);
            items.add((Object)full);
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        return ItemElectricToolScanner.getType(stack).getName(stack);
    }

    @Override
    public int startLayerScan(ItemStack stack) {
        IScanner type = ItemElectricToolScanner.getType(stack);
        return ElectricItem.manager.use(stack, type.getCost(stack), null) ? type.getRadius(stack) : 0;
    }

    @Override
    public boolean isAdvancedScanner(ItemStack stack) {
        return ItemElectricToolScanner.getType(stack).isAdv(stack);
    }

    @Override
    public boolean isValuableOre(ItemStack par1, IBlockState state) {
        return this.getOreValue(par1, state) > 0;
    }

    @Override
    public boolean isValuableOre(ItemStack stack, IBlockState state, World world, BlockPos pos) {
        return ItemElectricToolScanner.getType(stack).getOreValue(stack, state, world, pos) > 0;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state) {
        return ItemElectricToolScanner.getType(stack).getOreValue(stack, state);
    }

    @Override
    public float getOreValueOfArea(ItemStack stack, World world, BlockPos pos) {
        IScanner type = ItemElectricToolScanner.getType(stack);
        boolean adv = type.isAdv(stack);
        boolean isFluid = type.isFluidScanner(stack);
        AabbUtil.BoundingBox box = new AabbUtil.BoundingBox(pos, type.getRadius(stack));
        box.set(EnumFacing.DOWN, 0);
        int points = 0;
        for (BlockPos target : box) {
            IBlockState state = world.func_180495_p(target);
            if (isFluid) {
                Material material;
                Block block = state.func_177230_c();
                if (block instanceof IFluidBlock) {
                    if (!((IFluidBlock)block).canDrain(world, target) || !type.isFluidValid(stack, ((IFluidBlock)block).drain(world, target, false))) continue;
                    ++points;
                    continue;
                }
                if (!(block instanceof BlockStaticLiquid) || block.func_176201_c(state) != 0 || (material = state.func_185904_a()) != Material.field_151587_i && material != Material.field_151586_h) continue;
                ++points;
                continue;
            }
            points += adv ? type.getOreValue(stack, state, world, target) : type.getOreValue(stack, state);
        }
        return (float)points / (float)box.getBlocksInArea() * 1000.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.platform.isRendering()) {
            IC2.audioManager.playOnce(playerIn, PositionSpec.Hand, Ic2Sounds.scannerUse, true, IC2.audioManager.defaultVolume);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        IScanner type = ItemElectricToolScanner.getType(stack);
        if (type.hasRightClick(stack) && type.onRightClick(stack, playerIn, handIn, worldIn)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (type.hasAOE(stack) && ElectricItem.manager.use(stack, type.getCost(stack), (EntityLivingBase)playerIn)) {
            float value = this.getOreValueOfArea(stack, worldIn, playerIn.func_180425_c());
            int printValue = (int)value;
            IC2.platform.messagePlayer(playerIn, type.isValue(stack) ? Ic2InfoLang.scannerOreValue : Ic2InfoLang.scannerOreDensity, printValue == 0 && value > 0.0f ? ItemStack.field_111284_a.format(value) : Integer.valueOf(printValue));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 112 + meta;
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 10000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return ItemElectricToolScanner.getType(stack).getTier(stack);
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return ItemElectricToolScanner.getType(stack).getTier(stack) * 50;
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        IScanner scanner = ItemElectricToolScanner.getType(stack);
        if (scanner instanceof IHandHeldInventory) {
            return ((IHandHeldInventory)((Object)scanner)).getInventory(player, hand, stack);
        }
        return null;
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }
}

