/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.gui.tile;

import asmodeuscore.core.utils.Utils;
import galaxyspace.GalaxySpace;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.prefab.inventory.SlotUpgrades;
import galaxyspace.core.util.GSConstants;
import galaxyspace.core.util.GSUtils;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.inventory.SlotSpecific;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiTileBase
extends GuiContainerGC {
    private GuiElementInfoRegion electricInfoRegion = new GuiElementInfoRegion(0, 0, 56, 9, null, 0, 0, (GuiContainerGC)this);
    private GuiElementInfoRegion processInfoRegion = new GuiElementInfoRegion(0, 0, 52, 25, null, 0, 0, (GuiContainerGC)this);
    private GuiElementInfoRegion batteryInfoRegion = new GuiElementInfoRegion(0, 0, 18, 18, null, 0, 0, (GuiContainerGC)this);
    private GuiElementInfoRegion moduleInfoRegion = new GuiElementInfoRegion(0, 0, 18, 84, null, 0, 0, (GuiContainerGC)this);
    private GuiElementInfoRegion fluidTankRegion = new GuiElementInfoRegion(0, 0, 16, 38, null, 0, 0, (GuiContainerGC)this);
    private final int header_type;
    private final int split_type;
    protected int header;
    protected int moduleInfoX;
    protected int moduleInfoY;
    protected ItemStack[] moduleList;

    public GuiTileBase(Container container, int header, int split) {
        super(container);
        this.field_146999_f = this.isModuleSupport() ? 196 : 176;
        this.field_147000_g = 166;
        this.header_type = header;
        this.split_type = split;
        this.header = -1;
        this.moduleInfoX = 0;
        this.moduleInfoY = 0;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.electricInfoRegion.tooltipStrings = new ArrayList();
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        this.processInfoRegion.tooltipStrings = new ArrayList();
        this.processInfoRegion.parentWidth = this.field_146294_l;
        this.processInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.processInfoRegion);
        this.fluidTankRegion.tooltipStrings = new ArrayList();
        this.fluidTankRegion.parentWidth = this.field_146294_l;
        this.fluidTankRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.fluidTankRegion);
        ArrayList<String> desc = new ArrayList<String>();
        if (this.getBatterySlot() != null) {
            desc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.0"));
            desc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.1"));
            this.batteryInfoRegion.tooltipStrings = desc;
            this.batteryInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + this.getBatterySlot().field_75223_e;
            this.batteryInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + this.getBatterySlot().field_75221_f;
            this.batteryInfoRegion.parentWidth = this.field_146294_l;
            this.batteryInfoRegion.parentHeight = this.field_146295_m;
            this.infoRegions.add(this.batteryInfoRegion);
        }
        if (this.isModuleSupport() && this.moduleList != null) {
            desc = new ArrayList();
            desc.add(TextFormatting.GREEN + GCCoreUtil.translate((String)"gui.available_modules.desc"));
            desc.add("");
            for (ItemStack module : this.moduleList) {
                desc.add("- " + module.func_82833_r());
            }
            this.moduleInfoRegion.tooltipStrings = desc;
            this.moduleInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + this.moduleInfoX;
            this.moduleInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + this.moduleInfoY;
            this.moduleInfoRegion.parentWidth = this.field_146294_l;
            this.moduleInfoRegion.parentHeight = this.field_146295_m;
            this.infoRegions.add(this.moduleInfoRegion);
        }
    }

    protected void func_146979_b(int par1, int par2) {
        if (this.getStyle() == Style.MODERN) {
            int xOffset = 0;
            int yOffset = 0;
            int xInvOffset = 0;
            int yInvOffset = 0;
            if (this.header == 0) {
                xOffset = -15;
                yOffset = -3;
            }
            if (this.header == 4) {
                xOffset = 30;
                yOffset = -3;
            }
            if (this.header_type == 3) {
                xInvOffset = -8;
                yInvOffset = 3;
            }
            if (this.header_type == 4) {
                xInvOffset = -5;
                yInvOffset = 2;
            }
            this.field_146289_q.func_78276_b(TextFormatting.WHITE + this.getName(), 88 - this.field_146289_q.func_78256_a(this.getName()) / 2 + xOffset, 5 + yOffset, 0x404040);
            this.field_146289_q.func_78276_b(TextFormatting.WHITE + GCCoreUtil.translate((String)"container.inventory"), 15 + xInvOffset, this.field_147000_g - 72 - 13 + yInvOffset, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(TextFormatting.DARK_GRAY + this.getName(), 88 - this.field_146289_q.func_78256_a(this.getName()) / 2, 5, 0x404040);
            this.field_146289_q.func_78276_b(TextFormatting.DARK_GRAY + GCCoreUtil.translate((String)"container.inventory"), 8, this.field_147000_g - 72 - 8, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getTexture());
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        int xSize = 176;
        if (this.header == -1 || this.getStyle() == Style.CLASSIC) {
            this.func_73729_b(containerWidth, containerHeight, 0, 0, xSize, 12);
        } else {
            this.func_73729_b(containerWidth, containerHeight, 0, 149 + 13 * this.header, xSize, 12);
        }
        Utils.drawTexturedModalRect((float)containerWidth, (float)(containerHeight + 12), (float)xSize, (float)(this.field_147000_g - 108), (float)0.0f, (float)12.0f, (float)xSize, (float)12.0f, (boolean)false, (boolean)false, (float)256.0f, (float)256.0f);
        this.renderInventoryPanel(containerWidth, containerHeight, this.header_type, this.split_type);
        this.func_73729_b(containerWidth, containerHeight + this.field_147000_g, 0, 48, xSize, 13);
        if (this.isModuleSupport()) {
            this.renderUpgradesPanel(containerWidth, containerHeight);
        }
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            int x = this.field_147002_h.func_75139_a((int)i).field_75223_e - 1;
            int y = this.field_147002_h.func_75139_a((int)i).field_75221_f - 1;
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.field_147002_h.func_75139_a(i) instanceof SlotUpgrades) {
                this.func_73729_b(containerWidth + x, containerHeight + y, 84, 62, 18, 18);
            } else if (this.field_147002_h.func_75139_a(i) instanceof SlotSpecific) {
                SlotSpecific slot = (SlotSpecific)this.field_147002_h.func_75139_a(i);
                if (slot.func_75214_a(new ItemStack(GCItems.battery))) {
                    this.func_73729_b(containerWidth + x, containerHeight + y, 21, 62, 18, 18);
                } else if (slot.func_75214_a(new ItemStack(Items.field_151100_aR, 1, 0)) && slot.func_75211_c().func_77952_i() == 15) {
                    this.func_73729_b(containerWidth + x, containerHeight + y, 105, 62, 18, 18);
                } else {
                    this.func_73729_b(containerWidth + x, containerHeight + y, 0, 62, 18, 18);
                }
            } else {
                this.func_73729_b(containerWidth + x, containerHeight + y, 0, 62, 18, 18);
            }
            GL11.glPopMatrix();
        }
        if (GalaxySpace.debug) {
            GSUtils.renderDebugGui((GuiContainer)this, containerWidth, containerHeight);
        }
        this.field_146297_k.field_71446_o.func_110577_a(this.getTexture());
    }

    private void renderInventoryPanel(int x, int y, int header_type, int split_type) {
        int xSize = 176;
        if (this.getStyle() == Style.CLASSIC) {
            Utils.drawTexturedModalRect((float)x, (float)(y + this.field_147000_g - 108), (float)xSize, (float)115.0f, (float)0.0f, (float)12.0f, (float)xSize, (float)12.0f, (boolean)false, (boolean)false, (float)256.0f, (float)256.0f);
        } else if (header_type == -1) {
            Utils.drawTexturedModalRect((float)x, (float)(y + this.field_147000_g / 2 + 1), (float)xSize, (float)(this.field_147000_g / 2), (float)0.0f, (float)12.0f, (float)xSize, (float)12.0f, (boolean)false, (boolean)false, (float)256.0f, (float)256.0f);
        } else {
            this.func_73729_b(x, y + this.field_147000_g - 108 + 11, 0, 244 - 13 * split_type, xSize, 13);
            this.func_73729_b(x, y + this.field_147000_g - 108 + 23, 0, 149 + 13 * header_type, xSize, 12);
            Utils.drawTexturedModalRect((float)x, (float)(y + this.field_147000_g - 108 + 35), (float)xSize, (float)80.0f, (float)0.0f, (float)12.0f, (float)xSize, (float)12.0f, (boolean)false, (boolean)false, (float)256.0f, (float)256.0f);
        }
    }

    private void renderUpgradesPanel(int x, int y) {
        int xSize = 176;
        this.func_73729_b(x + xSize - 1, y + 12, 0, 120, 26, 6);
        Utils.drawTexturedModalRect((float)(x + xSize - 1), (float)(y + 18), (float)26.0f, (float)80.0f, (float)0.0f, (float)126.0f, (float)26.0f, (float)12.0f, (boolean)false, (boolean)false, (float)256.0f, (float)256.0f);
        this.func_73729_b(x + xSize - 1, y + 96, 0, 141, 26, 7);
    }

    protected void renderProgressArray(int x, int y, int size, int ticks, int max) {
        this.renderProgressArray(x, y, size, ticks, max, false, false);
    }

    protected void renderProgressArray(int x, int y, int size, int ticks, int max, boolean invertX, boolean invertY) {
        Utils.drawTexturedModalRect((float)x, (float)y, (float)size, (float)15.0f, (float)181.0f, (float)109.0f, (float)8.0f, (float)15.0f, (boolean)invertX, (boolean)invertY, (float)256.0f, (float)256.0f);
        if (invertX) {
            Utils.drawTexturedModalRect((float)(x - 8), (float)y, (float)8.0f, (float)15.0f, (float)209.0f, (float)109.0f, (float)8.0f, (float)15.0f, (boolean)invertX, (boolean)invertY, (float)256.0f, (float)256.0f);
        } else {
            Utils.drawTexturedModalRect((float)(x + size), (float)y, (float)8.0f, (float)15.0f, (float)209.0f, (float)109.0f, (float)8.0f, (float)15.0f, (boolean)invertX, (boolean)invertY, (float)256.0f, (float)256.0f);
        }
        int scale = 0;
        int percent = 0;
        ArrayList<String> processDesc = new ArrayList<String>();
        processDesc.clear();
        if (ticks > 0) {
            scale = (int)((double)ticks / (double)max * (double)(size + 8));
            Utils.drawTexturedModalRect((float)x, (float)y, (float)scale, (float)15.0f, (float)181.0f, (float)125.0f, (float)6.0f, (float)15.0f, (boolean)false, (boolean)invertY, (float)256.0f, (float)256.0f);
            if (scale > size - 8) {
                if (invertX) {
                    Utils.drawTexturedModalRect((float)(x - 8), (float)y, (float)8.0f, (float)16.0f, (float)209.0f, (float)125.0f, (float)(scale - size), (float)16.0f, (boolean)invertX, (boolean)invertY, (float)256.0f, (float)256.0f);
                } else {
                    this.func_73729_b(x + size, y, 209, 125, scale - size, 16);
                }
            }
            percent = (int)((double)ticks / (double)max * 100.0);
            processDesc.add(GCCoreUtil.translate((String)"gui.electric_compressor.desc.0") + ": " + percent + "%");
            this.processInfoRegion.tooltipStrings = processDesc;
            this.processInfoRegion.xPosition = x;
            this.processInfoRegion.yPosition = y;
        }
    }

    protected void renderEnergyBar(int x, int y, int scale, float energy, float maxEnergy) {
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)energy, (float)maxEnergy, electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = x + 10;
        this.electricInfoRegion.yPosition = y;
        this.func_73729_b(x, y, 180, 56, 9, 8);
        this.func_73729_b(x + 11, y, 180, 47, 56, 9);
        if (energy > 0.0f) {
            this.func_73729_b(x - 1, y, 180, 7, 11, 10);
            this.func_73729_b(x + 12, y + 1, 180, 0, scale, 7);
        }
    }

    protected void renderFluidTank(int x, int y, FluidTank tank, int scale, GuiElementInfoRegion element) {
        int fuelCapacity;
        this.func_73729_b(x, y, 180, 67, 20, 42);
        GSUtils.displayGauge(x + 1, y - 19, scale, tank.getFluid(), 0);
        this.field_146297_k.field_71446_o.func_110577_a(this.getTexture());
        this.func_73729_b(x, y, 200, 67, 16, 42);
        ArrayList<String> processDesc = new ArrayList<String>();
        processDesc.clear();
        int fuelLevel = tank != null && tank.getFluid() != null ? tank.getFluid().amount : 0;
        int n = fuelCapacity = tank != null ? tank.getCapacity() : 0;
        if (tank.getFluid() != null) {
            processDesc.add(EnumColor.YELLOW + tank.getFluid().getLocalizedName() + ": " + fuelLevel + " / " + fuelCapacity);
        }
        element.tooltipStrings = processDesc;
        element.xPosition = x;
        element.yPosition = y;
    }

    protected abstract boolean isModuleSupport();

    protected abstract String getName();

    protected abstract Slot getBatterySlot();

    protected Style getStyle() {
        return GSConfigCore.enableModernGUI ? Style.MODERN : Style.CLASSIC;
    }

    protected ResourceLocation getTexture() {
        return GSConfigCore.enableModernGUI ? GSConstants.GUI_MACHINE_MODERN : GSConstants.GUI_MACHINE_CLASSIC;
    }

    protected static enum Style {
        CLASSIC,
        MODERN;

    }
}

