/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.models;

import galaxyspace.core.client.models.BakedModelDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.client.FMLClientHandler;

public class BakedModelGlowBlockOverlay
extends BakedModelDelegate {
    private static final VertexFormat format = new VertexFormat(DefaultVertexFormats.field_176600_a).func_181721_a(DefaultVertexFormats.field_181716_p);
    private int bright;
    private double alpha;
    private Map<EnumFacing, String> sprite = new HashMap<EnumFacing, String>();
    private List<BakedQuad> cache;
    private QuadType type;

    public BakedModelGlowBlockOverlay(QuadType type) {
        super(null);
        this.type = type;
    }

    public BakedModelGlowBlockOverlay setModel(IBakedModel base) {
        this.base = base;
        return this;
    }

    public BakedModelGlowBlockOverlay addTexture(EnumFacing side, String texture) {
        this.sprite.put(side, texture);
        return this;
    }

    public BakedModelGlowBlockOverlay setBrightness(int bright) {
        this.bright = bright;
        return this;
    }

    public BakedModelGlowBlockOverlay setAlpha(double alpha) {
        this.alpha = alpha;
        return this;
    }

    public TextureAtlasSprite getSprite(EnumFacing side) {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(this.sprite.get(side));
    }

    public Map<EnumFacing, String> getSprites() {
        return this.sprite;
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, IBlockState state, Vec3d normal, double x, double y, double z, TextureAtlasSprite sprite, float u, float v, boolean hasBrightness, int brightness, Vec3d color) {
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{(float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 1) {
                        if (hasBrightness) {
                            float blockLight = (float)(brightness >> 4 & 0xF) * 32.0f / 65535.0f;
                            float skyLight = (float)(brightness >> 20 & 0xF) * 32.0f / 65535.0f;
                            builder.put(e, new float[]{blockLight, skyLight});
                            continue block6;
                        }
                        builder.put(e, new float[0]);
                        continue block6;
                    }
                    u = sprite.func_94214_a((double)u);
                    v = sprite.func_94207_b((double)v);
                    builder.put(e, new float[]{u, v});
                    continue block6;
                }
                case NORMAL: {
                    if (hasBrightness) {
                        builder.put(e, new float[]{0.0f, 1.0f, 0.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null) {
            return this.base.func_188616_a(state, side, rand);
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(12);
        quads.addAll(this.base.func_188616_a(state, side, rand));
        if (this.type == QuadType.CROSS) {
            quads.add(this.createQuad(state, new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 0.0), this.getSprite(EnumFacing.NORTH), true, this.bright, new Vec3d(1.0, 1.0, 1.0), 0));
            quads.add(this.createQuad(state, new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 0.0, 1.0005), this.getSprite(EnumFacing.NORTH), true, this.bright, new Vec3d(1.0, 1.0, 1.0), 0));
            quads.add(this.createQuad(state, new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(1.0, 0.0, 5.0E-4), this.getSprite(EnumFacing.NORTH), true, this.bright, new Vec3d(1.0, 1.0, 1.0), 0));
            quads.add(this.createQuad(state, new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(5.0E-4, 0.0, 1.0), this.getSprite(EnumFacing.NORTH), true, this.bright, new Vec3d(1.0, 1.0, 1.0), 0));
        } else {
            if (this.sprite.containsKey(EnumFacing.DOWN)) {
                quads.add(this.createQuad(state, new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 0.0), this.getSprite(EnumFacing.DOWN), true, this.bright, new Vec3d(1.0, 1.0, 1.0), 0));
            }
            if (this.sprite.containsKey(EnumFacing.UP)) {
                quads.add(this.createQuad(state, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 0.0), this.getSprite(EnumFacing.UP), true, this.bright, new Vec3d(1.0, 1.0, 1.0), 0));
            }
            if (this.sprite.containsKey(EnumFacing.NORTH)) {
                quads.add(this.createQuad(state, new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(0.0, 0.0, 1.0), this.getSprite(EnumFacing.NORTH), true, this.bright, new Vec3d(1.0, 1.0, 1.0), 0));
            }
            if (this.sprite.containsKey(EnumFacing.SOUTH)) {
                quads.add(this.createQuad(state, new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(1.0, 0.0, 0.0), this.getSprite(EnumFacing.SOUTH), true, this.bright, new Vec3d(1.0, 1.0, 1.0), 0));
            }
            if (this.sprite.containsKey(EnumFacing.EAST)) {
                quads.add(this.createQuad(state, new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 0.0), this.getSprite(EnumFacing.EAST), true, this.bright, new Vec3d(1.0, 1.0, 1.0), 0));
            }
            if (this.sprite.containsKey(EnumFacing.WEST)) {
                quads.add(this.createQuad(state, new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 0.0, 1.0), this.getSprite(EnumFacing.WEST), true, this.bright, new Vec3d(1.0, 1.0, 1.0), 0));
            }
        }
        return quads;
    }

    private BakedQuad createQuad(IBlockState state, Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, boolean hasBrightness, int brightness, Vec3d color, int tint) {
        Vec3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setTexture(sprite);
        builder.setQuadTint(tint);
        this.putVertex(builder, state, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, sprite, 16.0f, 16.0f, hasBrightness, brightness, color);
        this.putVertex(builder, state, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, sprite, 16.0f, 0.0f, hasBrightness, brightness, color);
        this.putVertex(builder, state, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, sprite, 0.0f, 0.0f, hasBrightness, brightness, color);
        this.putVertex(builder, state, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, sprite, 0.0f, 16.0f, hasBrightness, brightness, color);
        return builder.build();
    }

    public static boolean isLightMapDisabled() {
        return FMLClientHandler.instance().hasOptifine() || !ForgeModContainer.forgeLightPipelineEnabled;
    }

    public static VertexFormat getFormatWithLightMap(VertexFormat formatdef) {
        if (BakedModelGlowBlockOverlay.isLightMapDisabled()) {
            return formatdef;
        }
        if (formatdef == DefaultVertexFormats.field_176600_a) {
            return DefaultVertexFormats.field_176600_a;
        }
        if (formatdef == DefaultVertexFormats.field_176599_b) {
            return format;
        }
        if (!formatdef.func_177347_a(1)) {
            VertexFormat result = new VertexFormat(formatdef);
            result.func_181721_a(DefaultVertexFormats.field_181716_p);
            return result;
        }
        return formatdef;
    }

    public static enum QuadType {
        BLOCK,
        CROSS;

    }
}

