/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.configs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class GSConfigDimensions {
    public static boolean loaded;
    public static Configuration config;
    public static int dimensionIDMercury;
    public static int dimensionIDVenus;
    public static int dimensionIDCeres;
    public static int dimensionIDJupiter;
    public static int dimensionIDPluto;
    public static int dimensionIDKuiperBelt;
    public static int dimensionIDHaumea;
    public static int dimensionIDMakemake;
    public static int dimensionIDTest;
    public static int dimensionIDPhobos;
    public static int dimensionIDDeimos;
    public static int dimensionIDIo;
    public static int dimensionIDEuropa;
    public static int dimensionIDGanymede;
    public static int dimensionIDCallisto;
    public static int dimensionIDEnceladus;
    public static int dimensionIDTitan;
    public static int dimensionIDOberon;
    public static int dimensionIDMiranda;
    public static int dimensionIDProteus;
    public static int dimensionIDTriton;
    public static boolean enableMercury;
    public static boolean enableVenus;
    public static boolean enableCeres;
    public static boolean enableKuiperBelt;
    public static boolean enablePluto;
    public static boolean enableHaumea;
    public static boolean enableMakemake;
    public static boolean enablePhobos;
    public static boolean enableDeimos;
    public static boolean enableEuropa;
    public static boolean enableCallisto;
    public static boolean enableIo;
    public static boolean enableGanymede;
    public static boolean enableEnceladus;
    public static boolean enableTitan;
    public static boolean enableOberon;
    public static boolean enableMiranda;
    public static boolean enableProteus;
    public static boolean enableTriton;
    public static boolean enableJupiter;
    public static boolean enableSaturn;
    public static boolean enableUranus;
    public static boolean enableNeptune;
    public static boolean enableVenusSpaceStation;
    public static boolean enableMarsSpaceStation;
    public static int idDimensionMarsOrbit;
    public static int idDimensionMarsOrbitStatic;
    public static int idDimensionVenusOrbit;
    public static int idDimensionVenusOrbitStatic;

    public GSConfigDimensions(File file) {
        if (!loaded) {
            config = new Configuration(file);
            GSConfigDimensions.syncConfig(true);
        }
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            if (!GSConfigDimensions.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("dimensions", "dimensionIDMercury", -1005);
            prop.setComment("Dimension ID for Mercury");
            prop.setLanguageKey("gc.configgui.dimensionIDMerucry").setRequiresMcRestart(true);
            dimensionIDMercury = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDVenus", -1006);
            prop.setComment("Dimension ID for Venus");
            prop.setLanguageKey("gc.configgui.dimensionIDVenus").setRequiresMcRestart(true);
            dimensionIDVenus = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDCeres", -1007);
            prop.setComment("Dimension ID for Ceres");
            prop.setLanguageKey("gc.configgui.dimensionIDCeres").setRequiresMcRestart(true);
            dimensionIDCeres = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDPluto", -1008);
            prop.setComment("Dimension ID for Pluto");
            prop.setLanguageKey("gc.configgui.dimensionIDPluto").setRequiresMcRestart(true);
            dimensionIDPluto = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDKuiperBelt", -1009);
            prop.setComment("Dimension ID for Kuiper Belt");
            prop.setLanguageKey("gc.configgui.dimensionIDKuiperBelt").setRequiresMcRestart(true);
            dimensionIDKuiperBelt = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDPhobos", -1012);
            prop.setComment("Dimension ID for Phobos (Mars moon)");
            prop.setLanguageKey("gc.configgui.dimensionIDPhobos").setRequiresMcRestart(true);
            dimensionIDPhobos = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDDeimos", -1013);
            prop.setComment("Dimension ID for Deimos (Mars moon)");
            prop.setLanguageKey("gc.configgui.dimensionIDDeimos").setRequiresMcRestart(true);
            dimensionIDDeimos = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDIo", -1014);
            prop.setComment("Dimension ID for Io (Jupiter moon)");
            prop.setLanguageKey("gc.configgui.dimensionIDIo").setRequiresMcRestart(true);
            dimensionIDIo = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDEuropa", -1015);
            prop.setComment("Dimension ID for Europa (Jupiter moon)");
            prop.setLanguageKey("gc.configgui.dimensionIDEuropa").setRequiresMcRestart(true);
            dimensionIDEuropa = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDGanymede", -1016);
            prop.setComment("Dimension ID for Ganymede (Jupiter moon)");
            prop.setLanguageKey("gc.configgui.dimensionIDGanymede").setRequiresMcRestart(true);
            dimensionIDGanymede = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDEnceladus", -1017);
            prop.setComment("Dimension ID for Enceladus (Saturn moon)");
            prop.setLanguageKey("gc.configgui.dimensionIDEnceladus").setRequiresMcRestart(true);
            dimensionIDEnceladus = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDTitan", -1018);
            prop.setComment("Dimension ID for Titan (Saturn moon)");
            prop.setLanguageKey("gc.configgui.dimensionIDTitan").setRequiresMcRestart(true);
            dimensionIDTitan = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDTriton", -1021);
            prop.setComment("Dimension ID for Triton (Neptune moon)");
            prop.setLanguageKey("gc.configgui.dimensionIDTriton").setRequiresMcRestart(true);
            dimensionIDTriton = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDCallisto", -1022);
            prop.setComment("Dimension ID for Callisto (Jupiter Moon)");
            prop.setLanguageKey("gc.configgui.dimensionIDCallisto").setRequiresMcRestart(true);
            dimensionIDCallisto = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDHaumea", -1023);
            prop.setComment("Dimension ID for Haumea");
            prop.setLanguageKey("gc.configgui.dimensionIDHaumea").setRequiresMcRestart(true);
            dimensionIDHaumea = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDMiranda", -1024);
            prop.setComment("Dimension ID for Miranda (Uranus moon)");
            prop.setLanguageKey("gc.configgui.dimensionIDMiranda").setRequiresMcRestart(true);
            dimensionIDMiranda = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "dimensionIDJupiter", -1026);
            prop.setComment("Dimension ID for Jupiter (Only for Space Station)");
            prop.setLanguageKey("gc.configgui.dimensionIDJupiter").setRequiresMcRestart(true);
            dimensionIDJupiter = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("development", "dimensionIDTest", -1234);
            prop.setComment("Dimension ID for Test planet (only for debug)");
            prop.setLanguageKey("gc.configgui.dimensionIDTest").setRequiresMcRestart(true);
            dimensionIDTest = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "idDimensionMarsOrbit", -1127);
            prop.setComment("WorldProvider ID for Mars Space Stations (advanced: do not change unless you have conflicts)");
            prop.setLanguageKey("gc.configgui.idDimensionMarsOrbit").setRequiresMcRestart(true);
            idDimensionMarsOrbit = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "idDimensionMarsOrbitStatic", -1126);
            prop.setComment("WorldProvider ID for Static Mars Space Stations (advanced: do not change unless you have conflicts)");
            prop.setLanguageKey("gc.configgui.idDimensionMarsOrbitStatic").setRequiresMcRestart(true);
            idDimensionMarsOrbitStatic = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "idDimensionVenusOrbit", -1128);
            prop.setComment("WorldProvider ID for Venus Space Stations (advanced: do not change unless you have conflicts)");
            prop.setLanguageKey("gc.configgui.idDimensionVenusOrbit").setRequiresMcRestart(true);
            idDimensionVenusOrbit = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "idDimensionVenusOrbitStatic", -1129);
            prop.setComment("WorldProvider ID for Static Venus Space Stations (advanced: do not change unless you have conflicts)");
            prop.setLanguageKey("gc.configgui.idDimensionVenusOrbitStatic").setRequiresMcRestart(true);
            idDimensionVenusOrbitStatic = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "enableMercury", true);
            prop.setComment("Enable/Disable Mercury");
            prop.setLanguageKey("gc.configgui.enableMercury").setRequiresMcRestart(true);
            enableMercury = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableVenus", true);
            prop.setComment("Enable/Disable Venus");
            prop.setLanguageKey("gc.configgui.enableVenus").setRequiresMcRestart(true);
            enableVenus = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableCeres", true);
            prop.setComment("Enable/Disable Ceres");
            prop.setLanguageKey("gc.configgui.enableCeres").setRequiresMcRestart(true);
            enableCeres = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enablePluto", true);
            prop.setComment("Enable/Disable Pluto");
            prop.setLanguageKey("gc.configgui.enablePluto").setRequiresMcRestart(true);
            enablePluto = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableKuiperBelt", true);
            prop.setComment("Enable/Disable Kuiper Belt");
            prop.setLanguageKey("gc.configgui.enableKuiperBelt").setRequiresMcRestart(true);
            enableKuiperBelt = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableHaumea", true);
            prop.setComment("Enable/Disable Haumea");
            prop.setLanguageKey("gc.configgui.enableHaumea").setRequiresMcRestart(true);
            enableHaumea = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableMakemake", true);
            prop.setComment("Enable/Disable Makemake");
            prop.setLanguageKey("gc.configgui.enableMakemake").setRequiresMcRestart(true);
            enableMakemake = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enablePhobos", true);
            prop.setComment("Enable/Disable Phobos (Mars Moon)");
            prop.setLanguageKey("gc.configgui.enablePhobos").setRequiresMcRestart(true);
            enablePhobos = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableDeimos", true);
            prop.setComment("Enable/Disable Deimos (Mars Moon)");
            prop.setLanguageKey("gc.configgui.enableDeimos").setRequiresMcRestart(true);
            enableDeimos = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableEuropa", true);
            prop.setComment("Enable/Disable Europa (Jupiter Moon)");
            prop.setLanguageKey("gc.configgui.enableEuropa").setRequiresMcRestart(true);
            enableEuropa = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableIo", true);
            prop.setComment("Enable/Disable Io (Jupiter Moon)");
            prop.setLanguageKey("gc.configgui.enableIo").setRequiresMcRestart(true);
            enableIo = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableGanymede", true);
            prop.setComment("Enable/Disable Ganymede (Jupiter Moon)");
            prop.setLanguageKey("gc.configgui.enableGanymede").setRequiresMcRestart(true);
            enableGanymede = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableCallisto", true);
            prop.setComment("Enable/Disable Callisto (Jupiter Moon)");
            prop.setLanguageKey("gc.configgui.enableCallisto").setRequiresMcRestart(true);
            enableCallisto = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableEnceladus", true);
            prop.setComment("Enable/Disable Enceladus (Saturn Moon)");
            prop.setLanguageKey("gc.configgui.enableEnceladus").setRequiresMcRestart(true);
            enableEnceladus = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableTitan", true);
            prop.setComment("Enable/Disable Titan (Saturn Moon)");
            prop.setLanguageKey("gc.configgui.enableTitan").setRequiresMcRestart(true);
            enableTitan = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableMiranda", true);
            prop.setComment("Enable/Disable Miranda (Uranus Moon)");
            prop.setLanguageKey("gc.configgui.enableMiranda").setRequiresMcRestart(true);
            enableMiranda = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableOberon", true);
            prop.setComment("Enable/Disable Oberon (Uranus Moon)");
            prop.setLanguageKey("gc.configgui.enableOberon").setRequiresMcRestart(true);
            enableOberon = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableProteus", true);
            prop.setComment("Enable/Disable Proteus (Neptune Moon)");
            prop.setLanguageKey("gc.configgui.enableProteus").setRequiresMcRestart(true);
            enableProteus = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableTriton", true);
            prop.setComment("Enable/Disable Triton (Neptune Moon)");
            prop.setLanguageKey("gc.configgui.enableTriton").setRequiresMcRestart(true);
            enableTriton = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableVenusSpaceStation", true);
            prop.setComment("Enable/Disable Venus Space Station");
            prop.setLanguageKey("gc.configgui.enableVenusSpaceStation").setRequiresMcRestart(true);
            enableVenusSpaceStation = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableMarsSpaceStation", true);
            prop.setComment("Enable/Disable Mars Space Station");
            prop.setLanguageKey("gc.configgui.enableMarsSpaceStation").setRequiresMcRestart(true);
            enableMarsSpaceStation = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableJupiter", true);
            prop.setComment("Enable/Disable Jupiter (only on map for moons)");
            prop.setLanguageKey("gc.configgui.enableJupiter").setRequiresMcRestart(true);
            enableJupiter = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableSaturn", true);
            prop.setComment("Enable/Disable Saturn (only on map for moons)");
            prop.setLanguageKey("gc.configgui.enableSaturn").setRequiresMcRestart(true);
            enableSaturn = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableUranus", true);
            prop.setComment("Enable/Disable Uranus (only on map for moons)");
            prop.setLanguageKey("gc.configgui.enableUranus").setRequiresMcRestart(true);
            enableUranus = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableNeptune", true);
            prop.setComment("Enable/Disable Neptune (only on map for moons)");
            prop.setLanguageKey("gc.configgui.enableNeptune").setRequiresMcRestart(true);
            enableNeptune = prop.getBoolean(true);
            propOrder.add(prop.getName());
            config.setCategoryPropertyOrder("general", propOrder);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"GalaxySpace (Planets) has a problem loading it's config", (Object[])new Object[0]);
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("difficulty")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("client")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("controls")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("compatibility")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("worldgen")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("server")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("dimensions")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("schematic")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("achievements")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("entities")).getChildElements());
        return list;
    }
}

