/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.events;

import asmodeuscore.api.space.IBookPage;
import asmodeuscore.core.astronomy.gui.book.ACGuiGuideBook;
import asmodeuscore.core.utils.BookUtils;
import asmodeuscore.core.utils.Utils;
import galaxyspace.GalaxySpace;
import galaxyspace.api.item.IJetpackArmor;
import galaxyspace.api.item.IModificationItem;
import galaxyspace.core.client.gui.GSGuiMainMenu;
import galaxyspace.core.client.gui.book.pages.general.Page_ActualUpdate;
import galaxyspace.core.client.gui.overlay.OverlaySpaceSuit;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.events.GSEventHandler;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.core.util.GSThreadVersionCheck;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemBasicGS;
import galaxyspace.systems.SolarSystem.planets.overworld.items.tools.ItemGeologicalScanner;
import galaxyspace.systems.SolarSystem.planets.overworld.items.tools.ItemMatterManipulator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.event.ZeroGravityEvent;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GSClientTickHandler {
    public Minecraft mc = FMLClientHandler.instance().getClient();
    public Random rand;
    public static Map<IBlockState, String> blocks = new HashMap<IBlockState, String>();
    public static int ticks;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu && GSConfigCore.enableNewMenu) {
            event.setGui((GuiScreen)new GSGuiMainMenu());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onToolTip(ItemTooltipEvent e) {
        IModificationItem mod;
        if (e.getItemStack().func_77973_b() instanceof IModificationItem && (mod = (IModificationItem)e.getItemStack().func_77973_b()).getType(e.getItemStack()) != null && mod.getAvailableModules() != null) {
            e.getToolTip().add(1, EnumColor.AQUA + GCCoreUtil.translate((String)"gui.module.caninstall"));
        }
        if (e.getItemStack().func_77969_a(new ItemStack(MarsItems.schematic, 1, 0)) && GSConfigCore.enableAdvancedRocketCraft) {
            e.getToolTip().add(1, EnumColor.RED + "Disabled. See new recipe in JEI/NEI!");
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = this.mc.field_71441_e;
        if (event.phase == TickEvent.Phase.END && Side.CLIENT != null && player != null && world != null && GSThreadVersionCheck.newversion && this.mc.field_71415_G && GSConfigCore.enableCheckVersion) {
            GSThreadVersionCheck.newversion = false;
            Minecraft.func_71410_x().func_152344_a(() -> FMLClientHandler.instance().showGuiScreen((Object)new ACGuiGuideBook(ACGuiGuideBook.Mode.TEXT, BookUtils.Book_Cateroies.GENERAL.getName(), (IBookPage)new Page_ActualUpdate(true))));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onLivingRender(RenderLivingEvent.Post event) {
        if (event.getEntity() instanceof EntityPlayer) {
            ModelBase mdl;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ItemStack mainhand = player.func_184614_ca();
            ItemStack offhand = player.func_184592_cb();
            if ((!mainhand.func_190926_b() && mainhand.func_77973_b() instanceof ItemMatterManipulator || !offhand.func_190926_b() && offhand.func_77973_b() instanceof ItemMatterManipulator) && (mdl = event.getRenderer().func_177087_b()) instanceof ModelPlayer) {
                ModelPlayer model = (ModelPlayer)mdl;
                if (player.func_184591_cq() == EnumHandSide.RIGHT) {
                    model.field_178723_h.field_78796_g = -0.1f + model.field_78116_c.field_78796_g;
                } else {
                    model.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        if (event.phase == TickEvent.Phase.END && player != null) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179094_E();
            if (minecraft.field_71415_G && !minecraft.field_71474_y.field_74319_N && GSConfigCore.enableSpaceSuitHUD) {
                OverlaySpaceSuit.renderSpaceSuitOverlay((EntityPlayer)playerBaseClient);
            }
            GlStateManager.func_179121_F();
            ScaledResolution scaled = new ScaledResolution(this.mc);
            if (minecraft.field_71415_G && !minecraft.field_71474_y.field_74319_N && ticks > 0) {
                GlStateManager.func_179094_E();
                int xPos = 10;
                int yPos = scaled.func_78328_b() / 2 - 50;
                int color = Utils.getIntColorWHC((int)0, (int)0, (int)0, (int)150);
                int offsetY = 0;
                this.mc.field_71466_p.func_175063_a("Geological Scanner Data:", (float)xPos, (float)(yPos - 10), 0xFFFFFF);
                for (Map.Entry<IBlockState, String> block : blocks.entrySet()) {
                    ItemStack item = new ItemStack(Item.func_150898_a((Block)block.getKey().func_177230_c()), 1, block.getKey().func_177230_c().func_176201_c(block.getKey()));
                    GuiIngame cfr_ignored_0 = this.mc.field_71456_v;
                    GuiIngame.func_73734_a((int)xPos, (int)(yPos + 24 * offsetY), (int)(xPos + 180), (int)(yPos + 22 + 24 * offsetY), (int)color);
                    this.mc.func_175599_af().field_77023_b = -100.0f;
                    this.mc.func_175599_af().func_175042_a(item, xPos + 3, yPos + 24 * offsetY + 3);
                    this.mc.field_71466_p.func_175063_a(block.getValue(), (float)(xPos + 25), (float)(yPos + 24 * offsetY + 6), 0xFFFFFF);
                    ++offsetY;
                }
                GlStateManager.func_179121_F();
            }
            if (ticks > 0 && player.field_70173_aa % 10 == 0) {
                --ticks;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onZeroGravity(ZeroGravityEvent.InFreefall event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (GSEventHandler.inGravityZone(entity.func_130014_f_(), entity, false)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderBlocks(RenderWorldLastEvent e) {
        RayTraceResult ray;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        if (player != null && stack != null && stack.func_77973_b() instanceof ItemGeologicalScanner && stack.func_77952_i() < stack.func_77958_k() && stack.func_77978_p().func_74762_e("mode") == 0 && (ray = ItemBasicGS.getRay(player.func_130014_f_(), (EntityPlayer)player, false)) != null && ray.field_72307_f.func_72438_d(player.func_174791_d()) < 5.0) {
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder worldRenderer = tess.func_178180_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            BlockPos blockpos = ray.func_178782_a();
            IBlockState iblockstate = player.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() != Material.field_151579_a && player.field_70170_p.func_175723_af().func_177746_a(blockpos)) {
                double d3 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)player.field_70173_aa;
                double d4 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)player.field_70173_aa;
                double d5 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)player.field_70173_aa;
                RenderGlobal cfr_ignored_0 = Minecraft.func_71410_x().field_71438_f;
                RenderGlobal.func_189697_a((AxisAlignedBB)iblockstate.func_185918_c(player.field_70170_p, blockpos).func_186662_g(2.0).func_72317_d(-d3, -d4, -d5), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
        if (stack.func_77973_b() instanceof ItemMatterManipulator && (ray = ItemBasicGS.getRay(player.func_130014_f_(), (EntityPlayer)player, false)) != null && ray.field_72307_f.func_72438_d(player.func_174791_d()) < 15.0) {
            ItemMatterManipulator.drawLine(player.func_180425_c().func_177963_a(0.0, (double)player.func_70047_e(), 0.0), ray.func_178782_a(), player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        ItemStack chest;
        if (e.phase == TickEvent.Phase.START && e.side == Side.CLIENT && (chest = e.player.func_184582_a(EntityEquipmentSlot.CHEST)) != null && chest.func_77973_b() instanceof IJetpackArmor && ((IJetpackArmor)chest.func_77973_b()).canFly(chest, e.player)) {
            this.parseKeybindings(e.player);
        }
    }

    private void parseKeybindings(EntityPlayer player) {
        float power = 1.0f;
        double y = player.field_70163_u;
        int worldHeight1 = player.func_130014_f_().func_72800_K();
        int maxFlightHeight1 = (int)((float)worldHeight1 / 1.28f);
        if (y > (double)(maxFlightHeight1 - 25)) {
            if (y > (double)maxFlightHeight1) {
                y = maxFlightHeight1;
            }
            power = (float)((double)power * (((double)maxFlightHeight1 - y) / 25.0));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
            player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.15f), (double)0.6f);
            GalaxySpace.packetPipeline.sendToServer((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_CHANGE_FLIGHT_STATE, player.field_70170_p, new Object[]{true}));
        } else {
            GalaxySpace.packetPipeline.sendToServer((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_CHANGE_FLIGHT_STATE, player.field_70170_p, new Object[]{false}));
        }
    }
}

