/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.network.trackers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import galaxyspace.GalaxySpace;
import galaxyspace.core.network.packet.GSPacketSimple;
import java.util.ArrayList;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledDimensionChange;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class MultiSeatRocketDriverTracker {
    private static final MultiSeatRocketDriverTracker INSTANCE = new MultiSeatRocketDriverTracker();
    private Map<EntityPlayerMP, ArrayList<EntityPlayerMP>> DRIVER_PASSENGERS_TRACKED = Maps.newHashMap();

    public static MultiSeatRocketDriverTracker get() {
        return INSTANCE;
    }

    private void addTrackedDriver(EntityPlayerMP driver) {
        if (!this.DRIVER_PASSENGERS_TRACKED.containsKey(driver)) {
            this.DRIVER_PASSENGERS_TRACKED.put(driver, Lists.newArrayList());
            GalaxySpace.info("add driver to tracking " + driver.toString());
        }
    }

    public void addPassengerToTrackedDriver(EntityPlayerMP driver, EntityPlayerMP passenger) {
        this.addTrackedDriver(driver);
        this.DRIVER_PASSENGERS_TRACKED.get(driver).add(passenger);
        GalaxySpace.info("add passenger to driver's tracker " + passenger.toString());
    }

    public void releaseTrackedDriver(EntityPlayerMP driver) {
        if (this.DRIVER_PASSENGERS_TRACKED.containsKey(driver)) {
            GalaxySpace.info("released driver " + driver.toString() + " with passengers " + this.DRIVER_PASSENGERS_TRACKED.get(driver));
            this.DRIVER_PASSENGERS_TRACKED.remove(driver);
        }
        GalaxySpace.info("there is no driver to release! Trying release driver " + driver.toString());
    }

    public void update() {
        for (Map.Entry<EntityPlayerMP, ArrayList<EntityPlayerMP>> trackedEntry : this.DRIVER_PASSENGERS_TRACKED.entrySet()) {
            GCPlayerStats driverStats = GCPlayerStats.get((Entity)((Entity)trackedEntry.getKey()));
            if (driverStats.getTeleportCooldown() <= 0) continue;
            for (EntityPlayerMP passenger : trackedEntry.getValue()) {
                TickHandlerServer.scheduleNewDimensionChange((ScheduledDimensionChange)new ScheduledDimensionChange(passenger, trackedEntry.getKey().field_70170_p.field_73011_w.getDimension()));
                GalaxySpace.info("schedule dimension change for " + passenger.toString() + " (call by driver " + trackedEntry.getKey().toString() + ")");
                GalaxySpace.packetPipeline.sendTo((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.C_CLOSE_WAITFORDRIVER_GUI, GCCoreUtil.getDimensionID((World)passenger.field_70170_p), new Object[0]), passenger);
                GalaxySpace.info("notified " + passenger.toString() + " that gui must be closed");
            }
            this.releaseTrackedDriver(trackedEntry.getKey());
        }
    }
}

