/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.prefab.entities;

import asmodeuscore.core.handler.capabilities.ACStatsCapability;
import asmodeuscore.core.handler.capabilities.IStatsCapability;
import com.mojang.realmsclient.gui.ChatFormatting;
import galaxyspace.GalaxySpace;
import galaxyspace.api.entity.IMultiSeatEntity;
import galaxyspace.core.GSItems;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.core.network.trackers.MultiSeatRocketDriverTracker;
import java.lang.reflect.Field;
import java.util.Iterator;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;

public abstract class EntityMultiSeatRocket
extends EntityTieredRocket
implements IMultiSeatEntity {
    static Field marsConfigAllDimsAllowed;

    public EntityMultiSeatRocket(World par1World) {
        super(par1World);
    }

    public EntityMultiSeatRocket(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    public void func_70071_h_() {
        if (this.getWaitForPlayer()) {
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity passenger : this.func_184188_bt()) {
                    if (this.ticks >= 40L) {
                        if (!this.field_70170_p.field_72995_K) {
                            this.func_184226_ay();
                            passenger.func_184205_a((Entity)this, true);
                            GCLog.debug((String)"Remounting player in rocket.");
                        }
                        this.setWaitForPlayer(false);
                        this.field_70181_x = -0.5;
                        continue;
                    }
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    passenger.field_70179_y = 0.0;
                    passenger.field_70181_x = 0.0;
                    passenger.field_70159_w = 0.0;
                }
            } else {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            }
        }
        super.func_70071_h_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                double d = this.timeSinceLaunch / 150.0f;
                d = this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).hasNoAtmosphere() ? Math.min(d * 1.2, 2.0) : Math.min(d, 1.4);
                if (d != 0.0) {
                    this.field_70181_x = -d * 2.5 * Math.cos((this.field_70125_A - 180.0f) / 57.295776f);
                }
            } else {
                this.field_70181_x -= 0.008;
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(2.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    protected void spawnParticles(boolean launched) {
        if (!this.field_70128_L) {
            double sinPitch = Math.sin((double)this.field_70125_A / 57.29577951308232);
            double x1 = 3.2 * Math.cos((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double z1 = 3.2 * Math.sin((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double y1 = 3.2 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.targetVec != null) {
                double modifier = this.field_70163_u - (double)this.targetVec.func_177956_o();
                modifier = Math.max(modifier, 180.0);
                x1 *= modifier / 200.0;
                y1 *= Math.min(modifier / 200.0, 2.5);
                z1 *= modifier / 200.0;
            }
            double y2 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + y1 - 0.75 * this.field_70181_x - 0.3 + 1.2;
            double x2 = this.field_70165_t + x1 + this.field_70159_w;
            double z2 = this.field_70161_v + z1 + this.field_70179_y;
            Vector3 motionVec = new Vector3(x1 + this.field_70159_w, y1 + this.field_70181_x, z1 + this.field_70179_y);
            Vector3 d1 = new Vector3(y1 * 0.1, -x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d2 = new Vector3(x1 * 0.1, -z1 * 0.1, y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d3 = new Vector3(-y1 * 0.1, x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d4 = new Vector3(x1 * 0.1, z1 * 0.1, -y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 mv1 = motionVec.clone().translate(d1);
            Vector3 mv2 = motionVec.clone().translate(d2);
            Vector3 mv3 = motionVec.clone().translate(d3);
            Vector3 mv4 = motionVec.clone().translate(d4);
            EntityPlayer riddenByEntity = this.getDriver();
            Object[] rider = new Object[]{riddenByEntity};
            this.makeFlame(x2 + d1.x, y2 + d1.y, z2 + d1.z, mv1, this.getLaunched(), rider);
            this.makeFlame(x2 + d2.x, y2 + d2.y, z2 + d2.z, mv2, this.getLaunched(), rider);
            this.makeFlame(x2 + d3.x, y2 + d3.y, z2 + d3.z, mv3, this.getLaunched(), rider);
            this.makeFlame(x2 + d4.x, y2 + d4.y, z2 + d4.z, mv4, this.getLaunched(), rider);
        }
    }

    private void makeFlame(double x2, double y2, double z2, Vector3 motionVec, boolean getLaunched, Object[] rider) {
        if (getLaunched) {
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4, y2, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4, y2, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 + 0.4), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 - 0.4), motionVec, rider);
            return;
        }
        if (this.field_70173_aa % 2 == 0) {
            return;
        }
        double x1 = motionVec.x;
        double y1 = motionVec.y;
        double z1 = motionVec.z;
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2 += 1.6, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4, y2, z2), new Vector3(x1 + 0.3, y1 - 0.3, z1), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4, y2, z2), new Vector3(x1 - 0.3, y1 - 0.3, z1), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 + 0.4), new Vector3(x1, y1 - 0.3, z1 + 0.3), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 - 0.4), new Vector3(x1, y1 - 0.3, z1 - 0.3), rider);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.getMaxSeats() > 1) {
            return this.interactSpecial(player, hand);
        }
        return super.func_184230_a(player, hand);
    }

    private boolean interactSpecial(EntityPlayer player, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            return false;
        }
        if (this.func_184188_bt().size() >= this.getMaxSeats()) {
            player.func_146105_b((ITextComponent)new TextComponentString(ChatFormatting.RED + "Not enough seats in rocket!"), true);
            return false;
        }
        if (!this.field_70170_p.field_72995_K && player instanceof EntityPlayerMP && !this.func_184196_w((Entity)player) && player.func_184220_m((Entity)this)) {
            GalaxySpace.info(String.format("Add passenger to rocket %s [%s]", player.toString(), this.func_184188_bt().toString()));
            GCPlayerStats stats = GCPlayerStats.get((Entity)player);
            stats.setChatCooldown(0);
            if (this.func_184188_bt().size() == 1) {
                GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_DISPLAY_ROCKET_CONTROLS, this.field_70170_p.field_73011_w.getDimension(), new Object[0]), (EntityPlayerMP)player);
            } else {
                IStatsCapability asCaps = ACStatsCapability.get((Entity)((EntityPlayerMP)player));
                asCaps.setSecondPassenger(true);
            }
            return true;
        }
        return false;
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (passenger.func_184187_bx() != this) {
            GalaxySpace.info(String.format("Remove passenger %s", passenger.toString()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onReachAtmosphere() {
        block17: {
            block18: {
                block19: {
                    if (this.destinationFrequency == -1) break block17;
                    if (this.field_70170_p.field_72995_K) {
                        this.stopRocketSound();
                        return;
                    }
                    this.setTarget(true, this.destinationFrequency);
                    if (this.targetVec == null) break block18;
                    if (this.targetDimension == this.field_70170_p.field_73011_w.getDimension()) break block19;
                    WorldProvider targetDim = WorldUtil.getProviderForDimensionServer((int)this.targetDimension);
                    if (targetDim != null && targetDim.field_76579_a instanceof WorldServer) {
                        boolean dimensionAllowed;
                        boolean bl = dimensionAllowed = this.targetDimension == ConfigManagerCore.idDimensionOverworld;
                        if (targetDim instanceof IGalacticraftWorldProvider) {
                            dimensionAllowed = ((IGalacticraftWorldProvider)targetDim).canSpaceshipTierPass(this.getRocketTier());
                        } else if ((this.targetDimension > 1 || this.targetDimension < -1) && marsConfigAllDimsAllowed != null) {
                            try {
                                if (marsConfigAllDimsAllowed.getBoolean(null)) {
                                    dimensionAllowed = true;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (dimensionAllowed) {
                            if (!this.func_184188_bt().isEmpty()) {
                                Iterator e = this.func_184188_bt().iterator();
                                while (e.hasNext()) {
                                    Entity passenger = (Entity)e.next();
                                    if (!(passenger instanceof EntityPlayerMP)) continue;
                                    WorldUtil.transferEntityToDimension((Entity)passenger, (int)this.targetDimension, (WorldServer)((WorldServer)targetDim.field_76579_a), (boolean)false, (EntityAutoRocket)this);
                                }
                                return;
                            }
                            Entity e = WorldUtil.transferEntityToDimension((Entity)this, (int)this.targetDimension, (WorldServer)((WorldServer)targetDim.field_76579_a), (boolean)false, null);
                            if (e instanceof EntityAutoRocket) {
                                e.func_70107_b((double)((float)this.targetVec.func_177958_n() + 0.5f), (double)(this.targetVec.func_177956_o() + 800), (double)((float)this.targetVec.func_177952_p() + 0.5f));
                                ((EntityAutoRocket)e).setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LANDING);
                                ((EntityAutoRocket)e).setWaitForPlayer(false);
                                return;
                            }
                            GCLog.info((String)"Error: failed to recreate the unmanned rocket in landing mode on target planet.");
                            e.func_70106_y();
                            this.func_70106_y();
                            return;
                        }
                    }
                    break block17;
                }
                this.func_70107_b((float)this.targetVec.func_177958_n() + 0.5f, this.targetVec.func_177956_o() + 800, (float)this.targetVec.func_177952_p() + 0.5f);
                this.field_70179_y = 0.0;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.1;
                Iterator iterator = this.func_184188_bt().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LANDING);
                        return;
                    }
                    Entity passenger = (Entity)iterator.next();
                    if (!(passenger instanceof EntityPlayerMP)) continue;
                    WorldUtil.forceMoveEntityToPos((Entity)passenger, (WorldServer)((WorldServer)this.field_70170_p), (Vector3)new Vector3((double)((float)this.targetVec.func_177958_n() + 0.5f), (double)(this.targetVec.func_177956_o() + 800), (double)((float)this.targetVec.func_177952_p() + 0.5f)), (boolean)false);
                    this.setWaitForPlayer(true);
                    GCLog.debug((String)"Rocket repositioned, waiting for player");
                }
            }
            GCLog.info((String)"Error: the launch controlled rocket failed to find a valid landing spot when it reached space.");
            this.fuelTank.drain(Integer.MAX_VALUE, true);
            this.field_70163_u = Math.max(255.0, (this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0) - 200.0);
            return;
        }
        if (this.field_70170_p.field_72995_K) return;
        Iterator iterator = this.func_184188_bt().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.func_70106_y();
                return;
            }
            Entity passenger = (Entity)iterator.next();
            if (!(passenger instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)passenger;
            this.onTeleport(player);
            GCPlayerStats stats = GCPlayerStats.get((Entity)player);
            if (player.equals((Object)this.getDriver())) {
                WorldUtil.toCelestialSelection((EntityPlayerMP)player, (GCPlayerStats)stats, (int)this.getRocketTier());
                continue;
            }
            IStatsCapability asCaps = ACStatsCapability.get((Entity)player);
            this.waitForRocketDriver(player, stats, asCaps, this.getRocketTier());
        }
    }

    private void waitForRocketDriver(EntityPlayerMP player, GCPlayerStats stats, IStatsCapability asCaps, int tier) {
        player.func_184210_p();
        stats.setSpaceshipTier(tier);
        stats.setUsingPlanetSelectionGui(false);
        stats.setSavedPlanetList("");
        asCaps.setSecondPassenger(false);
        GalaxySpace.packetPipeline.sendTo((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.C_OPEN_WAITFORDRIVER_GUI, GCCoreUtil.getDimensionID((World)player.field_70170_p), new Object[0]), player);
        MultiSeatRocketDriverTracker.get().addPassengerToTrackedDriver((EntityPlayerMP)this.getDriver(), player);
        EntityCelestialFake fakeEntity = new EntityCelestialFake(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        player.field_70170_p.func_72838_d((Entity)fakeEntity);
        player.func_184220_m((Entity)fakeEntity);
    }

    public void onTeleport(EntityPlayerMP player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase != null && playerBase.equals((Object)((EntityPlayerMP)this.getDriver()))) {
            GCPlayerStats stats = GCPlayerStats.get((Entity)playerBase);
            if (this.stacks == null || this.stacks.isEmpty()) {
                stats.setRocketStacks(NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a));
            } else {
                stats.setRocketStacks(this.stacks);
            }
            stats.setRocketType(this.rocketType.getIndex());
            stats.setRocketItem(GSItems.ROCKET_MULTI_SEAT);
            stats.setFuelLevel(this.fuelTank.getFluidAmount());
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.getMaxSeats();
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.getMountedYOffset(passenger), this.field_70161_v);
        }
    }

    public double getMountedYOffset(Entity passenger) {
        return (double)(this.func_184188_bt().size() - 1 - this.func_184188_bt().indexOf(passenger)) * 1.5;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public EntityPlayer getDriver() {
        int lastIndex = this.func_184188_bt().size() - 1;
        return this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(lastIndex) instanceof EntityPlayer) ? null : (EntityPlayer)this.func_184188_bt().get(lastIndex);
    }

    static {
        try {
            Class<?> marsConfig = Class.forName("micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars");
            marsConfigAllDimsAllowed = marsConfig.getField("launchControllerAllDims");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

