/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.ACentauriSystem;

import asmodeuscore.api.IBodies;
import asmodeuscore.api.IBodiesHandler;
import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesRegistry;
import galaxyspace.core.proxy.ClientProxy;
import galaxyspace.core.util.GSDimensions;
import galaxyspace.systems.ACentauriSystem.core.ACBlocks;
import galaxyspace.systems.ACentauriSystem.core.configs.ACConfigCore;
import galaxyspace.systems.ACentauriSystem.core.configs.ACConfigDimensions;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.blocks.Proxima_B_Blocks;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.blocks.Proxima_B_Dandelions;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.blocks.Proxima_B_Grass;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.dimension.TeleportTypeProxima_B;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.dimension.WorldProviderProxima_B_WE;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.recipes.CraftingRecipesProximaB;
import java.io.File;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@IBodiesHandler
public class ACentauriSystemBodies
implements IBodies {
    public static SolarSystem aCentauriSystem;
    public static SolarSystem ProximaSystem;
    public static Star aCentauri;
    public static Planet centauri_b;
    public static Star proxima;
    public static Planet proxima_b;
    public static Planet proxima_c;
    public static Planet proxima_d;

    public void preInitialization(FMLPreInitializationEvent event) {
        new ACConfigCore(new File(event.getModConfigurationDirectory(), "GalaxySpace/alpha_centauri/core.conf"));
        new ACConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/alpha_centauri/dimensions.conf"));
    }

    public boolean canRegister() {
        return ACConfigCore.enableACentauriSystems;
    }

    public void preInit(FMLPreInitializationEvent event) {
        aCentauriSystem = BodiesRegistry.registerSolarSystem((String)"galaxyspace", (String)"acentauri", (BodiesRegistry.Galaxies)BodiesRegistry.Galaxies.MILKYWAY, (Vector3)new Vector3(1.5, 0.0, 0.0), (String)"centauri_a", (float)1.3f);
        GalaxyRegistry.registerSolarSystem((SolarSystem)aCentauriSystem);
        centauri_b = BodiesRegistry.registerExPlanet((SolarSystem)aCentauriSystem, (String)"centauri_b", (String)"galaxyspace", (float)0.3f);
        centauri_b.setRingColorRGB(0.0f, 0.0f, 0.0f);
        BodiesRegistry.setOrbitData((CelestialBody)centauri_b, (float)((float)Math.PI), (float)1.5f, (float)1000.0f);
        GalaxyRegistry.registerPlanet((Planet)centauri_b);
        ProximaSystem = BodiesRegistry.registerSolarSystem((String)"galaxyspace", (String)"proxima", (BodiesRegistry.Galaxies)BodiesRegistry.Galaxies.MILKYWAY, (Vector3)new Vector3((double)1.7f, (double)-0.2f, 0.0), (String)"proxima", (float)0.8f);
        GalaxyRegistry.registerSolarSystem((SolarSystem)ProximaSystem);
        proxima_b = BodiesRegistry.registerExPlanet((SolarSystem)ProximaSystem, (String)"proxima_b", (String)"galaxyspace", (float)0.4f);
        BodiesRegistry.setAtmosphere((CelestialBody)proxima_b, (boolean)false, (boolean)true, (boolean)false, (float)-0.05f, (float)0.4f, (float)0.0f);
        BodiesRegistry.setOrbitData((CelestialBody)proxima_b, (float)((float)Math.PI * 3), (float)1.2f, (float)8.0f);
        BodiesRegistry.setPlanetData((CelestialBody)proxima_b, (float)2.0f, (long)175000L, (float)BodiesRegistry.calculateGravity((float)8.0f), (boolean)true);
        BodiesRegistry.setProviderData((CelestialBody)proxima_b, WorldProviderProxima_B_WE.class, (int)ACConfigDimensions.dimensionIDProxima_B, (int)6, (Biome[])new Biome[0]);
        proxima_b.setRingColorRGB(0.0f, 0.4f, 0.9f);
        ACentauriSystemBodies.proxima_b.atmosphere.composition.add(EnumAtmosphericGas.CO2);
        ACentauriSystemBodies.proxima_b.atmosphere.composition.add(EnumAtmosphericGas.OXYGEN);
        if (ACConfigDimensions.enableProxima_B) {
            GalaxyRegistry.registerPlanet((Planet)proxima_b);
        }
        proxima_c = BodiesRegistry.registerExPlanet((SolarSystem)ProximaSystem, (String)"proxima_c", (String)"galaxyspace", (float)1.25f);
        BodiesRegistry.setOrbitData((CelestialBody)proxima_c, (float)1.5707964f, (float)1.5f, (float)150.0f);
        if (ACConfigDimensions.enableProxima_C) {
            GalaxyRegistry.registerPlanet((Planet)proxima_c);
        }
        proxima_d = BodiesRegistry.registerExPlanet((SolarSystem)ProximaSystem, (String)"proxima_d", (String)"galaxyspace", (float)0.25f);
        BodiesRegistry.setOrbitData((CelestialBody)proxima_d, (float)1.0471976f, (float)0.8f, (float)3.0f);
        if (ACConfigDimensions.enableProxima_D) {
            GalaxyRegistry.registerPlanet((Planet)proxima_d);
        }
        ACBlocks.initialize();
        ACentauriSystemBodies.registrycelestial();
        ACentauriSystemBodies.registryteleport();
    }

    public void init(FMLInitializationEvent event) {
    }

    public void postInit(FMLPostInitializationEvent event) {
        GSDimensions.PROXIMA_B = WorldUtil.getDimensionTypeById((int)ACConfigDimensions.dimensionIDProxima_B);
    }

    private static void registrycelestial() {
        BodiesData data = new BodiesData(IAdvancedSpace.TypeBody.STAR).setStarType(IAdvancedSpace.StarType.DWARF).setStarColor(IAdvancedSpace.StarColor.YELLOW);
        BodiesRegistry.registerBodyData((CelestialBody)centauri_b, (BodiesData)data);
        data = new BodiesData(IAdvancedSpace.TypeBody.STAR).setStarType(IAdvancedSpace.StarType.DWARF).setStarColor(IAdvancedSpace.StarColor.YELLOW);
        BodiesRegistry.registerBodyData((CelestialBody)aCentauriSystem.getMainStar(), (BodiesData)data);
        data = new BodiesData(IAdvancedSpace.TypeBody.STAR).setStarType(IAdvancedSpace.StarType.DWARF).setStarColor(IAdvancedSpace.StarColor.ORANGE);
        data.setStarHabitableZone(0.4f, 0.1f);
        BodiesRegistry.registerBodyData((CelestialBody)ProximaSystem.getMainStar(), (BodiesData)data);
    }

    private static void registryteleport() {
        GalacticraftRegistry.registerTeleportType(WorldProviderProxima_B_WE.class, (ITeleportType)new TeleportTypeProxima_B());
    }

    /*
     * WARNING - void declaration
     */
    public void registerRender() {
        void var4_9;
        for (Proxima_B_Blocks.EnumBlockProximaB enumBlockProximaB : Proxima_B_Blocks.EnumBlockProximaB.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)ACBlocks.PROXIMA_B_BLOCKS, (int)enumBlockProximaB.getMeta(), (String)("proxima/" + enumBlockProximaB.func_176610_l()));
        }
        for (Enum enum_ : Proxima_B_Dandelions.EnumBlockDandelions.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)ACBlocks.PROXIMA_B_DANDELIONS, (int)((Proxima_B_Dandelions.EnumBlockDandelions)enum_).getMeta(), (String)("proxima/" + ((Proxima_B_Dandelions.EnumBlockDandelions)enum_).func_176610_l()));
        }
        String[] name = new String[Proxima_B_Grass.EnumBlockGrass.values().length];
        Proxima_B_Grass.EnumBlockGrass[] enumBlockGrassArray = Proxima_B_Grass.EnumBlockGrass.values();
        int n = enumBlockGrassArray.length;
        boolean bl = false;
        while (var4_9 < n) {
            Proxima_B_Grass.EnumBlockGrass blockBasic = enumBlockGrassArray[var4_9];
            if (blockBasic.func_176610_l() != null) {
                name[blockBasic.getMeta()] = blockBasic.func_176610_l();
            }
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)ACBlocks.PROXIMA_B_GRASS, (int)blockBasic.getMeta(), (String)("proxima/" + blockBasic.func_176610_l()));
            ++var4_9;
        }
        ClientUtil.registerBlockJson((String)"galaxyspace:proxima/", (Block)ACBlocks.PROXIMA_B_LOG_1);
        ClientUtil.registerBlockJson((String)"galaxyspace:proxima/", (Block)ACBlocks.PROXIMA_B_LOG_2);
        ClientUtil.registerBlockJson((String)"galaxyspace:proxima/", (Block)ACBlocks.PROXIMA_B_MUSHROOM_LOG);
    }

    public void registerVariant() {
        int i;
        String[] blocks = new String[Proxima_B_Blocks.EnumBlockProximaB.values().length];
        for (i = 0; i < blocks.length; ++i) {
            blocks[i] = Proxima_B_Blocks.EnumBlockProximaB.byMetadata(i).func_176610_l();
        }
        ClientProxy.addVariant("proxima_b_blocks", "proxima/", blocks);
        ClientProxy.addVariant("proxima_b_log_1", "proxima/", "proxima_b_log_1");
        ClientProxy.addVariant("proxima_b_log_2", "proxima/", "proxima_b_log_2");
        ClientProxy.addVariant("proxima_b_mushroom_log", "proxima/", "proxima_b_mushroom_log");
        blocks = new String[Proxima_B_Dandelions.EnumBlockDandelions.values().length];
        for (i = 0; i < blocks.length; ++i) {
            blocks[i] = Proxima_B_Dandelions.EnumBlockDandelions.byMetadata(i).func_176610_l();
        }
        ClientProxy.addVariant("proxima_b_dandelions", "proxima/", blocks);
        blocks = new String[Proxima_B_Grass.EnumBlockGrass.values().length];
        for (i = 0; i < blocks.length; ++i) {
            blocks[i] = Proxima_B_Grass.EnumBlockGrass.byMetadata(i).func_176610_l();
        }
        ClientProxy.addVariant("proxima_b_grasses", "proxima/", blocks);
    }

    public void registerRecipes() {
        CraftingRecipesProximaB.loadRecipes();
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        ACBlocks.oreDictRegistration();
    }
}

