/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.items;

import asmodeuscore.core.utils.ACAttributePlayer;
import galaxyspace.GalaxySpace;
import galaxyspace.core.GSItems;
import galaxyspace.core.GSPotions;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.configs.GSConfigSchematics;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.core.util.GSCreativeTabs;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.items.IClickableItem;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemBasicGS
extends Item
implements ISortableItem {
    public static final int SHIELD_TIME = 600;
    private static final int SIZE = 9;
    public static final int[] FANS_DURABILITY = new int[]{1800, 5400, 21600, 64800};

    public static String[] getEnumNames() {
        String[] s = new String[BasicItems.values().length];
        for (int i = 0; i < BasicItems.values().length; ++i) {
            s[i] = BasicItems.values()[i].getName();
        }
        return s;
    }

    public ItemBasicGS() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(64);
        this.func_77655_b("gs_basic");
        this.func_77637_a((CreativeTabs)GSCreativeTabs.GSItemsTab);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == GSCreativeTabs.GSItemsTab || tab == CreativeTabs.field_78027_g) {
            for (int i = 0; i < BasicItems.values().length; ++i) {
                if (BasicItems.values()[i].getMeta() == BasicItems.GAS_EXTRACTOR.getMeta() || BasicItems.values()[i].getName().equals("null")) continue;
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        int n = stack.func_77952_i();
        if (n == BasicItems.GAS_EXTRACTOR.getMeta()) {
            stack.func_190918_g(1);
            worldIn.func_72838_d((Entity)new EntityItem(worldIn, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, new ItemStack(GSItems.GAS_EXTRACTOR, 1, GSItems.GAS_EXTRACTOR.func_77612_l())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flagIn) {
        int n = stack.func_77952_i();
        if (n == BasicItems.DOLOMITE_MEAL.getMeta()) {
            list.add(GCCoreUtil.translate((String)"gui.bonemeal.desc"));
        } else if (n == BasicItems.SCHEMATIC_BOX.getMeta()) {
            list.add(GCCoreUtil.translate((String)"gui.schematic_box.desc"));
        } else if (n == BasicItems.BLANK_SCHEMATIC.getMeta() && !GSConfigSchematics.enableDuplicateSchematic) {
            list.add(EnumColor.DARK_RED + "Disabled in config.");
        } else if (n == BasicItems.TEMP_SHIELD_CONTROL.getMeta()) {
            int shieldtime;
            int time = 600;
            time = stack.func_77942_o() ? (shieldtime = stack.func_77978_p().func_74762_e("shieldtime")) : 600;
            list.add(GCCoreUtil.translate((String)"gui.temp_shield_control.desc"));
            list.add(GCCoreUtil.translate((String)"gui.message.can_find_in_dungeon"));
            list.add(GCCoreUtil.translate((String)"gui.charge") + " " + time + " " + GCCoreUtil.translate((String)"gui.seconds"));
        } else if (n == BasicItems.EMERGENCY_PORTABLE_TELEPORT.getMeta()) {
            list.add(GCCoreUtil.translate((String)"gui.emergency_portable_teleport.desc"));
            list.add(GCCoreUtil.translate((String)"gui.message.can_find_in_dungeon"));
            list.add("");
            if (stack.func_77942_o()) {
                if (stack.func_77978_p().func_74759_k("position").length <= 0) {
                    list.add(GCCoreUtil.translate((String)"gui.not_attached.desc"));
                } else {
                    int[] pos = stack.func_77978_p().func_74759_k("position");
                    list.add(GCCoreUtil.translate((String)"gui.attached.desc") + " DIM:" + pos[3] + " X:" + pos[0] + ", Y:" + pos[1] + ", Z:" + pos[2]);
                }
                if (stack.func_77978_p().func_74767_n("turnonoff")) {
                    list.add(GCCoreUtil.translate((String)"gui.enabled.desc"));
                }
            }
        } else if (n == BasicItems.EMPTY_PLASMA_CELL.getMeta() || n == BasicItems.FILLED_PLASMA_CELL.getMeta()) {
            list.add(EnumColor.DARK_RED + "[WIP] Content");
        } else if (n == BasicItems.ANIMAL_CAGE.getMeta()) {
            list.add(GCCoreUtil.translate((String)"gui.animal_cage.desc"));
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("entityData")) {
                Entity entity = EntityList.func_75615_a((NBTTagCompound)stack.func_77978_p().func_74775_l("entityData"), (World)world);
                list.add(GCCoreUtil.translate((String)"gui.animal_cage_stored.desc") + " " + EnumColor.BRIGHT_GREEN + entity.func_145748_c_().func_150254_d());
            }
        } else if (n >= 33 && n <= 36 && stack.func_77942_o() && stack.func_77978_p().func_74764_b("destroyedLvl")) {
            list.add("Durability: " + (FANS_DURABILITY[n - 33] - stack.func_77978_p().func_74762_e("destroyedLvl")) + " / " + FANS_DURABILITY[n - 33]);
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() == BasicItems.THERMAL_CLOTH_T3.getMeta() || stack.func_77952_i() == BasicItems.THERMAL_CLOTH_T4.getMeta()) {
            return "item.thermal_cloth";
        }
        int meta = stack.func_77952_i() > BasicItems.values().length - 1 ? 0 : stack.func_77952_i();
        return "item." + BasicItems.values()[meta].getName();
    }

    public int func_77647_b(int par1) {
        return par1;
    }

    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.GENERAL;
    }

    public int getItemStackLimit(ItemStack stack) {
        int n = stack.func_77952_i();
        for (BasicItems item : BasicItems.values()) {
            if (item.getMeta() != n) continue;
            return item.getMaxStackSize();
        }
        return this.func_77639_j();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (stack.func_77952_i() == BasicItems.ICE_BUCKET.getMeta()) {
            Block block;
            RayTraceResult ray = this.func_77621_a(world, player, false);
            if (ray != null && !world.field_72995_K && stack.func_77942_o() && stack.func_77978_p().func_74764_b("current_block") && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("current_block")))) != null) {
                world.func_175656_a(ray.func_178782_a().func_177984_a(), block.func_176223_P());
                return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(Items.field_151133_ar));
            }
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (stack.func_77952_i() == BasicItems.DOLOMITE_MEAL.getMeta()) {
            RayTraceResult ray = ItemBasicGS.getRay(world, player, true);
            if (ray != null && ItemDye.applyBonemeal((ItemStack)stack, (World)world, (BlockPos)ray.func_178782_a(), (EntityPlayer)player, (EnumHand)hand)) {
                if (!world.field_72995_K) {
                    world.func_175718_b(2005, ray.func_178782_a(), 0);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
            }
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (stack.func_77952_i() == 6) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (stack.func_77952_i() == BasicItems.GUIDE_BOOK.getMeta()) {
            player.openGui((Object)"galaxyspace", GSConfigCore.guiIDGuideBook, world, 0, 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (stack.func_77952_i() == BasicItems.ANTIRADIATION_TABLETS.getMeta()) {
            IAttributeInstance lvl = player.func_110148_a(ACAttributePlayer.RADIATION_LVL);
            if (lvl.func_111126_e() > 0.0) {
                player.func_70690_d(new PotionEffect((Potion)GSPotions.antiradiation, 200));
                stack.func_190918_g(1);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
            }
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_GREEN + GCCoreUtil.translate((String)"gui.message.noradiation")));
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (stack.func_77952_i() == BasicItems.SCHEMATIC_BOX.getMeta()) {
            for (int i = 0; i < 5; ++i) {
                if (player.field_71071_by.func_70447_i() != -1) {
                    player.field_71071_by.func_70441_a(new ItemStack(GSItems.SCHEMATICS, 1, i));
                    continue;
                }
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(GSItems.SCHEMATICS, 1, i)));
            }
            stack.func_190918_g(1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (stack.func_77952_i() == BasicItems.EMERGENCY_PORTABLE_TELEPORT.getMeta()) {
            RayTraceResult ray;
            Block block;
            if (!player.func_70093_af()) {
                return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
            }
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((block = world.func_180495_p((ray = player.func_174822_a(5.0, (float)player.field_70173_aa)).func_178782_a()).func_177230_c()) == AsteroidBlocks.shortRangeTelepad) {
                TileEntityShortRangeTelepad tile = (TileEntityShortRangeTelepad)world.func_175625_s(ray.func_178782_a());
                if (tile.hasEnoughEnergyToRun && tile.addressValid) {
                    stack.func_77978_p().func_74783_a("position", new int[]{ray.func_178782_a().func_177958_n(), ray.func_178782_a().func_177956_o(), ray.func_178782_a().func_177952_p(), world.field_73011_w.getDimension()});
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + GCCoreUtil.translate((String)"gui.message.invalid_teleport_conf")));
                }
            } else {
                stack.func_77978_p().func_74757_a("turnonoff", !stack.func_77978_p().func_74767_n("turnonoff"));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (stack.func_77952_i() == BasicItems.ADVANCED_EMERGENCY_KIT.getMeta()) {
            if (player instanceof EntityPlayerMP) {
                for (int i = 0; i < 9; ++i) {
                    ItemStack newGear = ItemBasicGS.getContents(i);
                    if (newGear.func_77973_b() instanceof IClickableItem) {
                        newGear = ((IClickableItem)newGear.func_77973_b()).onItemRightClick(newGear, world, player);
                    }
                    if (newGear.func_190916_E() < 1) continue;
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)newGear, (int)0);
                }
                stack.func_190918_g(1);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        } else if (stack.func_77952_i() == BasicItems.COLONIST_KIT.getMeta()) {
            if (player instanceof EntityPlayerMP) {
                ItemStack[] stacks;
                for (ItemStack items : stacks = new ItemStack[]{new ItemStack(GCBlocks.oxygenDistributor, 1), new ItemStack(GCBlocks.oxygenCollector, 1), new ItemStack(GCBlocks.oxygenCompressor, 1), new ItemStack(GCBlocks.solarPanel, 1, 4), new ItemStack(GSItems.BASIC, 1, 20), new ItemStack(GCBlocks.solarPanel, 1, 4), new ItemStack(GCBlocks.machineTiered, 1, 0), new ItemStack(MarsBlocks.machine, 1, 0), new ItemStack(GCBlocks.machineBase2, 1, 8)}) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)items, (int)0);
                }
                stack.func_190918_g(1);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        } else if (stack.func_77952_i() == BasicItems.ANIMAL_CAGE.getMeta()) {
            Entity entity;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b("hasMob")) {
                stack.func_77978_p().func_74757_a("hasMob", false);
            }
            if (!stack.func_77978_p().func_74764_b("destroyedLvl")) {
                stack.func_77978_p().func_74768_a("destroyedLvl", 0);
            }
            if (!stack.func_77978_p().func_74767_n("hasMob")) {
                if (player instanceof EntityPlayerMP) {
                    GalaxySpace.packetPipeline.sendTo((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.C_GET_CAGE_ENTITY, GCCoreUtil.getDimensionID((World)player.field_70170_p), new Object[0]), (EntityPlayerMP)player);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
            }
            RayTraceResult result = ItemBasicGS.getRay(world, player, false);
            if (result != null && result.field_72313_a != null && result.field_72313_a == RayTraceResult.Type.BLOCK && stack.func_77978_p().func_74764_b("entityData") && (entity = EntityList.func_75615_a((NBTTagCompound)stack.func_77978_p().func_74775_l("entityData"), (World)player.field_70170_p)) instanceof EntityAnimal) {
                BlockPos pos = result.func_178782_a();
                entity.field_71093_bK = player.field_71093_bK;
                entity.field_70170_p = player.field_70170_p;
                entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p());
                if (!world.field_72995_K) {
                    world.func_72838_d(entity);
                }
                entity = null;
                stack.func_77978_p().func_74757_a("hasMob", false);
                stack.func_77978_p().func_82580_o("entityData");
                if (stack.func_77978_p().func_74762_e("destroyedLvl") < 2) {
                    stack.func_77978_p().func_74768_a("destroyedLvl", stack.func_77978_p().func_74762_e("destroyedLvl") + 1);
                } else {
                    stack.func_77979_a(1);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("destroyedLvl")) {
            return stack.func_77978_p().func_74762_e("destroyedLvl") >= 0;
        }
        return stack.func_77951_h();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77952_i() == BasicItems.ANIMAL_CAGE.getMeta() && stack.func_77942_o()) {
            return (double)stack.func_77978_p().func_74762_e("destroyedLvl") / 10.0 / 0.31;
        }
        if (stack.func_77952_i() >= 33 && stack.func_77952_i() < 37 && stack.func_77942_o()) {
            return (double)stack.func_77978_p().func_74762_e("destroyedLvl") / (double)FANS_DURABILITY[stack.func_77952_i() - 33];
        }
        return (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }

    public static Object[] getColonistKitRecipe() {
        ItemStack[] stacks = new ItemStack[]{new ItemStack(GCBlocks.oxygenDistributor, 1), new ItemStack(GCBlocks.oxygenCollector, 1), new ItemStack(GCBlocks.oxygenCompressor, 1), new ItemStack(GCBlocks.solarPanel, 1, 4), new ItemStack(GSItems.BASIC, 1, 20), new ItemStack(GCBlocks.solarPanel, 1, 4), new ItemStack(GCBlocks.machineTiered, 1, 0), new ItemStack(MarsBlocks.machine, 1, 0), new ItemStack(GCBlocks.machineBase2, 1, 8)};
        Object[] result = new Object[]{"ABC", "DEF", "GHI", Character.valueOf('A'), null, Character.valueOf('B'), null, Character.valueOf('C'), null, Character.valueOf('D'), null, Character.valueOf('E'), null, Character.valueOf('F'), null, Character.valueOf('G'), null, Character.valueOf('H'), null, Character.valueOf('I'), null};
        for (int i = 0; i < stacks.length; ++i) {
            result[i * 2 + 4] = stacks[i];
        }
        return result;
    }

    public static ItemStack getContents(int slot) {
        switch (slot) {
            case 0: {
                return new ItemStack(GSItems.SPACE_SUIT_HELMET, 1, GSItems.SPACE_SUIT_HELMET.func_77612_l());
            }
            case 1: {
                return new ItemStack(GSItems.SPACE_SUIT_BODY, 1, GSItems.SPACE_SUIT_BODY.func_77612_l());
            }
            case 2: {
                return new ItemStack(GSItems.SPACE_SUIT_LEGGINS, 1, GSItems.SPACE_SUIT_LEGGINS.func_77612_l());
            }
            case 3: {
                return new ItemStack(GSItems.SPACE_SUIT_BOOTS, 1, GSItems.SPACE_SUIT_BOOTS.func_77612_l());
            }
            case 4: {
                return new ItemStack(AsteroidsItems.thermalPadding, 1, 0);
            }
            case 5: {
                return new ItemStack(AsteroidsItems.thermalPadding, 1, 1);
            }
            case 6: {
                return new ItemStack(AsteroidsItems.thermalPadding, 1, 2);
            }
            case 7: {
                return new ItemStack(AsteroidsItems.thermalPadding, 1, 3);
            }
            case 8: {
                return new ItemStack(GCItems.emergencyKit, 1, 0);
            }
        }
        return null;
    }

    public static Object[] getRecipe() {
        Object[] result = new Object[]{"EAB", "CID", "FGH", Character.valueOf('A'), null, Character.valueOf('B'), null, Character.valueOf('C'), null, Character.valueOf('D'), null, Character.valueOf('E'), null, Character.valueOf('F'), null, Character.valueOf('G'), null, Character.valueOf('H'), null, Character.valueOf('I'), null};
        for (int i = 0; i < 9; ++i) {
            result[i * 2 + 4] = ItemBasicGS.getContents(i);
        }
        return result;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        if (itemStack.func_77952_i() == BasicItems.VOLCANIC_STONE.getMeta()) {
            return 128000;
        }
        return -1;
    }

    public static RayTraceResult getRay(World world, EntityPlayer player, boolean useLiquids) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        double d0 = player.field_70165_t;
        double d1 = player.field_70163_u + (double)player.func_70047_e();
        double d2 = player.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() + 10.0;
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return world.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }

    public static enum BasicItems {
        MODULE_SMALLCANISTER(0),
        PART_SOLARFLARES(1),
        SOLARFLARES(2),
        DOLOMITE_CRYSTAL(3),
        DOLOMITE_MEAL(4),
        WAFER_MODERN(5),
        HEMATITE(6),
        SULFUR(7),
        UNKNOW_CRYSTAL(8),
        ANTIRADIATION_TABLETS(9),
        SCHEMATIC_BOX(10),
        MODULE_BASE(11),
        VOLCANIC_STONE(12),
        METEORIC_IRON_FRAGMENTS(13),
        BLANK_SCHEMATIC(14),
        URANIUM_FRAGMENTS(15),
        TEMP_SHIELD_CONTROL(16, 1),
        ICE_BUCKET(17, 1),
        EMERGENCY_PORTABLE_TELEPORT(18, 1),
        GUIDE_BOOK(19, 1),
        ADVANCED_EMERGENCY_KIT(20),
        THERMAL_CLOTH_T3(21),
        THERMAL_CLOTH_T4(22),
        OXYGEN_ICE_CRYSTAL(23),
        NITROGEN_ICE_CRYSTAL(24),
        METHANE_ICE_CRYSTAL(25),
        HYDROGEN_ICE_CRYSTAL(26),
        DRY_ICE_CRYSTAL(27),
        COLONIST_KIT(28),
        EMPTY_PLASMA_CELL(29),
        FILLED_PLASMA_CELL(30),
        WOLF_THERMAL_SUIT(31, 1),
        ANIMAL_CAGE(32, 1),
        IRON_FAN(33, 1),
        STEEL_FAN(34, 1),
        PLASTIC_FAN(35, 1),
        CARBON_FAN(36, 1),
        RAW_PLASTIC(37),
        PLASTIC(38),
        GAS_EXTRACTOR(39, 1);

        private int meta;
        private int stacksize;

        private BasicItems(int meta) {
            this(meta, 64);
        }

        private BasicItems(int meta, int stacksize) {
            this.meta = meta;
            this.stacksize = stacksize;
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public ItemStack getItemStack() {
            return this.getItemStack(1);
        }

        public ItemStack getItemStack(int count) {
            return new ItemStack(GSItems.BASIC, count, this.meta);
        }

        public int getMeta() {
            return this.meta;
        }

        public int getMaxStackSize() {
            return this.stacksize;
        }
    }
}

