/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.items.tools;

import galaxyspace.api.item.IModificationItem;
import galaxyspace.core.GSFluids;
import galaxyspace.core.GSItems;
import galaxyspace.core.prefab.items.modules.ItemModule;
import galaxyspace.core.util.GSCreativeTabs;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemBasicGS;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemSpaceSuit;
import galaxyspace.systems.SolarSystem.planets.overworld.items.modules.Energy;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Keyboard;

public class ItemGasExtractor
extends ItemElectricBase
implements ISortableItem,
IModificationItem {
    private static final int DISCHARGE_COUNT = 100;

    public ItemGasExtractor() {
        this.func_77655_b("gas_extractor");
        this.func_77627_a(true);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b(ItemSpaceSuit.mod_count)) {
            stack.func_77978_p().func_74768_a(ItemSpaceSuit.mod_count, this.getModificationCount(stack));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == GSCreativeTabs.GSArmorTab || tab == CreativeTabs.field_78027_g) {
            list.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        tooltip.add(GCCoreUtil.translate((String)"gui.gas_extractor.desc"));
        tooltip.add("");
        tooltip.add(EnumColor.GREY + GCCoreUtil.translate((String)"gui.module.available_modules") + " " + itemStack.func_77978_p().func_74762_e(ItemSpaceSuit.mod_count));
        tooltip.add("");
        tooltip.add(EnumColor.AQUA + GCCoreUtil.translate((String)"gui.module.list"));
        if (Keyboard.isKeyDown((int)42)) {
            for (ItemModule s : this.getAvailableModules()) {
                if (!itemStack.func_77978_p().func_74764_b(s.getName())) continue;
                tooltip.addAll(FMLClientHandler.instance().getClient().field_71466_p.func_78271_c(this.check(itemStack, s.getName()) + GCCoreUtil.translate((String)("gui.module." + s.getName())), 150));
            }
        } else {
            tooltip.add(EnumColor.DARK_AQUA + GCCoreUtil.translateWithFormat((String)"item_desc.shift.name", (Object[])new Object[]{GameSettings.func_74298_c((int)FMLClientHandler.instance().getClient().field_71474_y.field_74311_E.func_151463_i())}));
        }
        tooltip.add("");
        super.func_77624_a(itemStack, worldIn, tooltip, flagIn);
    }

    private String check(ItemStack stack, String nbt) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n(nbt)) {
            return TextFormatting.DARK_GREEN + "- ";
        }
        return TextFormatting.DARK_RED + "- ";
    }

    public float getMaxElectricityStored(ItemStack stack) {
        boolean energy = stack.func_77942_o() && stack.func_77978_p().func_74764_b("energy");
        return energy ? 18000.0f : 6000.0f;
    }

    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.TOOLS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (this.getElectricityStored(stack) < 100.0f) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        RayTraceResult result = ItemBasicGS.getRay(world, player, true);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(result.func_178782_a()).func_177230_c() == GSFluids.BLOCK_NATURE_GAS && this.tryFillCanister(player, new FluidStack(GSFluids.NatureGas, 200))) {
            player.field_71069_bz.func_75142_b();
            world.func_175698_g(result.func_178782_a());
            if (!player.field_71075_bZ.field_75098_d) {
                this.discharge(stack, 100.0f, true);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    private boolean tryFillCanister(EntityPlayer player, FluidStack fluid) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (!(stack.func_77973_b() instanceof ItemCanisterGeneric)) continue;
            if (stack.func_77973_b() == GSItems.NATURE_GAS_CANISTER && stack.func_77952_i() > 1) {
                if (stack.func_77952_i() - fluid.amount > 1) {
                    stack.func_77964_b(stack.func_77952_i() - fluid.amount);
                } else {
                    stack.func_77964_b(1);
                }
                player.field_71071_by.func_70299_a(i, stack);
                return true;
            }
            if (stack.func_77973_b() != GCItems.oilCanister || stack.func_77952_i() != 1001) continue;
            stack = new ItemStack(GSItems.NATURE_GAS_CANISTER, 1, stack.func_77958_k() - fluid.amount);
            player.field_71071_by.func_70299_a(i, stack);
            return true;
        }
        return false;
    }

    @Override
    public GSUtils.Module_Type getType(ItemStack stack) {
        return GSUtils.Module_Type.TOOLS;
    }

    @Override
    public ItemModule[] getAvailableModules() {
        return new ItemModule[]{new Energy()};
    }

    @Override
    public int getModificationCount(ItemStack stack) {
        return 1;
    }
}

