/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.render.tile;

import asmodeuscore.core.utils.Utils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import galaxyspace.systems.SolarSystem.planets.overworld.models.ModelWindTurbine;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityWindGenerator;
import java.util.List;
import micdoodle8.mods.galacticraft.core.client.model.OBJLoaderGC;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import org.lwjgl.opengl.GL11;

public class TileEntityWindGeneratorRenderer
extends TileEntitySpecialRenderer<TileEntityWindGenerator> {
    private static final ResourceLocation windTurbineTexture = new ResourceLocation("galaxyspace", "textures/model/wind_turbine.png");
    public ModelWindTurbine model = new ModelWindTurbine();
    private OBJModel.OBJBakedModel cube;
    private OBJModel.OBJBakedModel hexadecagon;

    private void updateModels() {
        if (this.cube == null) {
            try {
                IModel model = OBJLoaderGC.instance.loadModel(new ResourceLocation("galaxyspace", "windmill_straight.obj"));
                Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                this.cube = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"cube"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.hexadecagon = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"hexadecagon"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void render(TileEntityWindGenerator wind, double x, double y, double z, float partialTickTime, int par9, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179101_C();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        wind.angle = Math.min(wind.angle + (float)wind.func_174877_v().func_177956_o() / 500.0f * (wind.getWindBoost() * 10.0f), wind.angle + 15.0f) % 360.0f;
        if (wind.isAdvanced()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.48f));
            this.func_147499_a(TextureMap.field_110575_b);
            this.updateModels();
            GlStateManager.func_179139_a((double)2.0, (double)1.0, (double)2.0);
            ClientUtil.drawBakedModel((IBakedModel)this.hexadecagon);
            GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
            ClientUtil.drawBakedModel((IBakedModel)this.hexadecagon);
            if (wind.getFanType() >= 0) {
                GL11.glRotatef((float)wind.angle, (float)0.0f, (float)1.0f, (float)0.0f);
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                switch (wind.getFanType()) {
                    case 0: {
                        r = 0.6f;
                        g = 0.6f;
                        b = 0.65f;
                        break;
                    }
                    case 1: {
                        r = 0.3f;
                        g = 0.3f;
                        b = 0.4f;
                        break;
                    }
                    case 2: {
                        r = 1.0f;
                        g = 1.0f;
                        b = 1.0f;
                        break;
                    }
                    case 3: {
                        r = 0.15f;
                        g = 0.15f;
                        b = 0.15f;
                    }
                }
                int i_r = (int)(255.0f * r);
                int i_g = (int)(255.0f * g);
                int i_b = (int)(255.0f * b);
                ClientUtil.drawBakedModelColored((IBakedModel)this.cube, (int)Utils.getIntColorWHC((int)i_r, (int)i_g, (int)i_b, (int)255));
            }
        } else {
            this.func_147499_a(windTurbineTexture);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            GL11.glTranslatef((float)0.49f, (float)3.3f, (float)0.48f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(wind.func_145832_p() * 90 + 90), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.87f, (float)0.87f, (float)0.87f);
            this.model.renderPole(0.0625f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)wind.angle, (float)0.0f, (float)0.0f, (float)1.0f);
            if (wind.getFanType() >= 0) {
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                switch (wind.getFanType()) {
                    case 0: {
                        r = 0.6f;
                        g = 0.6f;
                        b = 0.65f;
                        break;
                    }
                    case 1: {
                        r = 0.3f;
                        g = 0.3f;
                        b = 0.4f;
                        break;
                    }
                    case 2: {
                        r = 1.0f;
                        g = 1.0f;
                        b = 1.0f;
                        break;
                    }
                    case 3: {
                        r = 0.15f;
                        g = 0.15f;
                        b = 0.15f;
                    }
                }
                GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
                this.model.renderFlares(0.0625f);
            }
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }
}

