/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import javax.annotation.Nullable;
import mekanism.api.energy.IEnergizedItem;
import micdoodle8.mods.galacticraft.api.item.IItemElectricBase;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityEnergyPad
extends TileBaseElectricBlockWithInventory {
    public static int PROCESS_TIME_REQUIRED = 130;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = 1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public static int processTicks = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean isCollide;

    public TileEntityEnergyPad() {
        super("tile.energy_pad.name");
        this.storage.setCapacity(15000.0f);
        this.storage.setMaxExtract(0.0f);
        this.storage.setMaxReceive(500.0f);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_73012_v.nextInt(4) == 0) {
            this.field_145850_b.func_175679_n(this.func_174877_v());
        }
        if (this.canProcess() && !this.disabled && !this.hasEnoughEnergyToRun) {
            this.isCollide = false;
        }
    }

    public void slowDischarge() {
    }

    public static boolean canProcess() {
        return true;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public void smeltItem(EntityPlayer player) {
        if (this.hasEnoughEnergyToRun && (double)this.storage.getEnergyStoredGC() > 200.0) {
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (!this.chargeItem(stack, 350.0)) continue;
                this.storage.extractEnergyGCnoMax(200.0f, false);
                break;
            }
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (!this.chargeItem(stack, 350.0)) continue;
                this.storage.extractEnergyGCnoMax(200.0f, false);
                break;
            }
        }
        this.isCollide = this.isCollideTile(player);
    }

    private boolean isCollideTile(@Nullable EntityPlayer player) {
        return player != null && this.hasEnoughEnergyToRun && player.func_180425_c().equals((Object)this.func_174877_v());
    }

    private boolean chargeItem(ItemStack stack, double count) {
        IItemElectricBase item;
        if (stack.func_77973_b() instanceof IItemElectricBase && (item = (IItemElectricBase)stack.func_77973_b()).getElectricityStored(stack) < item.getMaxElectricityStored(stack)) {
            item.recharge(stack, (float)count, true);
            return true;
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && stack.func_77973_b() instanceof IElectricItem && ElectricItem.manager.getCharge(stack) < ElectricItem.manager.getMaxCharge(stack)) {
            ElectricItem.manager.charge(stack, count, 4, false, false);
            return true;
        }
        if (EnergyConfigHandler.isMekanismLoaded() && stack.func_77973_b() instanceof IEnergizedItem && (item = (IEnergizedItem)stack.func_77973_b()).getEnergy(stack) < item.getMaxEnergy(stack)) {
            item.setEnergy(stack, item.getEnergy(stack) + count);
            return true;
        }
        if (EnergyConfigHandler.isRFAPILoaded() && stack.func_77973_b() instanceof IEnergyContainerItem && (item = (IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) < item.getMaxEnergyStored(stack)) {
            item.extractEnergy(stack, (int)count, false);
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.isCollide = par1NBTTagCompound.func_74767_n("isCollide");
        ItemStackHelper.func_191283_b((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", processTicks);
        par1NBTTagCompound.func_74757_a("isCollide", this.isCollide);
        ItemStackHelper.func_191282_a((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        return par1NBTTagCompound;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return true;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public EnumFacing getFront() {
        return EnumFacing.DOWN;
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.DOWN;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return null;
    }
}

