/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.world.gen;

import galaxyspace.core.GSBlocks;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.BlockOres;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class NickelGenerator
implements IWorldGenerator {
    private final IBlockState asteroidBlock = AsteroidBlocks.blockBasic.func_176203_a(0);
    private final IBlockState nickelBlock = GSBlocks.OVERWORLD_ORES.func_176223_P().func_177226_a(BlockOres.BASIC_TYPE, (Comparable)((Object)BlockOres.EnumBlockOres.NICKEL));
    private final IBlockState copperBlock = GCBlocks.basicBlock.func_176203_a(5);
    private final int maxGenerateLevel = 40;
    private final int minGenerateLevel = 5;
    byte[][][] MATRIX = new byte[][][]{new byte[][]{{0, 0, 0, 0}, {0, 1, 1, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}}, new byte[][]{{0, 1, 1, 0}, {1, 2, 2, 1}, {1, 3, 2, 1}, {0, 1, 1, 0}}, new byte[][]{{1, 1, 1, 0}, {1, 2, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}}, new byte[][]{{0, 1, 0, 0}, {1, 1, 1, 0}, {0, 1, 0, 0}, {0, 0, 0, 0}}};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0 && random.nextInt(100) < 85) {
            int x = chunkX * 16 + random.nextInt(16) + 8;
            int z = chunkZ * 16 + random.nextInt(16) + 8;
            int y = random.nextInt(Math.max(this.maxGenerateLevel - this.minGenerateLevel, 0)) + this.minGenerateLevel;
            BlockPos pos = new BlockPos(x, y, z);
            this.generateOre(world, random, pos);
        }
    }

    private boolean generateOre(World world, Random rand, BlockPos pos) {
        for (int py = 0; py < this.MATRIX.length; ++py) {
            for (int px = 0; px < this.MATRIX[py].length; ++px) {
                for (int pz = 0; pz < this.MATRIX[py][px].length; ++pz) {
                    int px2 = px;
                    int py2 = py;
                    int pz2 = pz;
                    px2 -= this.MATRIX[py].length / 2;
                    pz2 -= this.MATRIX[py][px].length / 2;
                    byte matrix1 = this.MATRIX[py][px][pz];
                    switch (rand.nextInt(4)) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            matrix1 = this.MATRIX[py][pz][px];
                            break;
                        }
                        case 2: {
                            matrix1 = this.MATRIX[py][this.MATRIX[py].length - 1 - px][this.MATRIX[py][px].length - 1 - pz];
                            break;
                        }
                        case 3: {
                            matrix1 = this.MATRIX[py][this.MATRIX[py][px].length - 1 - pz][this.MATRIX[py].length - 1 - px];
                        }
                    }
                    this.generateBlock(world, rand, new BlockPos(pos.func_177958_n() + px2, pos.func_177956_o() + py2, pos.func_177952_p() + pz2), matrix1);
                }
            }
        }
        return true;
    }

    protected void generateBlock(World world, Random random, BlockPos position, int matrixValue) {
        IBlockState rand_block;
        IBlockState iBlockState = rand_block = random.nextBoolean() ? this.copperBlock : this.nickelBlock;
        if (!world.func_180495_p(position).func_185915_l()) {
            return;
        }
        switch (matrixValue) {
            case 1: {
                world.func_175656_a(position, this.asteroidBlock);
                break;
            }
            case 2: {
                world.func_175656_a(position, this.nickelBlock);
                break;
            }
            case 3: {
                world.func_175656_a(position, rand_block);
                break;
            }
        }
    }
}

