/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd;

import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.BlockTypes;
import lach_01298.qmd.enums.ICoolerEnum;
import nc.util.InfoHelper;
import nc.util.Lang;
import nc.util.UnitHelper;

public class QMDInfo {
    public static String[][] RFCavityFixedInfo() {
        BlockTypes.RFCavityType[] values = BlockTypes.RFCavityType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = new String[]{Lang.localise((String)"info.qmd.rf_cavity.voltage", (Object[])new Object[]{values[i].getVoltage()}), Lang.localise((String)"info.qmd.item.efficiency", (Object[])new Object[]{Math.round(100.0 * values[i].getEfficiency()) + "%"}), Lang.localise((String)"info.qmd.item.heat", (Object[])new Object[]{values[i].getHeatGenerated()}), Lang.localise((String)"info.qmd.item.power", (Object[])new Object[]{values[i].getBasePower()}), Lang.localise((String)"info.qmd.item.max_temp", (Object[])new Object[]{values[i].getMaxOperatingTemp()})};
        }
        return info;
    }

    public static String[][] RFCavityInfo() {
        BlockTypes.RFCavityType[] values = BlockTypes.RFCavityType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = InfoHelper.formattedInfo((String)Lang.localise((String)"tile.qmd.rf_cavity.desc"), (Object[])new Object[0]);
        }
        return info;
    }

    public static String[][] magnetFixedInfo() {
        BlockTypes.MagnetType[] values = BlockTypes.MagnetType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = new String[]{Lang.localise((String)"info.qmd.accelerator_magnet.strength", (Object[])new Object[]{values[i].getStrength()}), Lang.localise((String)"info.qmd.item.efficiency", (Object[])new Object[]{Math.round(100.0 * values[i].getEfficiency()) + "%"}), Lang.localise((String)"info.qmd.item.heat", (Object[])new Object[]{values[i].getHeatGenerated()}), Lang.localise((String)"info.qmd.item.power", (Object[])new Object[]{values[i].getBasePower()}), Lang.localise((String)"info.qmd.item.max_temp", (Object[])new Object[]{values[i].getMaxOperatingTemp()})};
        }
        return info;
    }

    public static String[][] magnetInfo() {
        BlockTypes.MagnetType[] values = BlockTypes.MagnetType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = InfoHelper.formattedInfo((String)Lang.localise((String)"tile.qmd.accelerator_magnet.desc"), (Object[])new Object[0]);
        }
        return info;
    }

    public static String[][] cooler1FixedInfo() {
        return QMDInfo.coolerFixedInfo((Enum[])BlockTypes.CoolerType1.values());
    }

    public static String[][] cooler2FixedInfo() {
        return QMDInfo.coolerFixedInfo((Enum[])BlockTypes.CoolerType2.values());
    }

    private static <T extends Enum<T> & ICoolerEnum> String[][] coolerFixedInfo(T[] values) {
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = new String[]{QMDInfo.coolerCoolingRateString(values[i])};
        }
        return info;
    }

    private static <T extends Enum<T>> String coolerCoolingRateString(T type) {
        return Lang.localise((String)"tile.qmd.accelerator.cooler.cooling_rate") + " " + ((ICoolerEnum)((Object)type)).getHeatRemoved() + " H/t";
    }

    public static String[][] cooler1Info() {
        BlockTypes.CoolerType1[] values = BlockTypes.CoolerType1.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = InfoHelper.formattedInfo((String)QMDInfo.cooler1InfoString(values[i]), (Object[])new Object[0]);
        }
        return info;
    }

    private static String cooler1InfoString(BlockTypes.CoolerType1 type) {
        return Lang.localise((String)("tile.qmd.accelerator.cooler." + type.func_176610_l() + ".desc"));
    }

    public static String[][] cooler2Info() {
        BlockTypes.CoolerType2[] values = BlockTypes.CoolerType2.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = InfoHelper.formattedInfo((String)QMDInfo.cooler2InfoString(values[i]), (Object[])new Object[0]);
        }
        return info;
    }

    private static String cooler2InfoString(BlockTypes.CoolerType2 type) {
        return Lang.localise((String)("tile.qmd.accelerator.cooler." + type.func_176610_l() + ".desc"));
    }

    public static String[][] detectorFixedInfo() {
        BlockTypes.DetectorType[] values = BlockTypes.DetectorType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = new String[]{Lang.localise((String)"info.qmd.particle_chamber.detector.efficiency", (Object[])new Object[]{(double)Math.round(1000.0 * values[i].getEfficiency()) / 10.0 + "%"}), Lang.localise((String)"info.qmd.particle_chamber.detector.power", (Object[])new Object[]{values[i].getBasePower()})};
        }
        return info;
    }

    public static String[][] detectorInfo() {
        BlockTypes.DetectorType[] values = BlockTypes.DetectorType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = InfoHelper.formattedInfo((String)QMDInfo.detectorInfoString(values[i]), (Object[])new Object[0]);
        }
        return info;
    }

    public static String[] ionSourceFixedInfo(int id) {
        String[] info = new String[]{Lang.localise((String)"info.qmd.item.power", (Object[])new Object[]{QMDConfig.ion_source_power[id]}), Lang.localise((String)"info.qmd.ion_source.output_multiplier", (Object[])new Object[]{QMDConfig.ion_source_output_multiplier[id]}), Lang.localise((String)"info.qmd.ion_source.focus", (Object[])new Object[]{QMDConfig.ion_source_focus[id]})};
        return info;
    }

    public static String ionSourceInfo() {
        return Lang.localise((String)"tile.qmd.ion_source.desc");
    }

    private static String detectorInfoString(BlockTypes.DetectorType type) {
        return Lang.localise((String)("tile.qmd.particle_chamber.detector." + type.func_176610_l() + ".desc"));
    }

    public static String beamlineInfo() {
        return Lang.localise((String)"tile.qmd.beamline.desc");
    }

    public static String beamlineFixedlineInfo() {
        return Lang.localise((String)"info.qmd.beamline.attenuation", (Object[])new Object[]{QMDConfig.beamAttenuationRate});
    }

    public static String[][] neutronShieldFixedInfo() {
        BlockTypes.NeutronShieldType[] values = BlockTypes.NeutronShieldType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = new String[]{Lang.localise((String)"info.nuclearcraft.fission_shield.heat_per_flux.fixd", (Object[])new Object[]{UnitHelper.prefix((double)values[i].getHeatPerFlux(), (int)5, (String)"H/t/N")}), Lang.localise((String)"info.nuclearcraft.fission_shield.efficiency.fixd", (Object[])new Object[]{Math.round(100.0 * values[i].getEfficiency()) + "%"})};
        }
        return info;
    }

    public static String[][] neutronShieldInfo() {
        BlockTypes.NeutronShieldType[] values = BlockTypes.NeutronShieldType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = InfoHelper.formattedInfo((String)Lang.localise((String)"tile.nuclearcraft.fission_shield.desc"), (Object[])new Object[0]);
        }
        return info;
    }

    public static String[][] heaterFixedInfo() {
        return QMDInfo.heaterFixedInfo((Enum[])BlockTypes.HeaterType.values());
    }

    private static <T extends Enum<T> & ICoolerEnum> String[][] heaterFixedInfo(T[] values) {
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = new String[]{QMDInfo.coolerCoolingRateString(values[i])};
        }
        return info;
    }

    public static String drillInfo(int id) {
        int size = 2 * QMDConfig.drill_radius[id] + 1;
        return Lang.localise((String)"info.qmd.item.drill.desc", (Object[])new Object[]{size, size});
    }
}

